/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.nearcache.ClientNearCacheType;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientCallFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.client.MapAddEntryListenerRequest;
import com.hazelcast.map.client.MapAddIndexRequest;
import com.hazelcast.map.client.MapAddInterceptorRequest;
import com.hazelcast.map.client.MapClearRequest;
import com.hazelcast.map.client.MapContainsKeyRequest;
import com.hazelcast.map.client.MapContainsValueRequest;
import com.hazelcast.map.client.MapDeleteRequest;
import com.hazelcast.map.client.MapEntrySetRequest;
import com.hazelcast.map.client.MapEvictRequest;
import com.hazelcast.map.client.MapExecuteOnAllKeysRequest;
import com.hazelcast.map.client.MapExecuteOnKeyRequest;
import com.hazelcast.map.client.MapExecuteOnKeysRequest;
import com.hazelcast.map.client.MapExecuteWithPredicateRequest;
import com.hazelcast.map.client.MapFlushRequest;
import com.hazelcast.map.client.MapGetAllRequest;
import com.hazelcast.map.client.MapGetEntryViewRequest;
import com.hazelcast.map.client.MapGetRequest;
import com.hazelcast.map.client.MapIsLockedRequest;
import com.hazelcast.map.client.MapKeySetRequest;
import com.hazelcast.map.client.MapLockRequest;
import com.hazelcast.map.client.MapPutAllRequest;
import com.hazelcast.map.client.MapPutIfAbsentRequest;
import com.hazelcast.map.client.MapPutRequest;
import com.hazelcast.map.client.MapPutTransientRequest;
import com.hazelcast.map.client.MapQueryRequest;
import com.hazelcast.map.client.MapRemoveEntryListenerRequest;
import com.hazelcast.map.client.MapRemoveIfSameRequest;
import com.hazelcast.map.client.MapRemoveInterceptorRequest;
import com.hazelcast.map.client.MapRemoveRequest;
import com.hazelcast.map.client.MapReplaceIfSameRequest;
import com.hazelcast.map.client.MapReplaceRequest;
import com.hazelcast.map.client.MapSetRequest;
import com.hazelcast.map.client.MapSizeRequest;
import com.hazelcast.map.client.MapTryPutRequest;
import com.hazelcast.map.client.MapTryRemoveRequest;
import com.hazelcast.map.client.MapUnlockRequest;
import com.hazelcast.map.client.MapValuesRequest;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.SortedQueryResultSet;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.executor.CompletedFuture;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    private final String name;
    private volatile ClientNearCache<Data> nearCache;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();

    public ClientMapProxy(String instanceName, String serviceName, String name) {
        super(instanceName, serviceName, name);
        this.name = name;
    }

    @Override
    public boolean containsKey(Object key) {
        Data keyData = this.toData(key);
        MapContainsKeyRequest request = new MapContainsKeyRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        Data valueData = this.toData(value);
        MapContainsValueRequest request = new MapContainsValueRequest(this.name, valueData);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public V get(Object key) {
        Object cached;
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            if (cached.equals(ClientNearCache.NULL_OBJECT)) {
                return null;
            }
            return (V)cached;
        }
        MapGetRequest request = new MapGetRequest(this.name, keyData);
        Object result = this.invoke((ClientRequest)request, keyData);
        if (this.nearCache != null) {
            this.nearCache.put(keyData, result);
        }
        return (V)result;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, -1L, null);
    }

    @Override
    public V remove(Object key) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapRemoveIfSameRequest request = new MapRemoveIfSameRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public void delete(Object key) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapDeleteRequest request = new MapDeleteRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void flush() {
        MapFlushRequest request = new MapFlushRequest(this.name);
        this.invoke(request);
    }

    @Override
    public Future<V> getAsync(K key) {
        Object cached;
        this.initNearCache();
        final Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null && !ClientNearCache.NULL_OBJECT.equals(cached)) {
            return new CompletedFuture(this.getContext().getSerializationService(), cached, this.getContext().getExecutionService().getAsyncExecutor());
        }
        MapGetRequest request = new MapGetRequest(this.name, keyData);
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            DelegatingFuture delegatingFuture = new DelegatingFuture(future, this.getContext().getSerializationService());
            delegatingFuture.andThen(new ExecutionCallback<V>(){

                @Override
                public void onResponse(V response) {
                    if (ClientMapProxy.this.nearCache != null) {
                        ClientMapProxy.this.nearCache.put(keyData, response);
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                }
            });
            return delegatingFuture;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Future<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, null);
    }

    @Override
    public Future<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Future<V> removeAsync(K key) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        this.invalidateNearCache(keyData);
        MapTryRemoveRequest request = new MapTryRemoveRequest(this.name, keyData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapTryPutRequest request = new MapTryPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutTransientRequest request = new MapPutTransientRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke(request);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, null);
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapPutIfAbsentRequest request = new MapPutIfAbsentRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        this.invalidateNearCache(keyData);
        MapReplaceIfSameRequest request = new MapReplaceIfSameRequest(this.name, keyData, oldValueData, newValueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public V replace(K key, V value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapReplaceRequest request = new MapReplaceRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        return (V)this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.invalidateNearCache(keyData);
        MapSetRequest request = new MapSetRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void lock(K key) {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L);
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public boolean isLocked(K key) {
        Data keyData = this.toData(key);
        MapIsLockedRequest request = new MapIsLockedRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, timeunit));
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    @Override
    public void unlock(K key) {
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), false);
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void forceUnlock(K key) {
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), true);
        this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        MapAddInterceptorRequest request = new MapAddInterceptorRequest(this.name, interceptor);
        return (String)this.invoke(request);
    }

    @Override
    public void removeInterceptor(String id) {
        MapRemoveInterceptorRequest request = new MapRemoveInterceptorRequest(this.name, id);
        this.invoke(request);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, handler);
    }

    @Override
    public boolean removeEntryListener(String id) {
        MapRemoveEntryListenerRequest request = new MapRemoveEntryListenerRequest(this.name, id);
        return this.stopListening(request, id);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue, predicate);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, boolean includeValue) {
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, null, includeValue, predicate);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, null, handler);
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        Data keyData = this.toData(key);
        MapGetEntryViewRequest request = new MapGetEntryViewRequest(this.name, keyData);
        SimpleEntryView entryView = (SimpleEntryView)this.invoke((ClientRequest)request, keyData);
        if (entryView == null) {
            return null;
        }
        Data value = (Data)entryView.getValue();
        entryView.setKey(key);
        entryView.setValue(this.toObject(value));
        return entryView;
    }

    @Override
    public boolean evict(K key) {
        Data keyData = this.toData(key);
        MapEvictRequest request = new MapEvictRequest(this.name, keyData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Set<K> keySet() {
        MapKeySetRequest request = new MapKeySetRequest(this.name);
        MapKeySet mapKeySet = (MapKeySet)this.invoke(request);
        Set<Data> keySetData = mapKeySet.getKeySet();
        HashSet keySet = new HashSet(keySetData.size());
        for (Data data : keySetData) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        this.initNearCache();
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        HashMap result = new HashMap();
        for (Object key : keys) {
            keySet.add(this.toData(key));
        }
        if (this.nearCache != null) {
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Object key;
                key = (Data)iterator.next();
                Object cached = this.nearCache.get((Data)key);
                if (cached == null || ClientNearCache.NULL_OBJECT.equals(cached)) continue;
                result.put(this.toObject(key), cached);
                iterator.remove();
            }
        }
        if (keys.isEmpty()) {
            return result;
        }
        MapGetAllRequest request = new MapGetAllRequest(this.name, keySet);
        MapEntrySet mapEntrySet = (MapEntrySet)this.invoke(request);
        Set<Map.Entry<Data, Data>> entrySet = mapEntrySet.getEntrySet();
        for (Map.Entry<Data, Data> dataEntry : entrySet) {
            Object value = this.toObject(dataEntry.getValue());
            Object key = this.toObject(dataEntry.getKey());
            result.put(key, value);
            if (this.nearCache == null) continue;
            this.nearCache.put(dataEntry.getKey(), value);
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        MapValuesRequest request = new MapValuesRequest(this.name);
        MapValueCollection mapValueCollection = (MapValueCollection)this.invoke(request);
        Collection<Data> collectionData = mapValueCollection.getValues();
        ArrayList collection = new ArrayList(collectionData.size());
        for (Data data : collectionData) {
            Object value = this.toObject(data);
            collection.add(value);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        MapEntrySetRequest request = new MapEntrySetRequest(this.name);
        MapEntrySet result = (MapEntrySet)this.invoke(request);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<Data, Data>> entries = result.getEntrySet();
        for (Map.Entry<Data, Data> dataEntry : entries) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.KEY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.keySet(pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.KEY);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        if (pagingPredicate == null) {
            HashSet keySet = new HashSet();
            for (Object o : result) {
                Object key = this.toObject(o);
                keySet.add(key);
            }
            return keySet;
        }
        Comparator<Map.Entry> comparator = SortingUtil.newComparator(pagingPredicate.getComparator(), IterationType.KEY);
        SortedQueryResultSet sortedResult = new SortedQueryResultSet(comparator, IterationType.KEY, pagingPredicate.getPageSize());
        Iterator<Map.Entry> iterator = result.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            sortedResult.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, sortedResult.last());
        return sortedResult;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.ENTRY);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.entrySet(pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.ENTRY);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        AbstractSet entrySet = pagingPredicate == null ? new HashSet(result.size()) : new SortedQueryResultSet(pagingPredicate.getComparator(), IterationType.ENTRY, pagingPredicate.getPageSize());
        for (Object data : result) {
            AbstractMap.SimpleImmutableEntry dataEntry = (AbstractMap.SimpleImmutableEntry)data;
            Object key = this.toObject(dataEntry.getKey());
            Object value = this.toObject(dataEntry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        if (pagingPredicate != null) {
            PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, ((SortedQueryResultSet)entrySet).last());
        }
        return entrySet;
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        PagingPredicate pagingPredicate = null;
        if (predicate instanceof PagingPredicate) {
            pagingPredicate = (PagingPredicate)predicate;
            pagingPredicate.setIterationType(IterationType.VALUE);
            if (pagingPredicate.getPage() > 0 && pagingPredicate.getAnchor() == null) {
                pagingPredicate.previousPage();
                this.values(pagingPredicate);
                pagingPredicate.nextPage();
            }
        }
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.VALUE);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        if (pagingPredicate == null) {
            ArrayList values = new ArrayList(result.size());
            for (Object data : result) {
                Object value = this.toObject(data);
                values.add(value);
            }
            return values;
        }
        List valueEntryList = new ArrayList(result.size());
        Iterator<Map.Entry> iterator = result.rawIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            valueEntryList.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        Collections.sort(valueEntryList, SortingUtil.newComparator(pagingPredicate.getComparator(), IterationType.VALUE));
        if (valueEntryList.size() > pagingPredicate.getPageSize()) {
            valueEntryList = valueEntryList.subList(0, pagingPredicate.getPageSize());
        }
        Map.Entry anchor = null;
        if (valueEntryList.size() != 0) {
            anchor = (Map.Entry)valueEntryList.get(valueEntryList.size() - 1);
        }
        PagingPredicateAccessor.setPagingPredicateAnchor(pagingPredicate, anchor);
        ArrayList values = new ArrayList(valueEntryList.size());
        for (Map.Entry objectVEntry : valueEntryList) {
            values.add(objectVEntry.getValue());
        }
        return values;
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public void addIndex(String attribute, boolean ordered) {
        MapAddIndexRequest request = new MapAddIndexRequest(this.name, attribute, ordered);
        this.invoke(request);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        this.initNearCache();
        LocalMapStatsImpl localMapStats = new LocalMapStatsImpl();
        if (this.nearCache != null) {
            localMapStats.setNearCacheStats(this.nearCache.getNearCacheStats());
        }
        return localMapStats;
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        return this.invoke((ClientRequest)request, keyData);
    }

    @Override
    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        try {
            ClientCallFuture future = (ClientCallFuture)this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            future.andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Future submitToKey(K key, EntryProcessor entryProcessor) {
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        try {
            ICompletableFuture future = this.getContext().getInvocationService().invokeOnKeyOwner(request, keyData);
            return new DelegatingFuture(future, this.getContext().getSerializationService());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        MapExecuteOnAllKeysRequest request = new MapExecuteOnAllKeysRequest(this.name, entryProcessor);
        MapEntrySet entrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        for (Map.Entry<Data, Data> dataEntry : entrySet.getEntrySet()) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        MapExecuteWithPredicateRequest request = new MapExecuteWithPredicateRequest(this.name, entryProcessor, predicate);
        MapEntrySet entrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        for (Map.Entry<Data, Data> dataEntry : entrySet.getEntrySet()) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        HashSet<Data> dataKeys = new HashSet<Data>(keys.size());
        for (K key : keys) {
            dataKeys.add(this.toData(key));
        }
        MapExecuteOnKeysRequest request = new MapExecuteOnKeysRequest(this.name, entryProcessor, dataKeys);
        MapEntrySet entrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        for (Map.Entry<Data, Data> dataEntry : entrySet.getEntrySet()) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, null);
    }

    @Override
    public int size() {
        MapSizeRequest request = new MapSizeRequest(this.name);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        MapEntrySet entrySet = new MapEntrySet();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Data keyData = this.toData(entry.getKey());
            this.invalidateNearCache(keyData);
            entrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, this.toData(entry.getValue())));
        }
        MapPutAllRequest request = new MapPutAllRequest(this.name, entrySet);
        this.invoke(request);
    }

    @Override
    public void clear() {
        MapClearRequest request = new MapClearRequest(this.name);
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
        this.destroyNearCache();
    }

    private void destroyNearCache() {
        if (this.nearCache != null) {
            this.nearCache.destroy();
        }
    }

    @Override
    protected void onShutdown() {
        this.destroyNearCache();
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener, final boolean includeValue) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                Object value = null;
                Object oldValue = null;
                if (includeValue) {
                    value = ClientMapProxy.this.toObject(event.getValue());
                    oldValue = ClientMapProxy.this.toObject(event.getOldValue());
                }
                Object key = ClientMapProxy.this.toObject(event.getKey());
                MemberImpl member = ClientMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                EntryEvent<Object, Object> entryEvent = new EntryEvent<Object, Object>(ClientMapProxy.this.name, member, event.getEventType().getType(), key, oldValue, value);
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(entryEvent);
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(entryEvent);
                        break;
                    }
                    case UPDATED: {
                        listener.entryUpdated(entryEvent);
                        break;
                    }
                    case EVICTED: {
                        listener.entryEvicted(entryEvent);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a known event type " + (Object)((Object)event.getEventType()));
                    }
                }
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    private void invalidateNearCache(Data key) {
        if (this.nearCache != null) {
            this.nearCache.invalidate(key);
        }
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
            if (nearCacheConfig == null) {
                return;
            }
            ClientNearCache _nearCache = new ClientNearCache(this.name, ClientNearCacheType.Map, this.getContext(), nearCacheConfig);
            this.nearCache = _nearCache;
        }
    }

    public String toString() {
        return "IMap{name='" + this.getName() + '\'' + '}';
    }
}

