/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.SortingUtil;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PagingPredicate
implements IndexAwarePredicate,
DataSerializable {
    private Predicate predicate;
    private Comparator<Map.Entry> comparator;
    private int pageSize;
    private int page;
    private final Map<Integer, Map.Entry> anchorMap = new LinkedHashMap<Integer, Map.Entry>();
    private IterationType iterationType;

    public PagingPredicate() {
    }

    public PagingPredicate(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize should be greater than 0 !!!");
        }
        this.pageSize = pageSize;
    }

    public PagingPredicate(Predicate predicate, int pageSize) {
        this(pageSize);
        this.setInnerPredicate(predicate);
    }

    public PagingPredicate(Comparator<Map.Entry> comparator, int pageSize) {
        this(pageSize);
        this.comparator = comparator;
    }

    public PagingPredicate(Predicate predicate, Comparator<Map.Entry> comparator, int pageSize) {
        this(pageSize);
        this.setInnerPredicate(predicate);
        this.comparator = comparator;
    }

    private void setInnerPredicate(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            throw new IllegalArgumentException("Nested PagingPredicate is not supported!!!");
        }
        this.predicate = predicate;
    }

    @Override
    public Set<QueryableEntry> filter(QueryContext queryContext) {
        if (this.predicate instanceof IndexAwarePredicate) {
            Set<QueryableEntry> set = ((IndexAwarePredicate)this.predicate).filter(queryContext);
            if (set == null) {
                return null;
            }
            List<QueryableEntry> list = new LinkedList<QueryableEntry>();
            Map.Entry anchor = this.getAnchor();
            for (QueryableEntry entry : set) {
                if (anchor != null && SortingUtil.compare(this.comparator, this.iterationType, anchor, entry) >= 0) continue;
                list.add(entry);
            }
            Collections.sort(list, SortingUtil.newComparator(this));
            if (list.size() > this.pageSize) {
                list = list.subList(0, this.pageSize);
            }
            return new LinkedHashSet<QueryableEntry>(list);
        }
        return null;
    }

    @Override
    public boolean isIndexed(QueryContext queryContext) {
        if (this.predicate instanceof IndexAwarePredicate) {
            return ((IndexAwarePredicate)this.predicate).isIndexed(queryContext);
        }
        return false;
    }

    public boolean apply(Map.Entry mapEntry) {
        if (this.predicate != null) {
            return this.predicate.apply(mapEntry);
        }
        return true;
    }

    void setAnchor(Map.Entry anchor) {
        if (anchor == null) {
            this.previousPage();
            return;
        }
        this.anchorMap.put(this.page + 1, anchor);
    }

    public void reset() {
        this.iterationType = null;
        this.anchorMap.clear();
        this.page = 0;
    }

    public void nextPage() {
        ++this.page;
    }

    public void previousPage() {
        if (this.page != 0) {
            --this.page;
        }
    }

    public IterationType getIterationType() {
        return this.iterationType;
    }

    public void setIterationType(IterationType iterationType) {
        this.iterationType = iterationType;
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Comparator<Map.Entry> getComparator() {
        return this.comparator;
    }

    public Map.Entry getAnchor() {
        return this.anchorMap.get(this.page);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.predicate);
        out.writeObject(this.comparator);
        out.writeInt(this.page);
        out.writeInt(this.pageSize);
        out.writeUTF(this.iterationType.name());
        out.writeInt(this.anchorMap.size());
        for (Map.Entry<Integer, Map.Entry> entry : this.anchorMap.entrySet()) {
            out.writeInt(entry.getKey());
            Map.Entry anchorEntry = entry.getValue();
            out.writeObject(anchorEntry.getKey());
            out.writeObject(anchorEntry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.predicate = (Predicate)in.readObject();
        this.comparator = (Comparator)in.readObject();
        this.page = in.readInt();
        this.pageSize = in.readInt();
        this.iterationType = IterationType.valueOf(in.readUTF());
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            int key = in.readInt();
            Object anchorKey = in.readObject();
            Object anchorValue = in.readObject();
            this.anchorMap.put(key, new AbstractMap.SimpleImmutableEntry(anchorKey, anchorValue));
        }
    }
}

