/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.list;

import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionItem;
import com.hazelcast.collection.CollectionRemoveBackupOperation;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ListRemoveOperation
extends CollectionBackupAwareOperation {
    private int index;
    private long itemId;

    public ListRemoveOperation() {
    }

    public ListRemoveOperation(String name, int index) {
        super(name);
        this.index = index;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionRemoveBackupOperation(this.name, this.itemId);
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.LIST_REMOVE;
    }

    @Override
    public void beforeRun() throws Exception {
        this.publishEvent(ItemEventType.ADDED, (Data)this.response);
    }

    @Override
    public void run() throws Exception {
        CollectionItem item = this.getOrCreateListContainer().remove(this.index);
        this.itemId = item.getItemId();
        this.response = item.getValue();
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.index);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.index = in.readInt();
    }
}

