/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.proxy;

import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.topic.PublishOperation;
import com.hazelcast.topic.TopicService;
import com.hazelcast.topic.proxy.TopicProxy;
import com.hazelcast.util.ExceptionUtil;

public class TotalOrderedTopicProxy
extends TopicProxy {
    private final int partitionId;

    public TotalOrderedTopicProxy(String name, NodeEngine nodeEngine, TopicService service) {
        super(name, nodeEngine, service);
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    @Override
    public void publish(Object message) {
        try {
            NodeEngine nodeEngine = this.getNodeEngine();
            PublishOperation operation = new PublishOperation(this.getName(), nodeEngine.toData(message));
            InternalCompletableFuture f = nodeEngine.getOperationService().invokeOnPartition("hz:impl:topicService", operation, this.partitionId);
            f.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }
}

