/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.proxy;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.MessageListener;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InitializingObject;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.topic.TopicEvent;
import com.hazelcast.topic.TopicService;
import com.hazelcast.util.ExceptionUtil;

abstract class TopicProxySupport
extends AbstractDistributedObject<TopicService>
implements InitializingObject {
    private final String name;

    TopicProxySupport(String name, NodeEngine nodeEngine, TopicService service) {
        super(nodeEngine, service);
        this.name = name;
    }

    @Override
    public void initialize() {
        NodeEngine nodeEngine = this.getNodeEngine();
        TopicConfig config = nodeEngine.getConfig().findTopicConfig(this.name);
        for (ListenerConfig listenerConfig : config.getMessageListenerConfigs()) {
            this.initialize(listenerConfig);
        }
    }

    private void initialize(ListenerConfig listenerConfig) {
        MessageListener listener;
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            listener = (MessageListener)listenerConfig.getImplementation();
            if (listener == null && listenerConfig.getClassName() != null) {
                listener = (MessageListener)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), listenerConfig.getClassName());
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        if (listener != null) {
            if (listener instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)listener)).setHazelcastInstance(nodeEngine.getHazelcastInstance());
            }
            this.addMessageListenerInternal(listener);
        }
    }

    public LocalTopicStats getLocalTopicStatsInternal() {
        return ((TopicService)this.getService()).getLocalTopicStats(this.name);
    }

    public void publishInternal(Data message) {
        TopicEvent topicEvent = new TopicEvent(this.name, message, this.getNodeEngine().getLocalMember());
        TopicService topicService = (TopicService)this.getService();
        topicService.getLocalTopicStats(this.name).incrementPublishes();
        topicService.publishEvent(this.name, topicEvent);
    }

    public String addMessageListenerInternal(MessageListener listener) {
        return ((TopicService)this.getService()).addMessageListener(this.name, listener);
    }

    public boolean removeMessageListenerInternal(String registrationId) {
        return ((TopicService)this.getService()).removeMessageListener(this.name, registrationId);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public String getName() {
        return this.name;
    }
}

