/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.query.impl.DateHelper;
import com.hazelcast.query.impl.IndexImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;

class TypeConverters {
    public static final TypeConverter BIG_INTEGER_CONVERTER = new BigIntegerConverter();
    public static final TypeConverter BIG_DECIMAL_CONVERTER = new BigDecimalConverter();
    public static final TypeConverter DOUBLE_CONVERTER = new DoubleConverter();
    public static final TypeConverter LONG_CONVERTER = new LongConverter();
    public static final TypeConverter INTEGER_CONVERTER = new IntegerConverter();
    public static final TypeConverter BOOLEAN_CONVERTER = new BooleanConverter();
    public static final TypeConverter SHORT_CONVERTER = new ShortConverter();
    public static final TypeConverter FLOAT_CONVERTER = new FloatConverter();
    public static final TypeConverter STRING_CONVERTER = new StringConverter();
    public static final TypeConverter CHAR_CONVERTER = new CharConverter();
    public static final TypeConverter BYTE_CONVERTER = new ByteConverter();
    public static final TypeConverter ENUM_CONVERTER = new EnumConverter();
    public static final TypeConverter SQL_DATE_CONVERTER = new SqlDateConverter();
    public static final TypeConverter SQL_TIMESTAMP_CONVERTER = new SqlTimestampConverter();
    public static final TypeConverter DATE_CONVERTER = new DateConverter();

    private TypeConverters() {
    }

    static class CharConverter
    implements TypeConverter {
        CharConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value.getClass() == Character.TYPE) {
                return value;
            }
            if (value instanceof Character) {
                return value;
            }
            if (value instanceof String) {
                return Character.valueOf(((String)((Object)value)).charAt(0));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Integer.valueOf(number.intValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to char");
        }
    }

    static class ByteConverter
    implements TypeConverter {
        ByteConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Byte) {
                return value;
            }
            if (value instanceof String) {
                return Byte.valueOf(Byte.parseByte((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Byte.valueOf(number.byteValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to byte");
        }
    }

    static class BooleanConverter
    implements TypeConverter {
        BooleanConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Boolean) {
                return value;
            }
            if (value instanceof String) {
                return Boolean.valueOf(Boolean.parseBoolean((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Boolean.valueOf(number.intValue() != 0);
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to boolean");
        }
    }

    static class ShortConverter
    implements TypeConverter {
        ShortConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Short) {
                return value;
            }
            if (value instanceof String) {
                return Short.valueOf(Short.parseShort((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Short.valueOf(number.shortValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to short");
        }
    }

    static class FloatConverter
    implements TypeConverter {
        FloatConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Float) {
                return value;
            }
            if (value instanceof String) {
                return Float.valueOf(Float.parseFloat((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Float.valueOf(number.floatValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to float");
        }
    }

    static class StringConverter
    implements TypeConverter {
        StringConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof String) {
                return value;
            }
            if (value == null) {
                return IndexImpl.NULL;
            }
            return value.toString();
        }
    }

    static class IntegerConverter
    implements TypeConverter {
        IntegerConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Integer) {
                return value;
            }
            if (value instanceof String) {
                return Integer.valueOf(Integer.parseInt((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Integer.valueOf(number.intValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to integer");
        }
    }

    static class BigDecimalConverter
    implements TypeConverter {
        BigDecimalConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof BigDecimal) {
                return value;
            }
            if (value instanceof BigInteger) {
                return new BigDecimal((BigInteger)value);
            }
            return new BigDecimal(value.toString());
        }
    }

    static class BigIntegerConverter
    implements TypeConverter {
        BigIntegerConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof BigInteger) {
                return value;
            }
            return new BigInteger(value.toString());
        }
    }

    static class LongConverter
    implements TypeConverter {
        LongConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Long) {
                return value;
            }
            if (value instanceof String) {
                return Long.valueOf(Long.parseLong((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Long.valueOf(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to long");
        }
    }

    static class DoubleConverter
    implements TypeConverter {
        DoubleConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Double) {
                return value;
            }
            if (value instanceof String) {
                return Double.valueOf(Double.parseDouble((String)((Object)value)));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return Double.valueOf(number.doubleValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to double");
        }
    }

    static class DateConverter
    implements TypeConverter {
        DateConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof java.util.Date) {
                return value;
            }
            if (value instanceof String) {
                return DateHelper.parseDate((String)((Object)value));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return new java.util.Date(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to java.util.Date");
        }
    }

    static class SqlTimestampConverter
    implements TypeConverter {
        SqlTimestampConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Timestamp) {
                return value;
            }
            if (value instanceof String) {
                return DateHelper.parseTimeStamp((String)((Object)value));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return new Timestamp(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to java.sql.Timestamp");
        }
    }

    static class SqlDateConverter
    implements TypeConverter {
        SqlDateConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value instanceof Date) {
                return value;
            }
            if (value instanceof String) {
                return DateHelper.parseSqlDate((String)((Object)value));
            }
            if (value instanceof Number) {
                Number number = (Number)((Object)value);
                return new Date(number.longValue());
            }
            throw new IllegalArgumentException("Cannot convert [" + value + "] to java.sql.Date");
        }
    }

    static class EnumConverter
    implements TypeConverter {
        EnumConverter() {
        }

        @Override
        public Comparable convert(Comparable value) {
            if (value == null) {
                return null;
            }
            String enumString = value.toString();
            if (enumString.contains(".")) {
                enumString = enumString.substring(1 + enumString.lastIndexOf("."));
            }
            return enumString;
        }
    }

    public static interface TypeConverter {
        public Comparable convert(Comparable var1);
    }
}

