/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.operations;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.multimap.operations.MultiMapKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import java.io.IOException;

public abstract class MultiMapBackupAwareOperation
extends MultiMapKeyBasedOperation
implements BackupAwareOperation,
WaitSupport {
    protected long threadId;

    protected MultiMapBackupAwareOperation() {
    }

    protected MultiMapBackupAwareOperation(String name, Data dataKey, long threadId) {
        super(name, dataKey);
        this.threadId = threadId;
    }

    @Override
    public boolean shouldBackup() {
        return this.response != null;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.threadId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.threadId = in.readLong();
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:multiMapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        return !this.getOrCreateContainer().canAcquireLock(this.dataKey, this.getCallerUuid(), this.threadId);
    }

    @Override
    public long getWaitTimeoutMillis() {
        return -1L;
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }
}

