/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class NearCacheStatsImpl
implements NearCacheStats {
    private long ownedEntryCount;
    private long ownedEntryMemoryCost;
    private long creationTime;
    private AtomicLong hits = new AtomicLong(0L);
    private AtomicLong misses = new AtomicLong(0L);

    public NearCacheStatsImpl() {
        this.creationTime = Clock.currentTimeMillis();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getOwnedEntryCount() {
        return this.ownedEntryCount;
    }

    public void setOwnedEntryCount(long ownedEntryCount) {
        this.ownedEntryCount = ownedEntryCount;
    }

    @Override
    public long getOwnedEntryMemoryCost() {
        return this.ownedEntryMemoryCost;
    }

    @Override
    public long getHits() {
        return this.hits.get();
    }

    @Override
    public long getMisses() {
        return this.misses.get();
    }

    public void setHits(long hits) {
        this.hits.set(hits);
    }

    @Override
    public double getRatio() {
        return (double)this.hits.get() / (double)this.misses.get();
    }

    public void setOwnedEntryMemoryCost(long ownedEntryMemoryCost) {
        this.ownedEntryMemoryCost = ownedEntryMemoryCost;
    }

    public void incrementMisses() {
        this.misses.incrementAndGet();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.ownedEntryCount);
        out.writeLong(this.ownedEntryMemoryCost);
        out.writeLong(this.hits.get());
        out.writeLong(this.misses.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.ownedEntryCount = in.readLong();
        this.ownedEntryMemoryCost = in.readLong();
        this.hits.set(in.readLong());
        this.misses.set(in.readLong());
    }

    public String toString() {
        return "NearCacheStatsImpl{ownedEntryCount=" + this.ownedEntryCount + ", ownedEntryMemoryCost=" + this.ownedEntryMemoryCost + ", creationTime=" + this.creationTime + ", hits=" + this.hits + ", misses=" + this.misses + ", ratio=" + this.getRatio() + '}';
    }
}

