/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.RecordStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class RecordInfo
implements DataSerializable {
    protected RecordStatistics statistics;
    protected long idleDelayMillis = -1L;
    protected long ttlDelayMillis = -1L;
    protected long mapStoreWriteDelayMillis = -1L;
    protected long mapStoreDeleteDelayMillis = -1L;

    public RecordInfo() {
    }

    public RecordInfo(RecordStatistics statistics, long idleDelayMillis, long ttlDelayMillis, long mapStoreWriteDelayMillis, long mapStoreDeleteDelayMillis) {
        this.statistics = statistics;
        this.idleDelayMillis = idleDelayMillis;
        this.ttlDelayMillis = ttlDelayMillis;
        this.mapStoreWriteDelayMillis = mapStoreWriteDelayMillis;
        this.mapStoreDeleteDelayMillis = mapStoreDeleteDelayMillis;
    }

    public RecordStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(RecordStatistics statistics) {
        this.statistics = statistics;
    }

    public long getIdleDelayMillis() {
        return this.idleDelayMillis;
    }

    public void setIdleDelayMillis(long idleDelayMillis) {
        this.idleDelayMillis = idleDelayMillis;
    }

    public long getTtlDelayMillis() {
        return this.ttlDelayMillis;
    }

    public void setTtlDelayMillis(long ttlDelayMillis) {
        this.ttlDelayMillis = ttlDelayMillis;
    }

    public long getMapStoreWriteDelayMillis() {
        return this.mapStoreWriteDelayMillis;
    }

    public void setMapStoreWriteDelayMillis(long mapStoreWriteDelayMillis) {
        this.mapStoreWriteDelayMillis = mapStoreWriteDelayMillis;
    }

    public long getMapStoreDeleteDelayMillis() {
        return this.mapStoreDeleteDelayMillis;
    }

    public void setMapStoreDeleteDelayMillis(long mapStoreDeleteDelayMillis) {
        this.mapStoreDeleteDelayMillis = mapStoreDeleteDelayMillis;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (this.statistics != null) {
            out.writeBoolean(true);
            this.statistics.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.idleDelayMillis);
        out.writeLong(this.ttlDelayMillis);
        out.writeLong(this.mapStoreWriteDelayMillis);
        out.writeLong(this.mapStoreDeleteDelayMillis);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        boolean statsEnabled = in.readBoolean();
        if (statsEnabled) {
            this.statistics = new RecordStatistics();
            this.statistics.readData(in);
        }
        this.idleDelayMillis = in.readLong();
        this.ttlDelayMillis = in.readLong();
        this.mapStoreWriteDelayMillis = in.readLong();
        this.mapStoreDeleteDelayMillis = in.readLong();
    }

    public String toString() {
        return "RecordInfo{statistics=" + this.statistics + ", idleDelayMillis=" + this.idleDelayMillis + ", ttlDelayMillis=" + this.ttlDelayMillis + ", mapStoreWriteDelayMillis=" + this.mapStoreWriteDelayMillis + ", mapStoreDeleteDelayMillis=" + this.mapStoreDeleteDelayMillis + '}';
    }
}

