/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStoreFactory;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.map.EvictionProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapService;
import com.hazelcast.map.MapStoreDeleteProcessor;
import com.hazelcast.map.MapStoreWrapper;
import com.hazelcast.map.MapStoreWriteProcessor;
import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.SizeEstimators;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.record.DataRecordFactory;
import com.hazelcast.map.record.ObjectRecordFactory;
import com.hazelcast.map.record.OffHeapRecordFactory;
import com.hazelcast.map.record.RecordFactory;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.EntryTaskSchedulerFactory;
import com.hazelcast.util.scheduler.ScheduleType;
import com.hazelcast.wan.WanReplicationPublisher;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class MapContainer {
    private final String name;
    private final MapConfig mapConfig;
    private final RecordFactory recordFactory;
    private final MapService mapService;
    private final MapStoreWrapper storeWrapper;
    private final List<MapInterceptor> interceptors;
    private final Map<String, MapInterceptor> interceptorMap;
    private final IndexService indexService = new IndexService();
    private final boolean nearCacheEnabled;
    private final EntryTaskScheduler idleEvictionScheduler;
    private final EntryTaskScheduler ttlEvictionScheduler;
    private final EntryTaskScheduler mapStoreWriteScheduler;
    private final EntryTaskScheduler mapStoreDeleteScheduler;
    private final WanReplicationPublisher wanReplicationPublisher;
    private final MapMergePolicy wanMergePolicy;
    private final SizeEstimator nearCacheSizeEstimator;
    private final Map<Data, Object> initialKeys = new ConcurrentHashMap<Data, Object>();
    private final PartitioningStrategy partitioningStrategy;
    private final String mapStoreScheduledExecutorName;

    public MapContainer(String name, MapConfig mapConfig, MapService mapService) {
        MapLoader store = null;
        this.name = name;
        this.mapConfig = mapConfig;
        this.mapService = mapService;
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.mapStoreScheduledExecutorName = "hz:scheduled:mapstore:" + name;
        NodeEngine nodeEngine = mapService.getNodeEngine();
        switch (mapConfig.getInMemoryFormat()) {
            case BINARY: {
                this.recordFactory = new DataRecordFactory(mapConfig, nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            case OBJECT: {
                this.recordFactory = new ObjectRecordFactory(mapConfig, nodeEngine.getSerializationService());
                break;
            }
            case OFFHEAP: {
                this.recordFactory = new OffHeapRecordFactory(mapConfig, nodeEngine.getOffHeapStorage(), nodeEngine.getSerializationService(), this.partitioningStrategy);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)mapConfig.getInMemoryFormat()));
            }
        }
        MapStoreConfig mapStoreConfig = mapConfig.getMapStoreConfig();
        if (mapStoreConfig != null && mapStoreConfig.isEnabled()) {
            try {
                String factoryClassName;
                MapStoreFactory factory = (MapStoreFactory)mapStoreConfig.getFactoryImplementation();
                if (factory == null && (factoryClassName = mapStoreConfig.getFactoryClassName()) != null && !"".equals(factoryClassName)) {
                    factory = (MapStoreFactory)ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), factoryClassName);
                }
                MapLoader mapLoader = store = factory == null ? mapStoreConfig.getImplementation() : factory.newMapStore(name, mapStoreConfig.getProperties());
                if (store == null) {
                    String mapStoreClassName = mapStoreConfig.getClassName();
                    store = ClassLoaderUtil.newInstance(nodeEngine.getConfigClassLoader(), mapStoreClassName);
                }
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            this.storeWrapper = new MapStoreWrapper(store, mapConfig.getName(), mapStoreConfig.isEnabled());
        } else {
            this.storeWrapper = null;
        }
        if (this.storeWrapper != null) {
            if (store instanceof MapLoaderLifecycleSupport) {
                ((MapLoaderLifecycleSupport)((Object)store)).init(nodeEngine.getHazelcastInstance(), mapStoreConfig.getProperties(), name);
            }
            this.loadInitialKeys();
            if (mapStoreConfig.getWriteDelaySeconds() > 0) {
                ExecutionService executionService = nodeEngine.getExecutionService();
                executionService.register(this.mapStoreScheduledExecutorName, 1, 100000);
                this.mapStoreWriteScheduler = EntryTaskSchedulerFactory.newScheduler(executionService.getScheduledExecutor(this.mapStoreScheduledExecutorName), new MapStoreWriteProcessor(this, mapService), ScheduleType.FOR_EACH);
                this.mapStoreDeleteScheduler = EntryTaskSchedulerFactory.newScheduler(executionService.getScheduledExecutor(this.mapStoreScheduledExecutorName), new MapStoreDeleteProcessor(this, mapService), ScheduleType.SCHEDULE_IF_NEW);
            } else {
                this.mapStoreDeleteScheduler = null;
                this.mapStoreWriteScheduler = null;
            }
        } else {
            this.mapStoreDeleteScheduler = null;
            this.mapStoreWriteScheduler = null;
        }
        this.ttlEvictionScheduler = EntryTaskSchedulerFactory.newScheduler(nodeEngine.getExecutionService().getDefaultScheduledExecutor(), new EvictionProcessor(nodeEngine, mapService, name), ScheduleType.POSTPONE);
        this.idleEvictionScheduler = EntryTaskSchedulerFactory.newScheduler(nodeEngine.getExecutionService().getDefaultScheduledExecutor(), new EvictionProcessor(nodeEngine, mapService, name), ScheduleType.POSTPONE);
        WanReplicationRef wanReplicationRef = mapConfig.getWanReplicationRef();
        if (wanReplicationRef != null) {
            this.wanReplicationPublisher = nodeEngine.getWanReplicationService().getWanReplicationListener(wanReplicationRef.getName());
            this.wanMergePolicy = mapService.getMergePolicy(wanReplicationRef.getMergePolicy());
        } else {
            this.wanMergePolicy = null;
            this.wanReplicationPublisher = null;
        }
        this.interceptors = new CopyOnWriteArrayList<MapInterceptor>();
        this.interceptorMap = new ConcurrentHashMap<String, MapInterceptor>();
        this.nearCacheEnabled = mapConfig.getNearCacheConfig() != null;
        this.nearCacheSizeEstimator = SizeEstimators.createNearCacheSizeEstimator();
    }

    private PartitioningStrategy createPartitioningStrategy() {
        PartitioningStrategy strategy = null;
        PartitioningStrategyConfig partitioningStrategyConfig = this.mapConfig.getPartitioningStrategyConfig();
        if (partitioningStrategyConfig != null && (strategy = partitioningStrategyConfig.getPartitioningStrategy()) == null && partitioningStrategyConfig.getPartitioningStrategyClass() != null) {
            try {
                strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(this.mapService.getNodeEngine().getConfigClassLoader(), partitioningStrategyConfig.getPartitioningStrategyClass());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return strategy;
    }

    public void loadInitialKeys() {
        this.initialKeys.clear();
        Set keys = this.storeWrapper.loadAllKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (Object key : keys) {
            Data dataKey = this.mapService.toData(key, this.partitioningStrategy);
            this.initialKeys.put(dataKey, key);
        }
        this.mapService.getNodeEngine().getExecutionService().schedule(new Runnable(){

            @Override
            public void run() {
                MapContainer.this.initialKeys.clear();
            }
        }, 20L, TimeUnit.MINUTES);
    }

    public void shutDownMapStoreScheduledExecutor() {
        this.mapService.getNodeEngine().getExecutionService().shutdownExecutor(this.mapStoreScheduledExecutorName);
    }

    public Map<Data, Object> getInitialKeys() {
        return this.initialKeys;
    }

    public EntryTaskScheduler getIdleEvictionScheduler() {
        return this.idleEvictionScheduler;
    }

    public EntryTaskScheduler getTtlEvictionScheduler() {
        return this.ttlEvictionScheduler;
    }

    public EntryTaskScheduler getMapStoreWriteScheduler() {
        return this.mapStoreWriteScheduler;
    }

    public EntryTaskScheduler getMapStoreDeleteScheduler() {
        return this.mapStoreDeleteScheduler;
    }

    public IndexService getIndexService() {
        return this.indexService;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public String addInterceptor(MapInterceptor interceptor) {
        String id = UuidUtil.buildRandomUuidString();
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
        return id;
    }

    public void addInterceptor(String id, MapInterceptor interceptor) {
        this.interceptorMap.put(id, interceptor);
        this.interceptors.add(interceptor);
    }

    public List<MapInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, MapInterceptor> getInterceptorMap() {
        return this.interceptorMap;
    }

    public void removeInterceptor(String id) {
        MapInterceptor interceptor = this.interceptorMap.remove(id);
        this.interceptors.remove(interceptor);
    }

    public String getName() {
        return this.name;
    }

    public boolean isNearCacheEnabled() {
        return this.nearCacheEnabled;
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public long getWriteDelayMillis() {
        return TimeUnit.SECONDS.toMillis(this.mapConfig.getMapStoreConfig().getWriteDelaySeconds());
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public MapStoreWrapper getStore() {
        return this.storeWrapper != null && this.storeWrapper.isEnabled() ? this.storeWrapper : null;
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public MapService getMapService() {
        return this.mapService;
    }
}

