/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.MemberAttributeChangedOperation;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Member;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.operation.MapOperationType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MemberImpl
implements Member,
HazelcastInstanceAware,
IdentifiedDataSerializable {
    private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private boolean localMember;
    private Address address;
    private String uuid;
    private volatile HazelcastInstanceImpl instance;
    private volatile long lastRead = 0L;
    private volatile long lastWrite = 0L;
    private volatile long lastPing = 0L;
    private volatile ILogger logger;

    public MemberImpl() {
    }

    public MemberImpl(Address address, boolean localMember) {
        this(address, localMember, null, null);
    }

    public MemberImpl(Address address, boolean localMember, String uuid, HazelcastInstanceImpl instance) {
        this(address, localMember, uuid, instance, null);
    }

    public MemberImpl(Address address, boolean localMember, String uuid, HazelcastInstanceImpl instance, Map<String, Object> attributes) {
        this();
        this.localMember = localMember;
        this.address = address;
        this.lastRead = Clock.currentTimeMillis();
        this.uuid = uuid;
        this.instance = instance;
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
    }

    public MemberImpl(MemberImpl member) {
        this();
        this.localMember = member.localMember;
        this.address = member.address;
        this.lastRead = member.lastRead;
        this.uuid = member.uuid;
        this.attributes.putAll(member.attributes);
    }

    public Address getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public InetAddress getInetAddress() {
        try {
            return this.address.getInetAddress();
        }
        catch (UnknownHostException e) {
            if (this.logger != null) {
                this.logger.warning(e);
            }
            return null;
        }
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.getSocketAddress();
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        try {
            return this.address.getInetSocketAddress();
        }
        catch (UnknownHostException e) {
            if (this.logger != null) {
                this.logger.warning(e);
            }
            return null;
        }
    }

    @Override
    public boolean localMember() {
        return this.localMember;
    }

    public void didWrite() {
        this.lastWrite = Clock.currentTimeMillis();
    }

    public void didRead() {
        this.lastRead = Clock.currentTimeMillis();
    }

    public void didPing() {
        this.lastPing = Clock.currentTimeMillis();
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public long getLastRead() {
        return this.lastRead;
    }

    public long getLastWrite() {
        return this.lastWrite;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void updateAttribute(MapOperationType operationType, String key, Object value) {
        switch (operationType) {
            case PUT: {
                this.attributes.put(key, value);
                break;
            }
            case REMOVE: {
                this.attributes.remove(key);
            }
        }
    }

    @Override
    public String getStringAttribute(String key) {
        return (String)this.getAttribute(key);
    }

    @Override
    public void setStringAttribute(String key, String value) {
        this.setAttribute(key, value);
    }

    @Override
    public Boolean getBooleanAttribute(String key) {
        return (Boolean)this.getAttribute(key);
    }

    @Override
    public void setBooleanAttribute(String key, boolean value) {
        this.setAttribute(key, value);
    }

    @Override
    public Byte getByteAttribute(String key) {
        return (Byte)this.getAttribute(key);
    }

    @Override
    public void setByteAttribute(String key, byte value) {
        this.setAttribute(key, value);
    }

    @Override
    public Short getShortAttribute(String key) {
        return (Short)this.getAttribute(key);
    }

    @Override
    public void setShortAttribute(String key, short value) {
        this.setAttribute(key, value);
    }

    @Override
    public Integer getIntAttribute(String key) {
        return (Integer)this.getAttribute(key);
    }

    @Override
    public void setIntAttribute(String key, int value) {
        this.setAttribute(key, value);
    }

    @Override
    public Long getLongAttribute(String key) {
        return (Long)this.getAttribute(key);
    }

    @Override
    public void setLongAttribute(String key, long value) {
        this.setAttribute(key, value);
    }

    @Override
    public Float getFloatAttribute(String key) {
        return (Float)this.getAttribute(key);
    }

    @Override
    public void setFloatAttribute(String key, float value) {
        this.setAttribute(key, Float.valueOf(value));
    }

    @Override
    public Double getDoubleAttribute(String key) {
        return (Double)this.getAttribute(key);
    }

    @Override
    public void setDoubleAttribute(String key, double value) {
        this.setAttribute(key, value);
    }

    @Override
    public void removeAttribute(String key) {
        if (!this.localMember) {
            throw new UnsupportedOperationException("Attributes on remote members must not be changed");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        Object value = this.attributes.remove(key);
        if (value == null) {
            return;
        }
        if (this.instance != null) {
            NodeEngineImpl nodeEngine = this.instance.node.nodeEngine;
            OperationService os = nodeEngine.getOperationService();
            MemberAttributeChangedOperation operation = new MemberAttributeChangedOperation(MapOperationType.REMOVE, key, null);
            String uuid = nodeEngine.getLocalMember().getUuid();
            operation.setCallerUuid(uuid).setNodeEngine(nodeEngine);
            try {
                for (MemberImpl member : nodeEngine.getClusterService().getMemberList()) {
                    if (!member.localMember()) {
                        os.send(operation, member.getAddress());
                        continue;
                    }
                    os.executeOperation(operation);
                }
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance instanceof HazelcastInstanceImpl) {
            this.instance = (HazelcastInstanceImpl)hazelcastInstance;
            this.localMember = this.instance.node.address.equals(this.address);
            this.logger = this.instance.node.getLogger(this.getClass().getName());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        this.uuid = in.readUTF();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Object value = IOUtil.readAttributeValue(in);
            this.attributes.put(key, value);
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        out.writeUTF(this.uuid);
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
            out.writeUTF(entry.getKey());
            IOUtil.writeAttributeValue(entry.getValue(), out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Member [");
        sb.append(this.address.getHost());
        sb.append("]");
        sb.append(":");
        sb.append(this.address.getPort());
        if (this.localMember) {
            sb.append(" this");
        }
        return sb.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberImpl other = (MemberImpl)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 2;
    }

    private Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    private void setAttribute(String key, Object value) {
        if (!this.localMember) {
            throw new UnsupportedOperationException("Attributes on remote members must not be changed");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        Object oldValue = this.attributes.put(key, value);
        if (value.equals(oldValue)) {
            return;
        }
        if (this.instance != null) {
            NodeEngineImpl nodeEngine = this.instance.node.nodeEngine;
            OperationService os = nodeEngine.getOperationService();
            MemberAttributeChangedOperation operation = new MemberAttributeChangedOperation(MapOperationType.PUT, key, value);
            String uuid = nodeEngine.getLocalMember().getUuid();
            operation.setCallerUuid(uuid).setNodeEngine(nodeEngine);
            try {
                for (MemberImpl member : nodeEngine.getClusterService().getMemberList()) {
                    if (!member.localMember()) {
                        os.send(operation, member.getAddress());
                        continue;
                    }
                    os.executeOperation(operation);
                }
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }
}

