/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference;

import com.hazelcast.concurrent.atomicreference.AtomicReferenceProxy;
import com.hazelcast.concurrent.atomicreference.ReferenceWrapper;
import com.hazelcast.concurrent.atomicreference.operations.AtomicReferenceReplicationOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AtomicReferenceService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:atomicReferenceService";
    private NodeEngine nodeEngine;
    private final ConcurrentMap<String, ReferenceWrapper> references = new ConcurrentHashMap<String, ReferenceWrapper>();
    private final ConstructorFunction<String, ReferenceWrapper> atomicReferenceConstructorFunction = new ConstructorFunction<String, ReferenceWrapper>(){

        @Override
        public ReferenceWrapper createNew(String key) {
            return new ReferenceWrapper();
        }
    };

    public ReferenceWrapper getReference(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.references, name, this.atomicReferenceConstructorFunction);
    }

    public boolean containsAtomicReference(String name) {
        return this.references.containsKey(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.references.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public AtomicReferenceProxy createDistributedObject(String name) {
        return new AtomicReferenceProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.references.remove(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (event.getReplicaIndex() > 1) {
            return null;
        }
        HashMap<String, Data> data = new HashMap<String, Data>();
        int partitionId = event.getPartitionId();
        for (String name : this.references.keySet()) {
            if (partitionId != this.getPartitionId(name)) continue;
            ReferenceWrapper referenceWrapper = (ReferenceWrapper)this.references.get(name);
            Data value = referenceWrapper.get();
            data.put(name, value);
        }
        return data.isEmpty() ? null : new AtomicReferenceReplicationOperation(data);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent partitionMigrationEvent) {
        if (partitionMigrationEvent.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            int partitionId = partitionMigrationEvent.getPartitionId();
            this.removeReference(partitionId);
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent partitionMigrationEvent) {
        if (partitionMigrationEvent.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            int partitionId = partitionMigrationEvent.getPartitionId();
            this.removeReference(partitionId);
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.removeReference(partitionId);
    }

    public void removeReference(int partitionId) {
        Iterator iterator = this.references.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (this.getPartitionId(name) != partitionId) continue;
            iterator.remove();
        }
    }

    private int getPartitionId(String name) {
        PartitionService partitionService = this.nodeEngine.getPartitionService();
        String partitionKey = StringPartitioningStrategy.getPartitionKey(name);
        return partitionService.getPartitionId(partitionKey);
    }
}

