/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractClusterOperation;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.map.operation.MapOperationType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public class MemberAttributeChangedOperation
extends AbstractClusterOperation {
    public static final byte DELTA_MEMBER_PROPERTIES_OP_PUT = 2;
    public static final byte DELTA_MEMBER_PROPERTIES_OP_REMOVE = 3;
    private MapOperationType operationType;
    private String key;
    private Object value;

    public MemberAttributeChangedOperation() {
    }

    public MemberAttributeChangedOperation(MapOperationType operationType, String key, Object value) {
        if (operationType != MapOperationType.PUT && operationType != MapOperationType.REMOVE) {
            throw new IllegalArgumentException("Only PUT / REMOVE operations are allowed for attribute updates");
        }
        this.operationType = operationType;
        this.key = key;
        this.value = value;
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl cs = (ClusterServiceImpl)this.getService();
        cs.updateMemberAttribute(this.getCallerUuid(), this.operationType, this.key, this.value);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.key);
        switch (this.operationType) {
            case PUT: {
                out.writeByte(2);
                out.writeObject(this.value);
                break;
            }
            case REMOVE: {
                out.writeByte(3);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandeled operationType:" + (Object)((Object)this.operationType));
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.key = in.readUTF();
        byte operation = in.readByte();
        switch (operation) {
            case 2: {
                this.operationType = MapOperationType.PUT;
                this.value = in.readObject();
                break;
            }
            case 3: {
                this.operationType = MapOperationType.REMOVE;
                break;
            }
            default: {
                throw new IllegalStateException("Unhandeled operationType:" + (Object)((Object)this.operationType));
            }
        }
    }
}

