/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.txn.ClientTransactionManager;
import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.TransactionProxy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.transaction.impl.Transaction;
import java.util.UUID;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XaResourceProxy
implements XAResource {
    private final TransactionContextProxy transactionContext;
    private final ClientTransactionManager transactionManager;
    private final ILogger logger;
    private final String uuid = UUID.randomUUID().toString();
    private int transactionTimeoutSeconds;

    public XaResourceProxy(TransactionContextProxy transactionContext) {
        this.transactionContext = transactionContext;
        this.transactionManager = transactionContext.getTransactionManager();
        this.logger = Logger.getLogger(XaResourceProxy.class);
    }

    @Override
    public synchronized void start(Xid xid, int flags) throws XAException {
        this.nullCheck(xid);
        switch (flags) {
            case 0: {
                if (this.getTransaction(xid) != null) {
                    XAException xaException = new XAException(-8);
                    this.logger.severe("Duplicate xid: " + xid, xaException);
                    throw xaException;
                }
                try {
                    TransactionProxy transaction = this.getTransaction();
                    this.transactionManager.addManagedTransaction(xid, transaction);
                    transaction.begin();
                    break;
                }
                catch (IllegalStateException e) {
                    throw new XAException(-5);
                }
            }
            case 0x200000: 
            case 0x8000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    @Override
    public synchronized void end(Xid xid, int flags) throws XAException {
        this.nullCheck(xid);
        TransactionProxy transaction = this.getTransaction();
        SerializableXID sXid = transaction.getXid();
        if (sXid == null || !sXid.equals(xid)) {
            this.logger.severe("started xid: " + sXid + " and given xid : " + xid + " not equal!!!");
        }
        this.validateTx(transaction, Transaction.State.ACTIVE);
        switch (flags) {
            case 0x4000000: {
                break;
            }
            case 0x20000000: {
                try {
                    transaction.rollback();
                    this.transactionManager.removeManagedTransaction(xid);
                    break;
                }
                catch (IllegalStateException e) {
                    throw new XAException(-3);
                }
            }
            case 0x2000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
    }

    @Override
    public synchronized int prepare(Xid xid) throws XAException {
        this.nullCheck(xid);
        TransactionProxy transaction = this.getTransaction();
        SerializableXID sXid = transaction.getXid();
        if (sXid == null || !sXid.equals(xid)) {
            this.logger.severe("started xid: " + sXid + " and given xid : " + xid + " not equal!!!");
        }
        this.validateTx(transaction, Transaction.State.ACTIVE);
        try {
            transaction.prepare();
        }
        catch (TransactionException e) {
            throw new XAException(-3);
        }
        return 0;
    }

    @Override
    public synchronized void commit(Xid xid, boolean onePhase) throws XAException {
        this.nullCheck(xid);
        TransactionProxy transaction = this.getTransaction(xid);
        if (transaction == null) {
            if (this.transactionManager.recover(xid, true)) {
                return;
            }
            XAException xaException = new XAException(-4);
            this.logger.severe("Transaction is not available!!!", xaException);
            throw xaException;
        }
        this.validateTx(transaction, onePhase ? Transaction.State.ACTIVE : Transaction.State.PREPARED);
        try {
            transaction.commit(onePhase);
            this.transactionManager.removeManagedTransaction(xid);
        }
        catch (TransactionException e) {
            throw new XAException(-3);
        }
    }

    @Override
    public synchronized void rollback(Xid xid) throws XAException {
        this.nullCheck(xid);
        TransactionProxy transaction = this.getTransaction(xid);
        if (transaction == null) {
            if (this.transactionManager.recover(xid, false)) {
                return;
            }
            XAException xaException = new XAException(-4);
            this.logger.severe("Transaction is not available!!!", xaException);
            throw xaException;
        }
        this.validateTx(transaction, Transaction.State.NO_TXN);
        try {
            transaction.rollback();
            this.transactionManager.removeManagedTransaction(xid);
        }
        catch (TransactionException e) {
            throw new XAException(-3);
        }
    }

    @Override
    public synchronized void forget(Xid xid) throws XAException {
        throw new XAException(-6);
    }

    @Override
    public synchronized boolean isSameRM(XAResource xaResource) throws XAException {
        if (this == xaResource) {
            return true;
        }
        if (xaResource instanceof XaResourceProxy) {
            XaResourceProxy other = (XaResourceProxy)xaResource;
            return this.transactionManager.equals(other.transactionManager);
        }
        return false;
    }

    @Override
    public synchronized Xid[] recover(int flag) throws XAException {
        return this.transactionManager.recover();
    }

    @Override
    public synchronized int getTransactionTimeout() throws XAException {
        return this.transactionTimeoutSeconds;
    }

    @Override
    public synchronized boolean setTransactionTimeout(int seconds) throws XAException {
        this.transactionTimeoutSeconds = seconds;
        return false;
    }

    private void nullCheck(Xid xid) throws XAException {
        if (xid == null) {
            XAException xaException = new XAException(-5);
            this.logger.severe("Xid cannot be null!!!", xaException);
            throw xaException;
        }
    }

    private TransactionProxy getTransaction() {
        return this.transactionContext.transaction;
    }

    private TransactionProxy getTransaction(Xid xid) {
        return this.transactionManager.getManagedTransaction(xid);
    }

    private void validateTx(TransactionProxy tx, Transaction.State state) throws XAException {
        if (tx == null) {
            XAException xaException = new XAException(-4);
            this.logger.severe("Transaction is not available!!!", xaException);
            throw xaException;
        }
        Transaction.State txState = tx.getState();
        switch (state) {
            case ACTIVE: {
                if (txState == Transaction.State.ACTIVE) break;
                XAException xaException = new XAException(-4);
                this.logger.severe("Transaction is not active!!! state: " + (Object)((Object)txState), xaException);
                throw xaException;
            }
            case PREPARED: {
                if (txState == Transaction.State.PREPARED) break;
                XAException xaException = new XAException(-5);
                this.logger.severe("Transaction is not prepared!!! state: " + (Object)((Object)txState), xaException);
                throw xaException;
            }
        }
    }

    public String toString() {
        String txnId = this.transactionContext.getTxnId();
        StringBuilder sb = new StringBuilder("XAResourceImpl{");
        sb.append("uuid=").append(this.uuid);
        sb.append("txdId=").append(txnId);
        sb.append(", transactionTimeoutSeconds=").append(this.transactionTimeoutSeconds);
        sb.append('}');
        return sb.toString();
    }
}

