/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.topic.client.AddMessageListenerRequest;
import com.hazelcast.topic.client.PortableMessage;
import com.hazelcast.topic.client.PublishRequest;
import com.hazelcast.topic.client.RemoveMessageListenerRequest;

public class ClientTopicProxy<E>
extends ClientProxy
implements ITopic<E> {
    private final String name;
    private volatile Data key;

    public ClientTopicProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    @Override
    public void publish(E message) {
        Data data = this.getContext().getSerializationService().toData(message);
        PublishRequest request = new PublishRequest(this.name, data);
        this.invoke(request);
    }

    @Override
    public String addMessageListener(final MessageListener<E> listener) {
        AddMessageListenerRequest request = new AddMessageListenerRequest(this.name);
        EventHandler<PortableMessage> handler = new EventHandler<PortableMessage>(){

            @Override
            public void handle(PortableMessage event) {
                Object messageObject = ClientTopicProxy.this.getContext().getSerializationService().toObject(event.getMessage());
                MemberImpl member = ClientTopicProxy.this.getContext().getClusterService().getMember(event.getUuid());
                Message message = new Message(ClientTopicProxy.this.name, messageObject, event.getPublishTime(), member);
                listener.onMessage(message);
            }
        };
        return this.listen(request, this.getKey(), handler);
    }

    @Override
    public boolean removeMessageListener(String registrationId) {
        RemoveMessageListenerRequest request = new RemoveMessageListenerRequest(this.name, registrationId);
        return this.stopListening(request, registrationId);
    }

    @Override
    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    protected void onDestroy() {
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData(this.name);
        }
        return this.key;
    }

    @Override
    protected <T> T invoke(ClientRequest req) {
        return super.invoke(req, this.getKey());
    }

    public String toString() {
        return "ITopic{name='" + this.getName() + '\'' + '}';
    }
}

