/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class ClientResponse
implements IdentifiedDataSerializable {
    Data response;
    int callId;
    boolean isEvent;
    boolean isError;

    public ClientResponse() {
    }

    public ClientResponse(Data response, boolean isError, int callId) {
        this.response = response;
        this.isError = isError;
        this.callId = callId;
    }

    public ClientResponse(Data response, int callId, boolean isEvent) {
        this.response = response;
        this.callId = callId;
        this.isEvent = isEvent;
    }

    public Data getResponse() {
        return this.response;
    }

    public int getCallId() {
        return this.callId;
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    public boolean isError() {
        return this.isError;
    }

    @Override
    public int getFactoryId() {
        return ClientDataSerializerHook.ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.callId);
        out.writeBoolean(this.isEvent);
        out.writeBoolean(this.isError);
        this.response.writeData(out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.callId = in.readInt();
        this.isEvent = in.readBoolean();
        this.isError = in.readBoolean();
        this.response = new Data();
        this.response.readData(in);
    }
}

