/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.kubernetes;

import com.hazelcast.kubernetes.DnsEndpointResolver;
import com.hazelcast.kubernetes.KubernetesApiEndpointResolver;
import com.hazelcast.kubernetes.KubernetesClient;
import com.hazelcast.kubernetes.KubernetesConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class HazelcastKubernetesDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private final KubernetesClient client;
    private final EndpointResolver endpointResolver;
    private final Map<String, Object> memberMetadata = new HashMap<String, Object>();

    HazelcastKubernetesDiscoveryStrategy(ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        KubernetesConfig config = new KubernetesConfig(properties);
        logger.info(config.toString());
        this.client = HazelcastKubernetesDiscoveryStrategy.buildKubernetesClient(config);
        this.endpointResolver = KubernetesConfig.DiscoveryMode.DNS_LOOKUP.equals((Object)config.getMode()) ? new DnsEndpointResolver(logger, config.getServiceDns(), config.getServicePort(), config.getServiceDnsTimeout()) : new KubernetesApiEndpointResolver(logger, config.getServiceName(), config.getServicePort(), config.getServiceLabelName(), config.getServiceLabelValue(), config.isResolveNotReadyAddresses(), this.client);
        logger.info("Kubernetes Discovery activated with mode: " + config.getMode().name());
    }

    private static KubernetesClient buildKubernetesClient(KubernetesConfig config) {
        return new KubernetesClient(config.getNamespace(), config.getKubernetesMasterUrl(), config.getKubernetesApiToken(), config.getKubernetesCaCertificate(), config.getKubernetesApiRetries());
    }

    @Override
    public void start() {
        this.endpointResolver.start();
    }

    @Override
    public Map<String, Object> discoverLocalMetadata() {
        if (this.memberMetadata.isEmpty()) {
            this.memberMetadata.put("hazelcast.partition.group.zone", this.discoverZone());
        }
        return this.memberMetadata;
    }

    private String discoverZone() {
        try {
            String zone;
            String podName = System.getenv("POD_NAME");
            if (podName == null) {
                podName = System.getenv("HOSTNAME");
            }
            if (podName == null) {
                podName = InetAddress.getLocalHost().getHostName();
            }
            if ((zone = this.client.zone(podName)) != null) {
                return zone;
            }
        }
        catch (Exception e) {
            this.getLogger().finest(e);
        }
        this.getLogger().warning("Cannot fetch the current zone, ZONE_AWARE feature is disabled");
        return "unknown";
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        return this.endpointResolver.resolve();
    }

    @Override
    public void destroy() {
        this.endpointResolver.destroy();
    }

    static abstract class EndpointResolver {
        protected final ILogger logger;

        EndpointResolver(ILogger logger) {
            this.logger = logger;
        }

        abstract List<DiscoveryNode> resolve();

        void start() {
        }

        void destroy() {
        }

        protected InetAddress mapAddress(String address) {
            if (address == null) {
                return null;
            }
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                this.logger.warning("Address '" + address + "' could not be resolved");
                return null;
            }
        }
    }
}

