/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.session;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPSessionCloseSessionCodec;
import com.hazelcast.client.impl.protocol.codec.CPSessionCreateSessionCodec;
import com.hazelcast.client.impl.protocol.codec.CPSessionGenerateThreadIdCodec;
import com.hazelcast.client.impl.protocol.codec.CPSessionHeartbeatSessionCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.session.AbstractProxySessionManager;
import com.hazelcast.cp.internal.session.SessionResponse;
import com.hazelcast.logging.ILogger;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ClientProxySessionManager
extends AbstractProxySessionManager {
    private static final long SHUTDOWN_TIMEOUT_SECONDS = 60L;
    private static final long SHUTDOWN_WAIT_SLEEP_MILLIS = 10L;
    private static final ClientMessageDecoder HEARTBEAT_RESPONSE_DECODER = new ClientMessageDecoder(){

        public Object decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder CLOSE_SESSION_RESPONSE_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return CPSessionCloseSessionCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private final HazelcastClientInstanceImpl client;

    public ClientProxySessionManager(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    protected long generateThreadId(RaftGroupId groupId) {
        ClientMessage request = CPSessionGenerateThreadIdCodec.encodeRequest(groupId);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, "sessionManager").invoke().join();
        return CPSessionGenerateThreadIdCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    protected SessionResponse requestNewSession(RaftGroupId groupId) {
        ClientMessage request = CPSessionCreateSessionCodec.encodeRequest(groupId, this.client.getName());
        ClientMessage response = (ClientMessage)new ClientInvocation(this.client, request, "sessionManager").invoke().join();
        CPSessionCreateSessionCodec.ResponseParameters params = CPSessionCreateSessionCodec.decodeResponse(response);
        return new SessionResponse(params.sessionId, params.ttlMillis, params.heartbeatMillis);
    }

    @Override
    protected ScheduledFuture<?> scheduleWithRepetition(Runnable task, long period, TimeUnit unit) {
        return this.client.getClientExecutionService().scheduleWithRepetition(task, period, period, unit);
    }

    @Override
    protected ICompletableFuture<Object> heartbeat(RaftGroupId groupId, long sessionId) {
        ClientMessage request = CPSessionHeartbeatSessionCodec.encodeRequest(groupId, sessionId);
        ClientInvocationFuture future = new ClientInvocation(this.client, request, "sessionManager").invoke();
        return new ClientDelegatingFuture<Object>(future, this.client.getSerializationService(), HEARTBEAT_RESPONSE_DECODER);
    }

    @Override
    protected ICompletableFuture<Object> closeSession(RaftGroupId groupId, Long sessionId) {
        ClientMessage request = CPSessionCloseSessionCodec.encodeRequest(groupId, sessionId);
        ClientInvocationFuture future = new ClientInvocation(this.client, request, "sessionManager").invoke();
        return new ClientDelegatingFuture<Object>(future, this.client.getSerializationService(), CLOSE_SESSION_RESPONSE_DECODER);
    }

    @Override
    public Map<RaftGroupId, ICompletableFuture<Object>> shutdown() {
        Map<RaftGroupId, ICompletableFuture<Object>> futures = super.shutdown();
        ILogger logger = this.client.getLoggingService().getLogger(this.getClass());
        for (long remainingTimeNanos = TimeUnit.SECONDS.toNanos(60L); remainingTimeNanos > 0L; remainingTimeNanos -= TimeUnit.MILLISECONDS.toNanos(10L)) {
            int closed = 0;
            for (Map.Entry<RaftGroupId, ICompletableFuture<Object>> entry : futures.entrySet()) {
                CPGroupId groupId = entry.getKey();
                ICompletableFuture<Object> f = entry.getValue();
                if (!f.isDone()) continue;
                ++closed;
                try {
                    f.get();
                    logger.fine("Session closed for " + groupId);
                }
                catch (Exception e) {
                    logger.warning("Close session failed for " + groupId, e);
                }
            }
            if (closed == futures.size()) break;
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return futures;
            }
        }
        return futures;
    }
}

