/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientOutOfMemoryHandler;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.impl.clientside.DefaultClientConnectionManagerFactory;
import com.hazelcast.client.impl.clientside.FailoverClientConfigSupport;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.SetUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class HazelcastClient {
    private static final AtomicInteger CLIENT_ID_GEN = new AtomicInteger();
    private static final ConcurrentMap<String, HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy>> CLIENTS = new ConcurrentHashMap<String, HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy>>(5);

    private HazelcastClient() {
    }

    public static HazelcastInstance newHazelcastClient() {
        return HazelcastClient.newHazelcastClientInternal(null, FailoverClientConfigSupport.resolveClientConfig(null), null);
    }

    public static HazelcastInstance newHazelcastClient(ClientConfig config) {
        return HazelcastClient.newHazelcastClientInternal(null, FailoverClientConfigSupport.resolveClientConfig(config), null);
    }

    public static HazelcastInstance newHazelcastFailoverClient() {
        return HazelcastClient.newHazelcastClientInternal(null, null, FailoverClientConfigSupport.resolveClientFailoverConfig());
    }

    public static HazelcastInstance newHazelcastFailoverClient(ClientFailoverConfig clientFailoverConfig) {
        return HazelcastClient.newHazelcastClientInternal(null, null, FailoverClientConfigSupport.resolveClientFailoverConfig(clientFailoverConfig));
    }

    public static HazelcastInstance getHazelcastClientByName(String instanceName) {
        HazelcastInstanceFactory.InstanceFuture future = (HazelcastInstanceFactory.InstanceFuture)CLIENTS.get(instanceName);
        if (future == null) {
            return null;
        }
        try {
            return (HazelcastInstance)future.get();
        }
        catch (IllegalStateException t) {
            return null;
        }
    }

    public static HazelcastInstance getOrCreateHazelcastClient() {
        return HazelcastClient.getOrCreateClientInternal(null);
    }

    public static HazelcastInstance getOrCreateHazelcastClient(ClientConfig config) {
        return HazelcastClient.getOrCreateClientInternal(config);
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        Set<HazelcastInstance> result = SetUtil.createHashSet(CLIENTS.size());
        for (HazelcastInstanceFactory.InstanceFuture f : CLIENTS.values()) {
            result.add((HazelcastInstance)f.get());
        }
        return Collections.unmodifiableCollection(result);
    }

    public static void shutdownAll() {
        for (HazelcastInstanceFactory.InstanceFuture future : CLIENTS.values()) {
            try {
                HazelcastClientProxy proxy = (HazelcastClientProxy)future.get();
                HazelcastClientInstanceImpl client = proxy.client;
                if (client == null) continue;
                proxy.client = null;
                client.shutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        OutOfMemoryErrorDispatcher.clearClients();
        CLIENTS.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(HazelcastInstance instance) {
        if (instance instanceof HazelcastClientProxy) {
            HazelcastClientProxy proxy = (HazelcastClientProxy)instance;
            HazelcastClientInstanceImpl client = proxy.client;
            if (client == null) {
                return;
            }
            proxy.client = null;
            CLIENTS.remove(client.getName());
            try {
                client.shutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
            finally {
                OutOfMemoryErrorDispatcher.deregisterClient(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(String instanceName) {
        HazelcastInstanceFactory.InstanceFuture future = (HazelcastInstanceFactory.InstanceFuture)CLIENTS.remove(instanceName);
        if (future == null || !future.isSet()) {
            return;
        }
        HazelcastClientProxy proxy = (HazelcastClientProxy)future.get();
        HazelcastClientInstanceImpl client = proxy.client;
        if (client == null) {
            return;
        }
        proxy.client = null;
        try {
            client.shutdown();
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            OutOfMemoryErrorDispatcher.deregisterClient(client);
        }
    }

    public static void setOutOfMemoryHandler(OutOfMemoryHandler outOfMemoryHandler) {
        OutOfMemoryErrorDispatcher.setClientHandler(outOfMemoryHandler);
    }

    static HazelcastInstance newHazelcastClientInternal(AddressProvider addressProvider, ClientConfig clientConfig, ClientFailoverConfig failoverConfig) {
        HazelcastClient.checkConfigs(clientConfig, failoverConfig);
        String instanceName = HazelcastClient.getInstanceName(clientConfig, failoverConfig);
        HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy> future = new HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy>();
        if (CLIENTS.putIfAbsent(instanceName, future) != null) {
            throw new DuplicateInstanceNameException("HazelcastClientInstance with name '" + instanceName + "' already exists!");
        }
        try {
            return HazelcastClient.constructHazelcastClient(addressProvider, clientConfig, failoverConfig, instanceName, future);
        }
        catch (Throwable t) {
            CLIENTS.remove(instanceName, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    private static HazelcastInstance getOrCreateClientInternal(ClientConfig config) {
        config = FailoverClientConfigSupport.resolveClientConfig(config);
        String instanceName = config.getInstanceName();
        Preconditions.checkHasText(instanceName, "instanceName must contain text");
        HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy> future = (HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy>)CLIENTS.get(instanceName);
        if (future != null) {
            return (HazelcastInstance)future.get();
        }
        future = new HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy>();
        HazelcastInstanceFactory.InstanceFuture found = CLIENTS.putIfAbsent(instanceName, future);
        if (found != null) {
            return (HazelcastInstance)found.get();
        }
        try {
            return HazelcastClient.constructHazelcastClient(null, config, null, instanceName, future);
        }
        catch (Throwable t) {
            CLIENTS.remove(instanceName, future);
            future.setFailure(t);
            throw ExceptionUtil.rethrow(t);
        }
    }

    private static HazelcastInstance constructHazelcastClient(AddressProvider addressProvider, ClientConfig clientConfig, ClientFailoverConfig failoverConfig, String instanceName, HazelcastInstanceFactory.InstanceFuture<HazelcastClientProxy> future) {
        HazelcastClientProxy proxy;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HazelcastClient.class.getClassLoader());
            DefaultClientConnectionManagerFactory factory = new DefaultClientConnectionManagerFactory();
            HazelcastClientInstanceImpl client = new HazelcastClientInstanceImpl(instanceName, clientConfig, failoverConfig, factory, addressProvider);
            client.start();
            OutOfMemoryErrorDispatcher.registerClient(client);
            proxy = new HazelcastClientProxy(client);
            future.set(proxy);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        return proxy;
    }

    private static void checkConfigs(ClientConfig clientConfig, ClientFailoverConfig clientFailoverConfig) {
        assert (clientConfig != null || clientFailoverConfig != null) : "At most one type of config can be provided";
        assert (clientConfig == null || clientFailoverConfig == null) : "At least one config should be provided ";
    }

    static String getInstanceName(ClientConfig clientConfig, ClientFailoverConfig failoverConfig) {
        int instanceNum = CLIENT_ID_GEN.incrementAndGet();
        String instanceName = clientConfig != null ? clientConfig.getInstanceName() : failoverConfig.getClientConfigs().get(0).getInstanceName();
        if (instanceName == null || instanceName.trim().length() == 0) {
            instanceName = "hz.client_" + instanceNum;
        }
        return instanceName;
    }

    static {
        OutOfMemoryErrorDispatcher.setClientHandler(new ClientOutOfMemoryHandler());
    }
}

