/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.internal.util.SimpleCompletableFuture;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.operationexecutor.impl.PartitionOperationThread;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareFactoryAccessor;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionAwareOperationFactory;
import com.hazelcast.spi.impl.operationservice.impl.operations.PartitionIteratingOperation;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.MapUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class InvokeOnPartitionsAsync {
    private static final int TRY_COUNT = 10;
    private static final int TRY_PAUSE_MILLIS = 300;
    private static final Object NULL_RESULT = new Object(){

        public String toString() {
            return "NULL_RESULT";
        }
    };
    private final OperationServiceImpl operationService;
    private final String serviceName;
    private final OperationFactory operationFactory;
    private final Map<Address, List<Integer>> memberPartitions;
    private final AtomicReferenceArray<Object> partitionResults;
    private final AtomicInteger latch;
    private volatile ExecutionCallback<Map<Integer, Object>> callback;
    private final SimpleCompletableFuture future;

    InvokeOnPartitionsAsync(OperationServiceImpl operationService, String serviceName, OperationFactory operationFactory, Map<Address, List<Integer>> memberPartitions) {
        this.operationService = operationService;
        this.serviceName = serviceName;
        this.operationFactory = operationFactory;
        this.memberPartitions = memberPartitions;
        int partitionCount = operationService.nodeEngine.getPartitionService().getPartitionCount();
        int actualPartitionCount = 0;
        for (List<Integer> mp : memberPartitions.values()) {
            actualPartitionCount += mp.size();
        }
        this.partitionResults = new AtomicReferenceArray(partitionCount);
        this.latch = new AtomicInteger(actualPartitionCount);
        this.future = new SimpleCompletableFuture(operationService.nodeEngine);
    }

    <T> Map<Integer, T> invoke() throws Exception {
        return (Map)this.invokeAsync(null).get();
    }

    <T> ICompletableFuture<Map<Integer, T>> invokeAsync(ExecutionCallback<Map<Integer, T>> callback) {
        this.callback = callback;
        this.ensureNotCallingFromPartitionOperationThread();
        this.invokeOnAllPartitions();
        return this.future;
    }

    private void ensureNotCallingFromPartitionOperationThread() {
        if (Thread.currentThread() instanceof PartitionOperationThread) {
            throw new IllegalThreadStateException(Thread.currentThread() + " cannot make invocation on multiple partitions!");
        }
    }

    private void invokeOnAllPartitions() {
        for (Map.Entry<Address, List<Integer>> mp : this.memberPartitions.entrySet()) {
            Address address = mp.getKey();
            List<Integer> partitions = mp.getValue();
            PartitionIteratingOperation op = new PartitionIteratingOperation(this.operationFactory, CollectionUtil.toIntArray(partitions));
            this.operationService.createInvocationBuilder(this.serviceName, (Operation)op, address).setTryCount(10).setTryPauseMillis(300L).invoke().andThen(new FirstAttemptExecutionCallback(mp.getValue()));
        }
    }

    private void retryPartition(final int partitionId) {
        PartitionAwareOperationFactory partitionAwareFactory = PartitionAwareFactoryAccessor.extractPartitionAware(this.operationFactory);
        Operation operation = partitionAwareFactory != null ? partitionAwareFactory.createPartitionOperation(partitionId) : this.operationFactory.createOperation();
        this.operationService.createInvocationBuilder(this.serviceName, operation, partitionId).invoke().andThen(new ExecutionCallback<Object>(){

            @Override
            public void onResponse(Object response) {
                InvokeOnPartitionsAsync.this.setPartitionResult(partitionId, response);
                InvokeOnPartitionsAsync.this.decrementLatchAndHandle(1);
            }

            @Override
            public void onFailure(Throwable t) {
                InvokeOnPartitionsAsync.this.setPartitionResult(partitionId, t);
                InvokeOnPartitionsAsync.this.decrementLatchAndHandle(1);
            }
        });
    }

    private void decrementLatchAndHandle(int count) {
        if (this.latch.addAndGet(-count) > 0) {
            return;
        }
        Map<Integer, Object> result = MapUtil.createHashMap(this.partitionResults.length());
        for (int partitionId = 0; partitionId < this.partitionResults.length(); ++partitionId) {
            Object partitionResult = this.partitionResults.get(partitionId);
            if (partitionResult instanceof Throwable) {
                this.future.setResult(partitionResult);
                if (this.callback != null) {
                    this.callback.onFailure((Throwable)partitionResult);
                }
                return;
            }
            if (partitionResult == null) continue;
            result.put(partitionId, partitionResult == NULL_RESULT ? null : partitionResult);
        }
        this.future.setResult(result);
        if (this.callback != null) {
            this.callback.onResponse(result);
        }
    }

    private void setPartitionResult(int partition, Object result) {
        if (result == null) {
            result = NULL_RESULT;
        }
        boolean success = this.partitionResults.compareAndSet(partition, null, result);
        assert (success) : "two results for same partition: old=" + this.partitionResults.get(partition) + ", new=" + result;
    }

    private class FirstAttemptExecutionCallback
    implements ExecutionCallback<Object> {
        private final List<Integer> allPartitions;

        FirstAttemptExecutionCallback(List<Integer> partitions) {
            this.allPartitions = partitions;
        }

        @Override
        public void onResponse(Object response) {
            PartitionIteratingOperation.PartitionResponse result = (PartitionIteratingOperation.PartitionResponse)((InvokeOnPartitionsAsync)InvokeOnPartitionsAsync.this).operationService.nodeEngine.toObject(response);
            Object[] results = result.getResults();
            int[] partitions = result.getPartitions();
            assert (results.length <= this.allPartitions.size()) : "results.length=" + results.length + ", but was sent to just " + this.allPartitions.size() + " partitions";
            int failedPartitionsCnt = 0;
            for (int i = 0; i < partitions.length; ++i) {
                if (results[i] instanceof Throwable) {
                    InvokeOnPartitionsAsync.this.retryPartition(partitions[i]);
                    ++failedPartitionsCnt;
                    continue;
                }
                InvokeOnPartitionsAsync.this.setPartitionResult(partitions[i], results[i]);
            }
            InvokeOnPartitionsAsync.this.decrementLatchAndHandle(this.allPartitions.size() - failedPartitionsCnt);
        }

        @Override
        public void onFailure(Throwable t) {
            if (((InvokeOnPartitionsAsync)InvokeOnPartitionsAsync.this).operationService.logger.isFinestEnabled()) {
                ((InvokeOnPartitionsAsync)InvokeOnPartitionsAsync.this).operationService.logger.finest(t);
            } else {
                ((InvokeOnPartitionsAsync)InvokeOnPartitionsAsync.this).operationService.logger.warning(t.getMessage());
            }
            for (Integer partition : this.allPartitions) {
                InvokeOnPartitionsAsync.this.retryPartition(partition);
            }
        }
    }
}

