/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexInfo;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.MapIndexInfo;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SynchronizeIndexesForPartitionTask
implements PartitionSpecificRunnable {
    private final int partitionId;
    private final List<MapIndexInfo> mapIndexInfos;
    private final MapService mapService;
    private final SerializationService serializationService;
    private final InternalPartitionService partitionService;

    public SynchronizeIndexesForPartitionTask(int partitionId, List<MapIndexInfo> mapIndexInfos, MapService mapService, SerializationService serializationService, InternalPartitionService partitionService) {
        this.partitionId = partitionId;
        this.mapIndexInfos = mapIndexInfos;
        this.mapService = mapService;
        this.serializationService = serializationService;
        this.partitionService = partitionService;
    }

    @Override
    public void run() {
        InternalPartition partition = this.partitionService.getPartition(this.partitionId, false);
        if (!partition.isLocal() || partition.isMigrating()) {
            return;
        }
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        long now = Clock.currentTimeMillis();
        for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
            MapContainer mapContainer = mapServiceContext.getMapContainer(mapIndexInfo.getMapName());
            Indexes indexes = mapContainer.getIndexes(this.partitionId);
            ArrayList<IndexInfo> missingIndexes = new ArrayList<IndexInfo>();
            for (IndexInfo indexInfo : mapIndexInfo.getIndexInfos()) {
                if (indexes.getIndex(indexInfo.getAttributeName()) != null) continue;
                indexes.addOrGetIndex(indexInfo.getAttributeName(), indexInfo.isOrdered());
                missingIndexes.add(indexInfo);
            }
            RecordStore recordStore = mapServiceContext.getRecordStore(this.getPartitionId(), mapIndexInfo.getMapName());
            Iterator<Record> iterator = recordStore.iterator(now, false);
            while (iterator.hasNext()) {
                Record record = iterator.next();
                Data key = record.getKey();
                Object value = Records.getValueOrCachedValue(record, this.serializationService);
                QueryableEntry queryEntry = mapContainer.newQueryEntry(key, value);
                for (IndexInfo missingIndex : missingIndexes) {
                    indexes.getIndex(missingIndex.getAttributeName()).saveEntryIndex(queryEntry, null, Index.OperationSource.SYSTEM);
                }
            }
        }
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }
}

