/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.networking.AbstractChannel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.nio.NioChannelOptions;
import com.hazelcast.internal.networking.nio.NioInboundPipeline;
import com.hazelcast.internal.networking.nio.NioOutboundPipeline;
import com.hazelcast.internal.networking.nio.NioThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;

public final class NioChannel
extends AbstractChannel {
    private static final int DELAY_MS = Integer.getInteger("hazelcast.channel.close.delayMs", 200);
    NioInboundPipeline inboundPipeline;
    NioOutboundPipeline outboundPipeline;
    private final MetricsRegistry metricsRegistry;
    private final ChannelInitializer channelInitializer;
    private final NioChannelOptions config;

    public NioChannel(SocketChannel socketChannel, boolean clientMode, ChannelInitializer channelInitializer, MetricsRegistry metricsRegistry) {
        super(socketChannel, clientMode);
        this.channelInitializer = channelInitializer;
        this.metricsRegistry = metricsRegistry;
        this.config = new NioChannelOptions(socketChannel.socket());
    }

    @Override
    public NioChannelOptions options() {
        return this.config;
    }

    public void init(NioInboundPipeline inboundPipeline, NioOutboundPipeline outboundPipeline) {
        this.inboundPipeline = inboundPipeline;
        this.outboundPipeline = outboundPipeline;
    }

    @Override
    public NioOutboundPipeline outboundPipeline() {
        return this.outboundPipeline;
    }

    @Override
    public NioInboundPipeline inboundPipeline() {
        return this.inboundPipeline;
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.isClosed()) {
            return false;
        }
        this.outboundPipeline.write(frame);
        return true;
    }

    @Override
    protected void onConnect() {
        String metricsId = this.localSocketAddress() + "->" + this.remoteSocketAddress();
        this.metricsRegistry.scanAndRegister(this.outboundPipeline, "tcp.connection[" + metricsId + "].out");
        this.metricsRegistry.scanAndRegister(this.inboundPipeline, "tcp.connection[" + metricsId + "].in");
    }

    @Override
    public long lastReadTimeMillis() {
        return this.inboundPipeline.lastReadTimeMillis();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.outboundPipeline.lastWriteTimeMillis();
    }

    @Override
    public void start() {
        try {
            this.socketChannel.configureBlocking(false);
            this.channelInitializer.initChannel(this);
        }
        catch (Exception e) {
            throw new HazelcastException("Failed to start " + this, e);
        }
        this.inboundPipeline.start();
        this.outboundPipeline.start();
    }

    @Override
    protected void close0() {
        if (Thread.currentThread() instanceof NioThread) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        NioChannel.this.doClose();
                    }
                    catch (Exception e) {
                        NioChannel.this.logger.warning(e.getMessage(), e);
                    }
                }
            }.start();
        } else {
            this.doClose();
        }
    }

    private void doClose() {
        try {
            this.inboundPipeline.requestClose();
            this.outboundPipeline.requestClose();
            if (DELAY_MS > 0) {
                try {
                    Thread.sleep(DELAY_MS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                this.socketChannel.close();
            }
            catch (IOException e) {
                this.logger.warning(e);
            }
        }
        finally {
            this.notifyCloseListeners();
        }
    }

    public String toString() {
        return "NioChannel{" + this.localSocketAddress() + "->" + this.remoteSocketAddress() + '}';
    }

    private String getPort(SocketAddress socketAddress) {
        return socketAddress == null ? "*missing*" : Integer.toString(((InetSocketAddress)socketAddress).getPort());
    }
}

