/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.monitor.impl.PerIndexStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class GlobalQueryContextWithStats
extends QueryContext {
    private final HashMap<String, QueryTrackingIndex> knownIndexes = new HashMap();
    private final HashSet<QueryTrackingIndex> trackedIndexes = new HashSet(8);

    @Override
    void attachTo(Indexes indexes) {
        super.attachTo(indexes);
        for (QueryTrackingIndex trackedIndex : this.trackedIndexes) {
            trackedIndex.resetPerQueryStats();
        }
        this.trackedIndexes.clear();
    }

    @Override
    public Index getIndex(String attributeName) {
        if (this.indexes == null) {
            return null;
        }
        InternalIndex delegate = this.indexes.getIndex(attributeName);
        if (delegate == null) {
            return null;
        }
        QueryTrackingIndex trackingIndex = this.knownIndexes.get(attributeName);
        if (trackingIndex == null) {
            trackingIndex = new QueryTrackingIndex();
            this.knownIndexes.put(attributeName, trackingIndex);
        }
        trackingIndex.attachTo(delegate);
        this.trackedIndexes.add(trackingIndex);
        return trackingIndex;
    }

    @Override
    void applyPerQueryStats() {
        for (QueryTrackingIndex trackedIndex : this.trackedIndexes) {
            trackedIndex.incrementQueryCount();
        }
    }

    private static class QueryTrackingIndex
    implements InternalIndex {
        private InternalIndex delegate;
        private boolean hasQueries;

        private QueryTrackingIndex() {
        }

        public void attachTo(InternalIndex delegate) {
            this.delegate = delegate;
        }

        public void resetPerQueryStats() {
            this.hasQueries = false;
        }

        public void incrementQueryCount() {
            if (this.hasQueries) {
                this.delegate.getPerIndexStats().incrementQueryCount();
            }
        }

        @Override
        public String getAttributeName() {
            return this.delegate.getAttributeName();
        }

        @Override
        public boolean isOrdered() {
            return this.delegate.isOrdered();
        }

        @Override
        public void saveEntryIndex(QueryableEntry entry, Object oldValue, Index.OperationSource operationSource) {
            this.delegate.saveEntryIndex(entry, oldValue, operationSource);
        }

        @Override
        public void removeEntryIndex(Data key, Object value, Index.OperationSource operationSource) {
            this.delegate.removeEntryIndex(key, value, operationSource);
        }

        @Override
        public TypeConverter getConverter() {
            return this.delegate.getConverter();
        }

        @Override
        public Set<QueryableEntry> getRecords(Comparable value) {
            Set<QueryableEntry> result = this.delegate.getRecords(value);
            this.hasQueries = true;
            return result;
        }

        @Override
        public Set<QueryableEntry> getRecords(Comparable[] values) {
            Set<QueryableEntry> result = this.delegate.getRecords(values);
            this.hasQueries = true;
            return result;
        }

        @Override
        public Set<QueryableEntry> getSubRecordsBetween(Comparable from, Comparable to) {
            Set<QueryableEntry> result = this.delegate.getSubRecordsBetween(from, to);
            this.hasQueries = true;
            return result;
        }

        @Override
        public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedValue) {
            Set<QueryableEntry> result = this.delegate.getSubRecords(comparisonType, searchedValue);
            this.hasQueries = true;
            return result;
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public void destroy() {
            this.delegate.destroy();
        }

        @Override
        public PerIndexStats getPerIndexStats() {
            return this.delegate.getPerIndexStats();
        }
    }
}

