/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.predicates;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.BinaryInterface;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.QueryContext;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.AbstractIndexAwarePredicate;
import com.hazelcast.query.impl.predicates.NegatablePredicate;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

@BinaryInterface
public final class GreaterLessPredicate
extends AbstractIndexAwarePredicate
implements NegatablePredicate {
    private static final long serialVersionUID = 1L;
    protected Comparable value;
    boolean equal;
    boolean less;

    public GreaterLessPredicate() {
    }

    public GreaterLessPredicate(String attribute, Comparable value, boolean equal, boolean less) {
        super(attribute);
        if (value == null) {
            throw new NullPointerException("Arguments can't be null");
        }
        this.value = value;
        this.equal = equal;
        this.less = less;
    }

    @Override
    protected boolean applyForSingleAttributeValue(Map.Entry mapEntry, Comparable attributeValue) {
        if (attributeValue == null) {
            return false;
        }
        Comparable givenValue = this.convert(mapEntry, attributeValue, this.value);
        int result = attributeValue.compareTo(givenValue);
        return this.equal && result == 0 || (this.less ? result < 0 : result > 0);
    }

    @Override
    public Set<QueryableEntry> filter(QueryContext queryContext) {
        Index index = this.getIndex(queryContext);
        ComparisonType comparisonType = this.less ? (this.equal ? ComparisonType.LESSER_EQUAL : ComparisonType.LESSER) : (this.equal ? ComparisonType.GREATER_EQUAL : ComparisonType.GREATER);
        return index.getSubRecords(comparisonType, this.value);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.value = (Comparable)in.readObject();
        this.equal = in.readBoolean();
        this.less = in.readBoolean();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.value);
        out.writeBoolean(this.equal);
        out.writeBoolean(this.less);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attributeName);
        sb.append(this.less ? "<" : ">");
        if (this.equal) {
            sb.append("=");
        }
        sb.append(this.value);
        return sb.toString();
    }

    @Override
    public Predicate negate() {
        return new GreaterLessPredicate(this.attributeName, this.value, !this.equal, !this.less);
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof GreaterLessPredicate)) {
            return false;
        }
        GreaterLessPredicate that = (GreaterLessPredicate)o;
        if (!that.canEqual(this)) {
            return false;
        }
        if (this.equal != that.equal) {
            return false;
        }
        if (this.less != that.less) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof GreaterLessPredicate;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.equal ? 1 : 0);
        result = 31 * result + (this.less ? 1 : 0);
        return result;
    }
}

