/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.HashUtil;
import com.hazelcast.util.collection.Int2ObjectHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private static final long PERIOD = 10L;
    private static final long INITIAL_DELAY = 10L;
    private static final long BLOCKING_GET_ONCE_SLEEP_MILLIS = 100L;
    private final ExecutionCallback<ClientMessage> refreshTaskCallback = new RefreshTaskCallback();
    private final ClientExecutionServiceImpl clientExecutionService;
    private final HazelcastClientInstanceImpl client;
    private final ILogger logger;
    private final AtomicReference<PartitionTable> partitionTable = new AtomicReference<PartitionTable>(new PartitionTable(null, -1, new Int2ObjectHashMap<Address>()));
    private volatile int partitionCount;

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientPartitionService.class);
        this.clientExecutionService = (ClientExecutionServiceImpl)client.getClientExecutionService();
    }

    public void start() {
        this.clientExecutionService.scheduleWithRepetition(new RefreshTask(), 10L, 10L, TimeUnit.SECONDS);
    }

    public void listenPartitionTable(Connection ownerConnection) throws Exception {
        Int2ObjectHashMap<Address> partitions = this.getPartitions();
        this.partitionTable.set(new PartitionTable(ownerConnection, -1, partitions));
        if (((ClientConnection)ownerConnection).getConnectedServerVersion() >= BuildInfo.calculateVersion("3.9")) {
            ClientMessage clientMessage = ClientAddPartitionListenerCodec.encodeRequest();
            ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, null, ownerConnection);
            invocation.setEventHandler(new PartitionEventHandler(ownerConnection));
            invocation.invokeUrgent().get();
        }
    }

    void refreshPartitions() {
        try {
            this.clientExecutionService.execute(new RefreshTask());
        }
        catch (RejectedExecutionException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private void waitForPartitionCountSetOnce() {
        while (this.partitionCount == 0 && this.client.getConnectionManager().isAlive()) {
            ClientClusterService clusterService = this.client.getClientClusterService();
            Collection<Member> memberList = clusterService.getMemberList();
            Connection currentOwnerConnection = this.partitionTable.get().connection;
            if (memberList.isEmpty() || currentOwnerConnection == null) {
                this.sleepBeforeNextTry();
                continue;
            }
            if (this.isClusterFormedByOnlyLiteMembers()) {
                throw new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            }
            ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this.client, requestMessage, null, currentOwnerConnection).invokeUrgent();
            try {
                ClientMessage responseMessage = (ClientMessage)future.get();
                ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse(responseMessage);
                Connection connection = responseMessage.getConnection();
                this.processPartitionResponse(connection, response.partitions, response.partitionStateVersion, response.partitionStateVersionExist);
            }
            catch (Exception e) {
                if (!this.client.getLifecycleService().isRunning()) continue;
                this.logger.warning("Error while fetching cluster partition table!", e);
            }
        }
    }

    private void sleepBeforeNextTry() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ExceptionUtil.rethrow(e);
        }
    }

    private boolean isClusterFormedByOnlyLiteMembers() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        return clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).isEmpty();
    }

    private void processPartitionResponse(Connection connection, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion, boolean partitionStateVersionExist) {
        Int2ObjectHashMap<Address> newPartitions;
        PartitionTable newMetaData;
        PartitionTable current;
        do {
            if (this.shouldBeApplied(connection, partitions, partitionStateVersion, partitionStateVersionExist, current = this.partitionTable.get())) continue;
            return;
        } while (!this.partitionTable.compareAndSet(current, newMetaData = new PartitionTable(connection, partitionStateVersion, newPartitions = this.convertToPartitionToAddressMap(partitions))));
        if (this.partitionCount == 0) {
            this.partitionCount = newPartitions.size();
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Processed partition response. partitionStateVersion : " + (partitionStateVersionExist ? Integer.valueOf(partitionStateVersion) : "NotAvailable") + ", partitionCount :" + newPartitions.size() + ", connection : " + connection);
        }
    }

    private boolean shouldBeApplied(Connection connection, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion, boolean partitionStateVersionExist, PartitionTable current) {
        if (partitions.isEmpty()) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, partitionStateVersionExist, current, "response is empty");
            }
            return false;
        }
        if (!connection.equals(current.connection)) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, partitionStateVersionExist, current, "response is from old connection");
            }
            return false;
        }
        if (partitionStateVersionExist && partitionStateVersion <= current.partitionSateVersion) {
            if (this.logger.isFinestEnabled()) {
                this.logFailure(connection, partitionStateVersion, partitionStateVersionExist, current, "response state version is old");
            }
            return false;
        }
        return true;
    }

    private void logFailure(Connection connection, int partitionStateVersion, boolean partitionStateVersionExist, PartitionTable current, String cause) {
        this.logger.finest(" We will not apply the response, since " + cause + " . Response is from " + connection + ". Current connection " + current.connection + " response state version:" + (partitionStateVersionExist ? Integer.valueOf(partitionStateVersion) : "NotAvailable. Current state version: " + current.partitionSateVersion));
    }

    private Int2ObjectHashMap<Address> convertToPartitionToAddressMap(Collection<Map.Entry<Address, List<Integer>>> partitions) {
        Int2ObjectHashMap<Address> newPartitions = new Int2ObjectHashMap<Address>();
        for (Map.Entry<Address, List<Integer>> entry : partitions) {
            Address address = entry.getKey();
            for (Integer partition : entry.getValue()) {
                newPartitions.put(partition, address);
            }
        }
        return newPartitions;
    }

    public void reset() {
        this.partitionTable.set(new PartitionTable(null, -1, new Int2ObjectHashMap<Address>()));
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        return this.getPartitions().get(partitionId);
    }

    private Int2ObjectHashMap<Address> getPartitions() {
        return this.partitionTable.get().partitions;
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.getPartitionCount();
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return HashUtil.hashToIndex(hash, pc);
    }

    @Override
    public int getPartitionId(Object key) {
        Object data = this.client.getSerializationService().toData(key);
        return this.getPartitionId((Data)data);
    }

    @Override
    public int getPartitionCount() {
        if (this.partitionCount == 0) {
            this.waitForPartitionCountSetOnce();
        }
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private class RefreshTaskCallback
    implements ExecutionCallback<ClientMessage> {
        private RefreshTaskCallback() {
        }

        @Override
        public void onResponse(ClientMessage responseMessage) {
            if (responseMessage == null) {
                return;
            }
            Connection connection = responseMessage.getConnection();
            ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse(responseMessage);
            ClientPartitionServiceImpl.this.processPartitionResponse(connection, response.partitions, response.partitionStateVersion, response.partitionStateVersionExist);
        }

        @Override
        public void onFailure(Throwable t) {
            if (ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) {
                ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", t);
            }
        }
    }

    private final class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            block3: {
                try {
                    ClientConnectionManager connectionManager = ClientPartitionServiceImpl.this.client.getConnectionManager();
                    ClientConnection connection = connectionManager.getOwnerConnection();
                    if (connection == null) {
                        return;
                    }
                    ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
                    ClientInvocationFuture future = new ClientInvocation(ClientPartitionServiceImpl.this.client, requestMessage, null).invokeUrgent();
                    future.andThen(ClientPartitionServiceImpl.this.refreshTaskCallback);
                }
                catch (Exception e) {
                    if (!ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) break block3;
                    ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", e);
                }
            }
        }
    }

    private final class PartitionEventHandler
    extends ClientAddPartitionListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final Connection clientConnection;

        private PartitionEventHandler(Connection clientConnection) {
            this.clientConnection = clientConnection;
        }

        @Override
        public void handlePartitionsEventV15(Collection<Map.Entry<Address, List<Integer>>> response, int stateVersion) {
            ClientPartitionServiceImpl.this.processPartitionResponse(this.clientConnection, response, stateVersion, true);
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            return "PartitionImpl{partitionId=" + this.partitionId + '}';
        }
    }

    private static class PartitionTable {
        final Connection connection;
        final int partitionSateVersion;
        final Int2ObjectHashMap<Address> partitions;

        PartitionTable(Connection connection, int partitionSateVersion, Int2ObjectHashMap<Address> partitions) {
            this.connection = connection;
            this.partitionSateVersion = partitionSateVersion;
            this.partitions = partitions;
        }
    }
}

