/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientExtension;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAliasedDiscoveryConfigUtils;
import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.connection.AddressProvider;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.connection.nio.DefaultCredentialsFactory;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.clientside.ClientDynamicClusterConfig;
import com.hazelcast.client.impl.clientside.ClientExceptionFactory;
import com.hazelcast.client.impl.clientside.ClientICacheManager;
import com.hazelcast.client.impl.clientside.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.impl.clientside.DefaultClientExtension;
import com.hazelcast.client.impl.clientside.LifecycleServiceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.statistics.Statistics;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientTransactionManagerService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.client.spi.impl.ClientUserCodeDeploymentService;
import com.hazelcast.client.spi.impl.DefaultAddressProvider;
import com.hazelcast.client.spi.impl.DefaultAddressTranslator;
import com.hazelcast.client.spi.impl.NonSmartClientInvocationService;
import com.hazelcast.client.spi.impl.SmartClientInvocationService;
import com.hazelcast.client.spi.impl.discovery.DiscoveryAddressProvider;
import com.hazelcast.client.spi.impl.discovery.DiscoveryAddressTranslator;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudAddressProvider;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudAddressTranslator;
import com.hazelcast.client.spi.impl.discovery.HazelcastCloudDiscovery;
import com.hazelcast.client.spi.impl.listener.AbstractClientListenerService;
import com.hazelcast.client.spi.impl.listener.NonSmartClientListenerService;
import com.hazelcast.client.spi.impl.listener.SmartClientListenerService;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.config.Config;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.diagnostics.BuildInfoPlugin;
import com.hazelcast.internal.diagnostics.ConfigPropertiesPlugin;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.EventQueuePlugin;
import com.hazelcast.internal.diagnostics.MetricsPlugin;
import com.hazelcast.internal.diagnostics.NetworkingImbalancePlugin;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.internal.diagnostics.SystemPropertiesPlugin;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.FileMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.Connection;
import com.hazelcast.quorum.QuorumService;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.security.ICredentialsFactory;
import com.hazelcast.spi.discovery.impl.DefaultDiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryMode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceSettings;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ServiceLoader;
import com.hazelcast.util.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class HazelcastClientInstanceImpl
implements HazelcastInstance,
SerializationServiceSupport {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private static final short PROTOCOL_VERSION = 1;
    private final HazelcastProperties properties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientConfig config;
    private final LifecycleServiceImpl lifecycleService;
    private final ClientConnectionManagerImpl connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final AbstractClientInvocationService invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final AbstractClientListenerService listenerService;
    private final ClientTransactionManagerServiceImpl transactionManager;
    private final NearCacheManager nearCacheManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;
    private final LoadBalancer loadBalancer;
    private final ClientExtension clientExtension;
    private final ICredentialsFactory credentialsFactory;
    private final DiscoveryService discoveryService;
    private final LoggingService loggingService;
    private final MetricsRegistryImpl metricsRegistry;
    private final Statistics statistics;
    private final Diagnostics diagnostics;
    private final SerializationService serializationService;
    private final ClientICacheManager hazelcastCacheManager;
    private final ClientLockReferenceIdGenerator lockReferenceIdGenerator;
    private final ClientExceptionFactory clientExceptionFactory;
    private final ClientUserCodeDeploymentService userCodeDeploymentService;

    public HazelcastClientInstanceImpl(ClientConfig config, ClientConnectionManagerFactory clientConnectionManagerFactory, AddressProvider externalAddressProvider) {
        this.config = config;
        this.instanceName = config.getInstanceName() != null ? config.getInstanceName() : "hz.client_" + this.id;
        GroupConfig groupConfig = config.getGroupConfig();
        String loggingType = config.getProperty(GroupProperty.LOGGING_TYPE.getName());
        this.loggingService = new ClientLoggingService(groupConfig.getName(), loggingType, BuildInfoProvider.getBuildInfo(), this.instanceName);
        this.logGroupPasswordInfo();
        ClassLoader classLoader = config.getClassLoader();
        this.clientExtension = this.createClientInitializer(classLoader);
        this.clientExtension.beforeStart(this);
        this.credentialsFactory = this.initCredentialsFactory(config);
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.properties = new HazelcastProperties(config.getProperties());
        this.metricsRegistry = this.initMetricsRegistry();
        this.serializationService = this.clientExtension.createSerializationService((byte)-1);
        this.metricsRegistry.collectMetrics(this.clientExtension);
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutionService();
        this.metricsRegistry.collectMetrics(this.executionService);
        this.loadBalancer = this.initLoadBalancer(config);
        this.transactionManager = new ClientTransactionManagerServiceImpl(this, this.loadBalancer);
        this.partitionService = new ClientPartitionServiceImpl(this);
        this.discoveryService = this.initDiscoveryService(config);
        Collection<AddressProvider> addressProviders = this.createAddressProviders(externalAddressProvider);
        AddressTranslator addressTranslator = this.createAddressTranslator();
        this.connectionManager = (ClientConnectionManagerImpl)clientConnectionManagerFactory.createConnectionManager(this, addressTranslator, addressProviders);
        this.clusterService = new ClientClusterServiceImpl(this);
        this.invocationService = this.initInvocationService();
        this.listenerService = this.initListenerService();
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.userContext.putAll(config.getUserContext());
        this.diagnostics = this.initDiagnostics();
        this.hazelcastCacheManager = new ClientICacheManager(this);
        this.lockReferenceIdGenerator = new ClientLockReferenceIdGenerator();
        this.nearCacheManager = this.clientExtension.createNearCacheManager();
        this.clientExceptionFactory = this.initClientExceptionFactory();
        this.statistics = new Statistics(this);
        this.userCodeDeploymentService = new ClientUserCodeDeploymentService(config.getUserCodeDeploymentConfig(), classLoader);
    }

    private int getConnectionTimeoutMillis() {
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        int connTimeout = networkConfig.getConnectionTimeout();
        return connTimeout == 0 ? Integer.MAX_VALUE : connTimeout;
    }

    private Diagnostics initDiagnostics() {
        String name = "diagnostics-client-" + this.id + "-" + System.currentTimeMillis();
        ILogger logger = this.loggingService.getLogger(Diagnostics.class);
        return new Diagnostics(name, logger, this.instanceName, this.properties);
    }

    private MetricsRegistryImpl initMetricsRegistry() {
        ProbeLevel probeLevel = this.properties.getEnum(Diagnostics.METRICS_LEVEL, ProbeLevel.class);
        ILogger logger = this.loggingService.getLogger(MetricsRegistryImpl.class);
        MetricsRegistryImpl metricsRegistry = new MetricsRegistryImpl(this.getName(), logger, probeLevel);
        RuntimeMetricSet.register(metricsRegistry);
        GarbageCollectionMetricSet.register(metricsRegistry);
        OperatingSystemMetricSet.register(metricsRegistry);
        ThreadMetricSet.register(metricsRegistry);
        ClassLoadingMetricSet.register(metricsRegistry);
        FileMetricSet.register(metricsRegistry);
        metricsRegistry.scanAndRegister(this.clientExtension.getMemoryStats(), "memory");
        return metricsRegistry;
    }

    private Collection<AddressProvider> createAddressProviders(AddressProvider externalAddressProvider) {
        ClientCloudConfig cloudConfig;
        HazelcastCloudAddressProvider cloudAddressProvider;
        ClientNetworkConfig networkConfig = this.getClientConfig().getNetworkConfig();
        LinkedList<AddressProvider> addressProviders = new LinkedList<AddressProvider>();
        if (externalAddressProvider != null) {
            addressProviders.add(externalAddressProvider);
        }
        if (this.discoveryService != null) {
            addressProviders.add(new DiscoveryAddressProvider(this.discoveryService, this.loggingService));
        }
        if ((cloudAddressProvider = this.initCloudAddressProvider(cloudConfig = networkConfig.getCloudConfig())) != null) {
            addressProviders.add(cloudAddressProvider);
        }
        addressProviders.add(new DefaultAddressProvider(networkConfig, addressProviders.isEmpty()));
        return addressProviders;
    }

    private HazelcastCloudAddressProvider initCloudAddressProvider(ClientCloudConfig cloudConfig) {
        if (cloudConfig.isEnabled()) {
            String discoveryToken = cloudConfig.getDiscoveryToken();
            String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint(this.getProperties(), discoveryToken);
            return new HazelcastCloudAddressProvider(urlEndpoint, this.getConnectionTimeoutMillis(), this.loggingService);
        }
        String cloudToken = this.properties.getString(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN);
        if (cloudToken != null) {
            String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint(this.getProperties(), cloudToken);
            return new HazelcastCloudAddressProvider(urlEndpoint, this.getConnectionTimeoutMillis(), this.loggingService);
        }
        return null;
    }

    private AddressTranslator createAddressTranslator() {
        ClientNetworkConfig networkConfig = this.getClientConfig().getNetworkConfig();
        ClientCloudConfig cloudConfig = networkConfig.getCloudConfig();
        List<String> addresses = networkConfig.getAddresses();
        boolean addressListProvided = addresses.size() != 0;
        boolean awsDiscoveryEnabled = networkConfig.getAwsConfig() != null && networkConfig.getAwsConfig().isEnabled();
        boolean gcpDiscoveryEnabled = networkConfig.getGcpConfig() != null && networkConfig.getGcpConfig().isEnabled();
        boolean azureDiscoveryEnabled = networkConfig.getAzureConfig() != null && networkConfig.getAzureConfig().isEnabled();
        boolean kubernetesDiscoveryEnabled = networkConfig.getKubernetesConfig() != null && networkConfig.getKubernetesConfig().isEnabled();
        boolean eurekaDiscoveryEnabled = networkConfig.getEurekaConfig() != null && networkConfig.getEurekaConfig().isEnabled();
        boolean discoverySpiEnabled = this.discoverySpiEnabled(networkConfig);
        String cloudDiscoveryToken = this.properties.getString(ClientProperty.HAZELCAST_CLOUD_DISCOVERY_TOKEN);
        if (cloudDiscoveryToken != null && cloudConfig.isEnabled()) {
            throw new IllegalStateException("Ambiguous hazelcast.cloud configuration. Both property based and client configuration based settings are provided for Hazelcast cloud discovery together. Use only one.");
        }
        boolean hazelcastCloudEnabled = cloudDiscoveryToken != null || cloudConfig.isEnabled();
        this.isDiscoveryConfigurationConsistent(addressListProvided, awsDiscoveryEnabled, gcpDiscoveryEnabled, azureDiscoveryEnabled, kubernetesDiscoveryEnabled, eurekaDiscoveryEnabled, discoverySpiEnabled, hazelcastCloudEnabled);
        if (this.discoveryService != null) {
            return new DiscoveryAddressTranslator(this.discoveryService, this.usePublicAddress(this.config));
        }
        if (hazelcastCloudEnabled) {
            String discoveryToken = cloudConfig.isEnabled() ? cloudConfig.getDiscoveryToken() : cloudDiscoveryToken;
            String urlEndpoint = HazelcastCloudDiscovery.createUrlEndpoint(this.getProperties(), discoveryToken);
            return new HazelcastCloudAddressTranslator(urlEndpoint, this.getConnectionTimeoutMillis(), this.loggingService);
        }
        return new DefaultAddressTranslator();
    }

    private boolean discoverySpiEnabled(ClientNetworkConfig networkConfig) {
        return networkConfig.getDiscoveryConfig() != null && networkConfig.getDiscoveryConfig().isEnabled() || Boolean.parseBoolean(this.properties.getString(ClientProperty.DISCOVERY_SPI_ENABLED));
    }

    private boolean usePublicAddress(ClientConfig config) {
        return this.getProperties().getBoolean(ClientProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED) || AliasedDiscoveryConfigUtils.allUsePublicAddress(ClientAliasedDiscoveryConfigUtils.aliasedDiscoveryConfigsFrom(config));
    }

    private void isDiscoveryConfigurationConsistent(boolean addressListProvided, boolean awsDiscoveryEnabled, boolean gcpDiscoveryEnabled, boolean azureDiscoveryEnabled, boolean kubernetesDiscoveryEnabled, boolean eurekaDiscoveryEnabled, boolean discoverySpiEnabled, boolean hazelcastCloudEnabled) {
        int count = 0;
        if (addressListProvided) {
            ++count;
        }
        if (awsDiscoveryEnabled) {
            ++count;
        }
        if (gcpDiscoveryEnabled) {
            ++count;
        }
        if (azureDiscoveryEnabled) {
            ++count;
        }
        if (kubernetesDiscoveryEnabled) {
            ++count;
        }
        if (eurekaDiscoveryEnabled) {
            ++count;
        }
        if (discoverySpiEnabled) {
            ++count;
        }
        if (hazelcastCloudEnabled) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalStateException("Only one discovery method can be enabled at a time. cluster members given explicitly : " + addressListProvided + ", aws discovery: " + awsDiscoveryEnabled + ", gcp discovery: " + gcpDiscoveryEnabled + ", azure discovery: " + azureDiscoveryEnabled + ", kubernetes discovery: " + kubernetesDiscoveryEnabled + ", eureka discovery: " + eurekaDiscoveryEnabled + ", discovery spi enabled : " + discoverySpiEnabled + ", hazelcast.cloud enabled : " + hazelcastCloudEnabled);
        }
    }

    private DiscoveryService initDiscoveryService(ClientConfig config) {
        List<DiscoveryStrategyConfig> aliasedDiscoveryConfigs = ClientAliasedDiscoveryConfigUtils.createDiscoveryStrategyConfigs(config);
        if (!this.properties.getBoolean(ClientProperty.DISCOVERY_SPI_ENABLED) && aliasedDiscoveryConfigs.isEmpty()) {
            return null;
        }
        ILogger logger = this.loggingService.getLogger(DiscoveryService.class);
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        DiscoveryConfig discoveryConfig = networkConfig.getDiscoveryConfig().getAsReadOnly();
        DiscoveryServiceProvider factory = discoveryConfig.getDiscoveryServiceProvider();
        if (factory == null) {
            factory = new DefaultDiscoveryServiceProvider();
        }
        DiscoveryServiceSettings settings = new DiscoveryServiceSettings().setConfigClassLoader(config.getClassLoader()).setLogger(logger).setDiscoveryMode(DiscoveryMode.Client).setAliasedDiscoveryConfigs(aliasedDiscoveryConfigs).setDiscoveryConfig(discoveryConfig);
        DiscoveryService discoveryService = factory.newDiscoveryService(settings);
        discoveryService.start();
        return discoveryService;
    }

    private LoadBalancer initLoadBalancer(ClientConfig config) {
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            lb = new RoundRobinLB();
        }
        return lb;
    }

    private ICredentialsFactory initCredentialsFactory(ClientConfig config) {
        ClientSecurityConfig securityConfig = config.getSecurityConfig();
        this.validateSecurityConfig(securityConfig);
        ICredentialsFactory c = this.getCredentialsFromFactory(config);
        if (c == null) {
            return new DefaultCredentialsFactory(securityConfig, config.getGroupConfig(), config.getClassLoader());
        }
        return c;
    }

    private void validateSecurityConfig(ClientSecurityConfig securityConfig) {
        boolean configuredViaCredentialsFactory;
        boolean configuredViaCredentials = securityConfig.getCredentials() != null || securityConfig.getCredentialsClassname() != null;
        CredentialsFactoryConfig factoryConfig = securityConfig.getCredentialsFactoryConfig();
        boolean bl = configuredViaCredentialsFactory = factoryConfig.getClassName() != null || factoryConfig.getImplementation() != null;
        if (configuredViaCredentials && configuredViaCredentialsFactory) {
            throw new IllegalStateException("Ambiguous Credentials config. Set only one of Credentials or ICredentialsFactory");
        }
    }

    private ICredentialsFactory getCredentialsFromFactory(ClientConfig config) {
        String factoryClassName;
        CredentialsFactoryConfig credentialsFactoryConfig = config.getSecurityConfig().getCredentialsFactoryConfig();
        ICredentialsFactory factory = credentialsFactoryConfig.getImplementation();
        if (factory == null && (factoryClassName = credentialsFactoryConfig.getClassName()) != null) {
            try {
                factory = (ICredentialsFactory)ClassLoaderUtil.newInstance(config.getClassLoader(), factoryClassName);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (factory == null) {
            return null;
        }
        factory.configure(config.getGroupConfig(), credentialsFactoryConfig.getProperties());
        return factory;
    }

    private AbstractClientInvocationService initInvocationService() {
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new SmartClientInvocationService(this, this.loadBalancer);
        }
        return new NonSmartClientInvocationService(this);
    }

    public int getId() {
        return this.id;
    }

    private ClientExtension createClientInitializer(ClassLoader classLoader) {
        try {
            String factoryId = ClientExtension.class.getName();
            Iterator<ClientExtension> iter = ServiceLoader.iterator(ClientExtension.class, factoryId, classLoader);
            while (iter.hasNext()) {
                ClientExtension initializer = iter.next();
                if (initializer.getClass().equals(DefaultClientExtension.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new DefaultClientExtension();
    }

    private AbstractClientListenerService initListenerService() {
        int eventQueueCapacity = this.properties.getInteger(ClientProperty.EVENT_QUEUE_CAPACITY);
        int eventThreadCount = this.properties.getInteger(ClientProperty.EVENT_THREAD_COUNT);
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new SmartClientListenerService(this, eventThreadCount, eventQueueCapacity);
        }
        return new NonSmartClientListenerService(this, eventThreadCount, eventQueueCapacity);
    }

    private ClientExecutionServiceImpl initExecutionService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.config.getClassLoader(), this.properties, this.config.getExecutorPoolSize(), this.loggingService);
    }

    private void logGroupPasswordInfo() {
        if (!StringUtil.isNullOrEmpty(this.config.getGroupConfig().getPassword())) {
            ILogger logger = this.loggingService.getLogger(HazelcastClient.class);
            logger.info("A non-empty group password is configured for the Hazelcast client. Starting with Hazelcast version 3.11, clients with the same group name, but with different group passwords (that do not use authentication) will be accepted to a cluster. The group password configuration will be removed completely in a future release.");
        }
    }

    public void start() {
        this.lifecycleService.setStarted();
        this.invocationService.start();
        this.clusterService.start();
        ClientContext clientContext = new ClientContext(this);
        try {
            this.userCodeDeploymentService.start();
            this.connectionManager.start(clientContext);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        this.diagnostics.start();
        this.diagnostics.register(new BuildInfoPlugin(this.loggingService.getLogger(BuildInfoPlugin.class)));
        this.diagnostics.register(new ConfigPropertiesPlugin(this.loggingService.getLogger(ConfigPropertiesPlugin.class), this.properties));
        this.diagnostics.register(new SystemPropertiesPlugin(this.loggingService.getLogger(SystemPropertiesPlugin.class)));
        this.diagnostics.register(new MetricsPlugin(this.loggingService.getLogger(MetricsPlugin.class), this.metricsRegistry, this.properties));
        this.diagnostics.register(new SystemLogPlugin(this.properties, this.connectionManager, this, this.loggingService.getLogger(SystemLogPlugin.class)));
        this.diagnostics.register(new NetworkingImbalancePlugin(this.properties, this.connectionManager.getNetworking(), this.loggingService.getLogger(NetworkingImbalancePlugin.class)));
        this.diagnostics.register(new EventQueuePlugin(this.loggingService.getLogger(EventQueuePlugin.class), this.listenerService.getEventExecutor(), this.properties));
        this.metricsRegistry.collectMetrics(this.listenerService);
        this.proxyManager.init(this.config, clientContext);
        this.listenerService.start();
        this.loadBalancer.init(this.getCluster(), this.config);
        this.partitionService.start();
        this.statistics.start();
        this.clientExtension.afterStart(this);
    }

    public void onClusterConnect(Connection ownerConnection) throws Exception {
        this.partitionService.listenPartitionTable(ownerConnection);
        this.clusterService.listenMembershipEvents(ownerConnection);
        this.userCodeDeploymentService.deploy(this, ownerConnection);
        this.proxyManager.createDistributedObjectsOnCluster(ownerConnection);
    }

    public MetricsRegistryImpl getMetricsRegistry() {
        return this.metricsRegistry;
    }

    @Override
    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    @Override
    public Config getConfig() {
        return new ClientDynamicClusterConfig(this);
    }

    public HazelcastProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getName() {
        return this.instanceName;
    }

    @Override
    public <E> IQueue<E> getQueue(String name) {
        Preconditions.checkNotNull(name, "Retrieving a queue instance with a null name is not allowed!");
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    @Override
    public <E> ITopic<E> getTopic(String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    @Override
    public <E> ISet<E> getSet(String name) {
        Preconditions.checkNotNull(name, "Retrieving a set instance with a null name is not allowed!");
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    @Override
    public <E> IList<E> getList(String name) {
        Preconditions.checkNotNull(name, "Retrieving a list instance with a null name is not allowed!");
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    @Override
    public <K, V> IMap<K, V> getMap(String name) {
        Preconditions.checkNotNull(name, "Retrieving a map instance with a null name is not allowed!");
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    @Override
    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        Preconditions.checkNotNull(name, "Retrieving a multi-map instance with a null name is not allowed!");
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    @Override
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        Preconditions.checkNotNull(name, "Retrieving a replicated map instance with a null name is not allowed!");
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    @Override
    public JobTracker getJobTracker(String name) {
        Preconditions.checkNotNull(name, "Retrieving a job tracker instance with a null name is not allowed!");
        return (JobTracker)this.getDistributedObject("hz:impl:mapReduceService", name);
    }

    @Override
    public ILock getLock(String key) {
        Preconditions.checkNotNull(key, "Retrieving a lock instance with a null key is not allowed!");
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    @Override
    public <E> ITopic<E> getReliableTopic(String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    @Override
    public <E> Ringbuffer<E> getRingbuffer(String name) {
        Preconditions.checkNotNull(name, "Retrieving a ringbuffer instance with a null name is not allowed!");
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    @Override
    public ClientICacheManager getCacheManager() {
        return this.hazelcastCacheManager;
    }

    @Override
    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    @Override
    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    @Override
    public IExecutorService getExecutorService(String name) {
        Preconditions.checkNotNull(name, "Retrieving an executor instance with a null name is not allowed!");
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    @Override
    public DurableExecutorService getDurableExecutorService(String name) {
        Preconditions.checkNotNull(name, "Retrieving a durable executor instance with a null name is not allowed!");
        return (DurableExecutorService)this.getDistributedObject("hz:impl:durableExecutorService", name);
    }

    @Override
    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.transactionManager.newTransactionContext(options);
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public IdGenerator getIdGenerator(String name) {
        Preconditions.checkNotNull(name, "Retrieving an ID-generator instance with a null name is not allowed!");
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    @Override
    public FlakeIdGenerator getFlakeIdGenerator(String name) {
        Preconditions.checkNotNull(name, "Retrieving a Flake ID-generator instance with a null name is not allowed!");
        return (FlakeIdGenerator)this.getDistributedObject("hz:impl:flakeIdGeneratorService", name);
    }

    @Override
    public IAtomicLong getAtomicLong(String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic-long instance with a null name is not allowed!");
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    @Override
    public CardinalityEstimator getCardinalityEstimator(String name) {
        Preconditions.checkNotNull(name, "Retrieving a cardinality estimator instance with a null name is not allowed!");
        return (CardinalityEstimator)this.getDistributedObject("hz:impl:cardinalityEstimatorService", name);
    }

    @Override
    public PNCounter getPNCounter(String name) {
        Preconditions.checkNotNull(name, "Retrieving a PN counter instance with a null name is not allowed!");
        return (PNCounter)this.getDistributedObject("hz:impl:PNCounterService", name);
    }

    @Override
    public <E> IAtomicReference<E> getAtomicReference(String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic-reference instance with a null name is not allowed!");
        return (IAtomicReference)this.getDistributedObject("hz:impl:atomicReferenceService", name);
    }

    @Override
    public ICountDownLatch getCountDownLatch(String name) {
        Preconditions.checkNotNull(name, "Retrieving a countdown-latch instance with a null name is not allowed!");
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    @Override
    public ISemaphore getSemaphore(String name) {
        Preconditions.checkNotNull(name, "Retrieving a semaphore instance with a null name is not allowed!");
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    @Override
    public IScheduledExecutorService getScheduledExecutorService(String name) {
        Preconditions.checkNotNull(name, "Retrieving a scheduled executor instance with a null name is not allowed!");
        return (IScheduledExecutorService)this.getDistributedObject("hz:impl:scheduledExecutorService", name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        try {
            ClientMessage request = ClientGetDistributedObjectsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this, request, this.getName()).invoke();
            ClientMessage response = (ClientMessage)future.get();
            ClientGetDistributedObjectsCodec.ResponseParameters resultParameters = ClientGetDistributedObjectsCodec.decodeResponse(response);
            Collection<? extends DistributedObject> distributedObjects = this.proxyManager.getDistributedObjects();
            HashSet<DistributedObjectInfo> localDistributedObjects = new HashSet<DistributedObjectInfo>();
            for (DistributedObject distributedObject : distributedObjects) {
                localDistributedObjects.add(new DistributedObjectInfo(distributedObject.getServiceName(), distributedObject.getName()));
            }
            List<DistributedObjectInfo> newDistributedObjectInfo = resultParameters.response;
            for (DistributedObjectInfo distributedObjectInfo : newDistributedObjectInfo) {
                localDistributedObjects.remove(distributedObjectInfo);
                this.getDistributedObject(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            for (DistributedObjectInfo distributedObjectInfo : localDistributedObjects) {
                this.proxyManager.destroyProxyLocally(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    @Override
    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService, this.listenerService);
    }

    @Override
    public QuorumService getQuorumService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    @Override
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
    }

    @Override
    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientUserCodeDeploymentService getUserCodeDeploymentService() {
        return this.userCodeDeploymentService;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager() {
        return this.nearCacheManager;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientExtension getClientExtension() {
        return this.clientExtension;
    }

    public ICredentialsFactory getCredentialsFactory() {
        return this.credentialsFactory;
    }

    public short getProtocolVersion() {
        return 1;
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    public void doShutdown() {
        this.proxyManager.destroy();
        this.connectionManager.shutdown();
        this.clusterService.shutdown();
        this.partitionService.reset();
        this.transactionManager.shutdown();
        this.invocationService.shutdown();
        this.executionService.shutdown();
        this.listenerService.shutdown();
        this.nearCacheManager.destroyAllNearCaches();
        if (this.discoveryService != null) {
            this.discoveryService.destroy();
        }
        this.metricsRegistry.shutdown();
        this.diagnostics.shutdown();
        ((InternalSerializationService)this.serializationService).dispose();
    }

    public ClientLockReferenceIdGenerator getLockReferenceIdGenerator() {
        return this.lockReferenceIdGenerator;
    }

    private ClientExceptionFactory initClientExceptionFactory() {
        boolean jCacheAvailable = JCacheDetector.isJCacheAvailable(this.getClientConfig().getClassLoader());
        return new ClientExceptionFactory(jCacheAvailable);
    }

    public ClientExceptionFactory getClientExceptionFactory() {
        return this.clientExceptionFactory;
    }
}

