/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.TimeUnit;

abstract class AbstractAddressPicker
implements AddressPicker {
    private static final int SOCKET_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final int SOCKET_BACKLOG_LENGTH = 100;
    final ILogger logger;
    private final NetworkConfig networkConfig;
    private ServerSocketChannel serverSocketChannel;

    AbstractAddressPicker(NetworkConfig networkConfig, ILogger logger) {
        this.networkConfig = networkConfig;
        this.logger = logger;
    }

    final int createServerSocketChannel(InetAddress bindAddress, int initialPort, boolean bindAny) {
        int portCount = this.networkConfig.getPortCount();
        boolean portAutoIncrement = this.networkConfig.isPortAutoIncrement();
        this.logger.finest("inet reuseAddress:" + this.networkConfig.isReuseAddress());
        if (initialPort == 0) {
            initialPort = this.networkConfig.getPort();
        }
        if (initialPort == 0) {
            this.logger.info("No explicit port is given, system will pick up an ephemeral port.");
        }
        int portTrialCount = initialPort > 0 && portAutoIncrement ? portCount : 1;
        try {
            return this.tryOpenServerSocketChannel(bindAddress, initialPort, portTrialCount, bindAny);
        }
        catch (IOException e) {
            String message = "Cannot bind to a given address: " + bindAddress + ". Hazelcast cannot start. ";
            message = this.networkConfig.isPortAutoIncrement() ? message + "Config-port: " + this.networkConfig.getPort() + ", latest-port: " + (initialPort + portTrialCount - 1) : message + "Port [" + initialPort + "] is already in use and auto-increment is disabled.";
            throw new HazelcastException(message, e);
        }
    }

    private int tryOpenServerSocketChannel(InetAddress bindAddress, int initialPort, int portTrialCount, boolean bindAny) throws IOException {
        assert (portTrialCount > 0) : "Port trial count must be positive: " + portTrialCount;
        IOException error = null;
        for (int i = 0; i < portTrialCount; ++i) {
            int actualPort = initialPort + i;
            boolean reuseAddress = this.networkConfig.isReuseAddress();
            InetSocketAddress socketBindAddress = bindAny ? new InetSocketAddress(actualPort) : new InetSocketAddress(bindAddress, actualPort);
            try {
                return this.openServerSocketChannel(socketBindAddress, reuseAddress);
            }
            catch (IOException e) {
                error = e;
                continue;
            }
        }
        throw error;
    }

    private int openServerSocketChannel(InetSocketAddress socketBindAddress, boolean reuseAddress) throws IOException {
        ServerSocket serverSocket = null;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            serverSocket = this.serverSocketChannel.socket();
            serverSocket.setReuseAddress(reuseAddress);
            serverSocket.setSoTimeout(SOCKET_TIMEOUT_MILLIS);
            this.logger.fine("Trying to bind inet socket address: " + socketBindAddress);
            serverSocket.bind(socketBindAddress, 100);
            this.logger.fine("Bind successful to inet socket address: " + serverSocket.getLocalSocketAddress());
            this.serverSocketChannel.configureBlocking(false);
            return serverSocket.getLocalPort();
        }
        catch (IOException e) {
            IOUtil.close(serverSocket);
            IOUtil.closeResource(this.serverSocketChannel);
            throw e;
        }
    }

    @Override
    public final ServerSocketChannel getServerSocketChannel() {
        return this.serverSocketChannel;
    }
}

