/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.request;

import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.operation.WanCheckConsistencyOperation;
import com.hazelcast.internal.management.request.ConsoleRequest;
import com.hazelcast.util.JsonUtil;

public class WanCheckConsistencyRequest
implements ConsoleRequest {
    public static final String SUCCESS = "success";
    private String schemeName;
    private String publisherName;
    private String mapName;

    public WanCheckConsistencyRequest() {
    }

    public WanCheckConsistencyRequest(String schemeName, String publisherName, String mapName) {
        this.schemeName = schemeName;
        this.publisherName = publisherName;
        this.mapName = mapName;
    }

    @Override
    public int getType() {
        return 43;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject out) throws Exception {
        WanCheckConsistencyOperation operation = new WanCheckConsistencyOperation(this.schemeName, this.publisherName, this.mapName);
        Object operationResult = ManagementCenterService.resolveFuture(mcs.callOnThis(operation));
        JsonObject result = new JsonObject();
        if (operationResult == null) {
            result.add("result", SUCCESS);
        } else {
            result.add("result", operationResult.toString());
        }
        out.add("result", result);
    }

    @Override
    public void fromJson(JsonObject json) {
        this.schemeName = JsonUtil.getString(json, "schemeName");
        this.publisherName = JsonUtil.getString(json, "publisherName");
        this.mapName = JsonUtil.getString(json, "mapName");
    }
}

