/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.instance.AbstractAddressPicker;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.MemberAddressProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class DelegatingAddressPicker
extends AbstractAddressPicker {
    private final MemberAddressProvider memberAddressProvider;
    private InetSocketAddress bindAddress;
    private InetSocketAddress publicAddress;

    DelegatingAddressPicker(MemberAddressProvider memberAddressProvider, NetworkConfig networkConfig, ILogger logger) {
        super(networkConfig, logger);
        this.memberAddressProvider = memberAddressProvider;
    }

    @Override
    public void pickAddress() throws Exception {
        try {
            this.bindAddress = this.memberAddressProvider.getBindAddress();
            this.publicAddress = this.memberAddressProvider.getPublicAddress();
            this.validatePublicAddress(this.publicAddress);
            int port = this.createServerSocketChannel(this.bindAddress.getAddress(), this.bindAddress.getPort(), false);
            if (port != this.bindAddress.getPort()) {
                this.bindAddress = new InetSocketAddress(this.bindAddress.getAddress(), port);
            }
            this.logger.info("Using bind address: " + this.bindAddress);
            if (this.publicAddress.getPort() == 0) {
                this.publicAddress = new InetSocketAddress(this.publicAddress.getAddress(), port);
            }
            this.logger.info("Using public address: " + this.publicAddress);
        }
        catch (Exception e) {
            this.logger.severe(e);
            throw e;
        }
    }

    private void validatePublicAddress(InetSocketAddress inetSocketAddress) {
        InetAddress address = inetSocketAddress.getAddress();
        if (address == null) {
            throw new ConfigurationException("Cannot resolve address '" + inetSocketAddress + "'");
        }
        if (address.isAnyLocalAddress()) {
            throw new ConfigurationException("Member address provider has to return a specific public address to broadcast to other members.");
        }
    }

    @Override
    public Address getBindAddress() {
        return new Address(this.bindAddress);
    }

    @Override
    public Address getPublicAddress() {
        return new Address(this.publicAddress);
    }
}

