/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan.merkletree;

public class ConsistencyCheckResult {
    private final int lastCheckedPartitionCount;
    private final int lastDiffPartitionCount;

    public ConsistencyCheckResult() {
        this.lastCheckedPartitionCount = 0;
        this.lastDiffPartitionCount = 0;
    }

    public ConsistencyCheckResult(int lastCheckedPartitionCount, int lastDiffPartitionCount) {
        this.lastCheckedPartitionCount = lastCheckedPartitionCount;
        this.lastDiffPartitionCount = lastDiffPartitionCount;
    }

    public int getLastCheckedPartitionCount() {
        return this.lastCheckedPartitionCount;
    }

    public int getLastDiffPartitionCount() {
        return this.lastDiffPartitionCount;
    }

    public boolean isRunning() {
        return this.lastCheckedPartitionCount == -1 && this.lastDiffPartitionCount == -1;
    }

    public float getDiffPercentage() {
        return this.lastCheckedPartitionCount != 0 ? (float)this.lastDiffPartitionCount / (float)this.lastCheckedPartitionCount * 100.0f : 0.0f;
    }

    public boolean isDone() {
        return this.lastCheckedPartitionCount > 0 && this.lastDiffPartitionCount > 0;
    }
}

