/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.BaseIndexStore;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class SortedIndexStore
extends BaseIndexStore {
    private volatile Map<Data, QueryableEntry> recordsWithNullValue;
    private final ConcurrentSkipListMap<Comparable, Map<Data, QueryableEntry>> recordMap = new ConcurrentSkipListMap();
    private final BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> addFunctor;
    private final BaseIndexStore.IndexFunctor<Comparable, Data> removeFunctor;

    public SortedIndexStore(IndexCopyBehavior copyOn) {
        super(copyOn);
        assert (copyOn != null);
        if (copyOn == IndexCopyBehavior.COPY_ON_WRITE) {
            this.addFunctor = new CopyOnWriteAddFunctor();
            this.removeFunctor = new CopyOnWriteRemoveFunctor();
            this.recordsWithNullValue = Collections.emptyMap();
        } else {
            this.addFunctor = new AddFunctor();
            this.removeFunctor = new RemoveFunctor();
            this.recordsWithNullValue = new ConcurrentHashMap<Data, QueryableEntry>();
        }
    }

    @Override
    Object newIndexInternal(Comparable newValue, QueryableEntry record) {
        return this.addFunctor.invoke(newValue, record);
    }

    @Override
    Object removeIndexInternal(Comparable oldValue, Data recordKey) {
        return this.removeFunctor.invoke(oldValue, recordKey);
    }

    @Override
    public void clear() {
        this.takeWriteLock();
        try {
            this.recordsWithNullValue.clear();
            this.recordMap.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecordsBetween(Comparable from, Comparable to) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            NavigableMap subMap = this.recordMap.subMap((Object)from, true, (Object)to, true);
            for (Map value : subMap.values()) {
                this.copyToMultiResultSet(results, value);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedValue) {
        this.takeReadLock();
        try {
            NavigableMap subMap;
            MultiResultSet results = this.createMultiResultSet();
            switch (comparisonType) {
                case LESSER: {
                    subMap = this.recordMap.headMap((Object)searchedValue, false);
                    break;
                }
                case LESSER_EQUAL: {
                    subMap = this.recordMap.headMap((Object)searchedValue, true);
                    break;
                }
                case GREATER: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, false);
                    break;
                }
                case GREATER_EQUAL: {
                    subMap = this.recordMap.tailMap((Object)searchedValue, true);
                    break;
                }
                case NOT_EQUAL: {
                    for (Map.Entry<Comparable, Map<Data, QueryableEntry>> entry : this.recordMap.entrySet()) {
                        if (searchedValue.equals(entry.getKey())) continue;
                        this.copyToMultiResultSet(results, entry.getValue());
                    }
                    MultiResultSet multiResultSet = results;
                    return multiResultSet;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized comparisonType: " + (Object)((Object)comparisonType));
                }
            }
            for (Map value : subMap.values()) {
                this.copyToMultiResultSet(results, value);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                Set<QueryableEntry> set = this.toSingleResultSet(this.recordsWithNullValue);
                return set;
            }
            Set<QueryableEntry> set = this.toSingleResultSet(this.recordMap.get(value));
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            for (Comparable value : values) {
                Map<Data, QueryableEntry> records = value instanceof IndexImpl.NullObject ? this.recordsWithNullValue : this.recordMap.get(value);
                if (records == null) continue;
                this.copyToMultiResultSet(results, records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public String toString() {
        return "SortedIndexStore{recordMap=" + this.recordMap.size() + '}';
    }

    private class CopyOnWriteRemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private CopyOnWriteRemoveFunctor() {
        }

        @Override
        public Object invoke(Comparable attribute, Data indexKey) {
            Object oldValue;
            if (attribute instanceof IndexImpl.NullObject) {
                HashMap copy = new HashMap(SortedIndexStore.this.recordsWithNullValue);
                oldValue = copy.remove(indexKey);
                SortedIndexStore.this.recordsWithNullValue = copy;
            } else {
                HashMap records = (HashMap)SortedIndexStore.this.recordMap.get(attribute);
                if (records != null) {
                    records = new HashMap(records);
                    oldValue = records.remove(indexKey);
                    if (records.isEmpty()) {
                        SortedIndexStore.this.recordMap.remove(attribute);
                    } else {
                        SortedIndexStore.this.recordMap.put(attribute, records);
                    }
                } else {
                    oldValue = null;
                }
            }
            return oldValue;
        }
    }

    private class RemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private RemoveFunctor() {
        }

        @Override
        public Object invoke(Comparable attribute, Data indexKey) {
            Object oldValue;
            if (attribute instanceof IndexImpl.NullObject) {
                oldValue = SortedIndexStore.this.recordsWithNullValue.remove(indexKey);
            } else {
                Map records = (Map)SortedIndexStore.this.recordMap.get(attribute);
                if (records != null) {
                    oldValue = records.remove(indexKey);
                    if (records.size() == 0) {
                        SortedIndexStore.this.recordMap.remove(attribute);
                    }
                } else {
                    oldValue = null;
                }
            }
            return oldValue;
        }
    }

    private class CopyOnWriteAddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private CopyOnWriteAddFunctor() {
        }

        @Override
        public Object invoke(Comparable attribute, QueryableEntry entry) {
            QueryableEntry oldValue;
            if (attribute instanceof IndexImpl.NullObject) {
                HashMap<Data, QueryableEntry> copy = new HashMap<Data, QueryableEntry>(SortedIndexStore.this.recordsWithNullValue);
                oldValue = copy.put(entry.getKeyData(), entry);
                SortedIndexStore.this.recordsWithNullValue = copy;
            } else {
                Map<Data, QueryableEntry> records = (Map<Data, QueryableEntry>)SortedIndexStore.this.recordMap.get(attribute);
                if (records == null) {
                    records = Collections.emptyMap();
                }
                records = new HashMap(records);
                oldValue = records.put(entry.getKeyData(), entry);
                SortedIndexStore.this.recordMap.put(attribute, records);
            }
            return oldValue;
        }
    }

    private class AddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private AddFunctor() {
        }

        @Override
        public Object invoke(Comparable attribute, QueryableEntry entry) {
            if (attribute instanceof IndexImpl.NullObject) {
                return SortedIndexStore.this.recordsWithNullValue.put(entry.getKeyData(), entry);
            }
            ConcurrentHashMap<Data, QueryableEntry> records = (ConcurrentHashMap<Data, QueryableEntry>)SortedIndexStore.this.recordMap.get(attribute);
            if (records == null) {
                records = new ConcurrentHashMap<Data, QueryableEntry>(1, 0.75f, 1);
                SortedIndexStore.this.recordMap.put(attribute, records);
            }
            return records.put(entry.getKeyData(), entry);
        }
    }
}

