/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.monitor.impl.IndexOperationStats;
import com.hazelcast.monitor.impl.PerIndexStats;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import com.hazelcast.query.impl.SortedIndexStore;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.query.impl.UnsortedIndexStore;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.PredicateDataSerializerHook;
import com.hazelcast.util.SetUtil;
import java.util.Collections;
import java.util.Set;

public class IndexImpl
implements InternalIndex {
    public static final NullObject NULL = new NullObject();
    protected final InternalSerializationService ss;
    protected final IndexStore indexStore;
    private final String attributeName;
    private final boolean ordered;
    private final Extractors extractors;
    private final IndexCopyBehavior copyBehavior;
    private final PerIndexStats stats;
    private volatile TypeConverter converter;

    public IndexImpl(String attributeName, boolean ordered, InternalSerializationService ss, Extractors extractors, IndexCopyBehavior copyBehavior, PerIndexStats stats) {
        this.attributeName = attributeName;
        this.ordered = ordered;
        this.ss = ss;
        this.copyBehavior = copyBehavior;
        this.indexStore = this.createIndexStore(ordered, stats);
        this.extractors = extractors;
        this.stats = stats;
    }

    protected IndexStore createIndexStore(boolean ordered, PerIndexStats stats) {
        return ordered ? new SortedIndexStore(this.copyBehavior) : new UnsortedIndexStore(this.copyBehavior);
    }

    @Override
    public void saveEntryIndex(QueryableEntry entry, Object oldRecordValue, Index.OperationSource operationSource) {
        long timestamp = this.stats.makeTimestamp();
        IndexOperationStats operationStats = this.stats.createOperationStats();
        if (this.converter == null || this.converter == TypeConverters.NULL_CONVERTER) {
            this.converter = entry.getConverter(this.attributeName);
        }
        Object newAttributeValue = this.extractAttributeValue(entry.getKeyData(), entry.getTargetObject(false));
        if (oldRecordValue == null) {
            this.indexStore.newIndex(newAttributeValue, entry, operationStats);
            this.stats.onInsert(timestamp, operationStats, operationSource);
        } else {
            Object oldAttributeValue = this.extractAttributeValue(entry.getKeyData(), oldRecordValue);
            this.indexStore.updateIndex(oldAttributeValue, newAttributeValue, entry, operationStats);
            this.stats.onUpdate(timestamp, operationStats, operationSource);
        }
    }

    @Override
    public void removeEntryIndex(Data key, Object value, Index.OperationSource operationSource) {
        long timestamp = this.stats.makeTimestamp();
        IndexOperationStats operationStats = this.stats.createOperationStats();
        Object attributeValue = this.extractAttributeValue(key, value);
        this.indexStore.removeIndex(attributeValue, key, operationStats);
        this.stats.onRemove(timestamp, operationStats, operationSource);
    }

    private Object extractAttributeValue(Data key, Object value) {
        return QueryableEntry.extractAttributeValue(this.extractors, this.ss, this.attributeName, key, value);
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable[] values) {
        if (values.length == 1) {
            return this.getRecords(values[0]);
        }
        long timestamp = this.stats.makeTimestamp();
        if (this.converter != null) {
            Set<Comparable> convertedValues = SetUtil.createHashSet(values.length);
            for (Comparable value : values) {
                convertedValues.add(this.convert(value));
            }
            Set<QueryableEntry> result = this.indexStore.getRecords(convertedValues);
            this.stats.onIndexHit(timestamp, result.size());
            return result;
        }
        this.stats.onIndexHit(timestamp, 0L);
        return Collections.emptySet();
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable attributeValue) {
        long timestamp = this.stats.makeTimestamp();
        if (this.converter == null) {
            this.stats.onIndexHit(timestamp, 0L);
            return new SingleResultSet(null);
        }
        Set<QueryableEntry> result = this.indexStore.getRecords(this.convert(attributeValue));
        this.stats.onIndexHit(timestamp, result.size());
        return result;
    }

    @Override
    public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedAttributeValue) {
        long timestamp = this.stats.makeTimestamp();
        if (this.converter == null) {
            this.stats.onIndexHit(timestamp, 0L);
            return Collections.emptySet();
        }
        Set<QueryableEntry> result = this.indexStore.getSubRecords(comparisonType, this.convert(searchedAttributeValue));
        this.stats.onIndexHit(timestamp, result.size());
        return result;
    }

    @Override
    public Set<QueryableEntry> getSubRecordsBetween(Comparable fromAttributeValue, Comparable toAttributeValue) {
        long timestamp = this.stats.makeTimestamp();
        if (this.converter == null) {
            this.stats.onIndexHit(timestamp, 0L);
            return Collections.emptySet();
        }
        Set<QueryableEntry> result = this.indexStore.getSubRecordsBetween(this.convert(fromAttributeValue), this.convert(toAttributeValue));
        this.stats.onIndexHit(timestamp, result.size());
        return result;
    }

    private Comparable convert(Comparable attributeValue) {
        return this.converter.convert(attributeValue);
    }

    @Override
    public TypeConverter getConverter() {
        return this.converter;
    }

    @Override
    public void clear() {
        this.indexStore.clear();
        this.converter = null;
        this.stats.onClear();
    }

    @Override
    public void destroy() {
        this.stats.onClear();
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public PerIndexStats getPerIndexStats() {
        return this.stats;
    }

    public static final class NullObject
    implements Comparable,
    IdentifiedDataSerializable {
        public int compareTo(Object o) {
            if (o == this || o instanceof NullObject) {
                return 0;
            }
            return -1;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public void writeData(ObjectDataOutput out) {
        }

        @Override
        public void readData(ObjectDataInput in) {
        }

        @Override
        public int getFactoryId() {
            return PredicateDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 17;
        }
    }
}

