/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.internal.networking.Channel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.util.AddressUtil;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;

public class TcpIpConnector {
    private static final int DEFAULT_IPV6_SOCKET_CONNECT_TIMEOUT_SECONDS = 3;
    private static final int MILLIS_PER_SECOND = 1000;
    private final TcpIpConnectionManager connectionManager;
    private final ILogger logger;
    private final IOService ioService;
    private final int outboundPortCount;
    private final LinkedList<Integer> outboundPorts = new LinkedList();

    public TcpIpConnector(TcpIpConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.ioService = connectionManager.getIoService();
        this.logger = this.ioService.getLoggingService().getLogger(this.getClass());
        Collection<Integer> ports = this.ioService.getOutboundPorts();
        this.outboundPortCount = ports.size();
        this.outboundPorts.addAll(ports);
    }

    void asyncConnect(Address address, boolean silent) {
        this.ioService.shouldConnectTo(address);
        this.ioService.executeAsync(new ConnectTask(address, silent));
    }

    private boolean useAnyOutboundPort() {
        return this.outboundPortCount == 0;
    }

    private int getOutboundPortCount() {
        return this.outboundPortCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireOutboundPort() {
        if (this.useAnyOutboundPort()) {
            return 0;
        }
        LinkedList<Integer> linkedList = this.outboundPorts;
        synchronized (linkedList) {
            Integer port = this.outboundPorts.removeFirst();
            this.outboundPorts.addLast(port);
            return port;
        }
    }

    private final class ConnectTask
    implements Runnable {
        private final Address address;
        private final boolean silent;

        ConnectTask(Address address, boolean silent) {
            this.address = address;
            this.silent = silent;
        }

        @Override
        public void run() {
            if (!TcpIpConnector.this.connectionManager.isLive()) {
                if (TcpIpConnector.this.logger.isFinestEnabled()) {
                    TcpIpConnector.this.logger.finest("ConnectionManager is not live, connection attempt to " + this.address + " is cancelled!");
                }
                return;
            }
            if (TcpIpConnector.this.logger.isFinestEnabled()) {
                TcpIpConnector.this.logger.finest("Starting to connect to " + this.address);
            }
            try {
                Address thisAddress = TcpIpConnector.this.ioService.getThisAddress();
                if (this.address.isIPv4()) {
                    this.tryToConnect(this.address.getInetSocketAddress(), TcpIpConnector.this.ioService.getSocketConnectTimeoutSeconds() * 1000);
                } else if (thisAddress.isIPv6() && thisAddress.getScopeId() != null) {
                    Inet6Address inetAddress = AddressUtil.getInetAddressFor((Inet6Address)this.address.getInetAddress(), thisAddress.getScopeId());
                    this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), TcpIpConnector.this.ioService.getSocketConnectTimeoutSeconds() * 1000);
                } else {
                    this.tryConnectToIPv6();
                }
            }
            catch (Throwable e) {
                TcpIpConnector.this.logger.finest(e);
                TcpIpConnector.this.connectionManager.failedConnection(this.address, e, this.silent);
            }
        }

        private void tryConnectToIPv6() throws Exception {
            Level level;
            Collection<Inet6Address> possibleInetAddresses = AddressUtil.getPossibleInetAddressesFor((Inet6Address)this.address.getInetAddress());
            Level level2 = level = this.silent ? Level.FINEST : Level.INFO;
            if (TcpIpConnector.this.logger.isLoggable(level)) {
                TcpIpConnector.this.logger.log(level, "Trying to connect possible IPv6 addresses: " + possibleInetAddresses);
            }
            boolean connected = false;
            Exception error = null;
            int configuredTimeoutMillis = TcpIpConnector.this.ioService.getSocketConnectTimeoutSeconds() * 1000;
            int timeoutMillis = configuredTimeoutMillis > 0 && configuredTimeoutMillis < Integer.MAX_VALUE ? configuredTimeoutMillis : 3000;
            for (Inet6Address inetAddress : possibleInetAddresses) {
                try {
                    this.tryToConnect(new InetSocketAddress(inetAddress, this.address.getPort()), timeoutMillis);
                    connected = true;
                    break;
                }
                catch (Exception e) {
                    error = e;
                }
            }
            if (!connected && error != null) {
                throw error;
            }
        }

        private void tryToConnect(InetSocketAddress socketAddress, int timeout) throws Exception {
            Level level;
            SocketChannel socketChannel = SocketChannel.open();
            Channel channel = TcpIpConnector.this.connectionManager.createChannel(socketChannel, true);
            if (TcpIpConnector.this.ioService.isSocketBind()) {
                this.bindSocket(socketChannel);
            }
            Level level2 = level = this.silent ? Level.FINEST : Level.INFO;
            if (TcpIpConnector.this.logger.isLoggable(level)) {
                TcpIpConnector.this.logger.log(level, "Connecting to " + socketAddress + ", timeout: " + timeout + ", bind-any: " + TcpIpConnector.this.ioService.isSocketBindAny());
            }
            try {
                channel.connect(socketAddress, timeout);
                TcpIpConnector.this.ioService.interceptSocket(socketChannel.socket(), false);
                TcpIpConnection connection = TcpIpConnector.this.connectionManager.newConnection(channel, this.address);
                TcpIpConnector.this.connectionManager.sendBindRequest(connection, this.address, true);
            }
            catch (NullPointerException e) {
                this.closeSocket(socketChannel);
                TcpIpConnector.this.logger.log(level, "Could not connect to: " + socketAddress + ". Reason: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
                TcpIpConnector.this.logger.log(Level.INFO, "Add this stacktrace to https://github.com/hazelcast/hazelcast-enterprise/issues/2104 please!", e);
                throw e;
            }
            catch (Exception e) {
                this.closeSocket(socketChannel);
                TcpIpConnector.this.logger.log(level, "Could not connect to: " + socketAddress + ". Reason: " + e.getClass().getSimpleName() + "[" + e.getMessage() + "]");
                throw e;
            }
        }

        private void bindSocket(SocketChannel socketChannel) throws IOException {
            InetAddress inetAddress = this.getInetAddress();
            Socket socket = socketChannel.socket();
            if (!TcpIpConnector.this.useAnyOutboundPort()) {
                IOException ex = null;
                int retryCount = TcpIpConnector.this.getOutboundPortCount() * 2;
                for (int i = 0; i < retryCount; ++i) {
                    int port = TcpIpConnector.this.acquireOutboundPort();
                    InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, port);
                    try {
                        socket.bind(socketAddress);
                        return;
                    }
                    catch (IOException e) {
                        ex = e;
                        TcpIpConnector.this.logger.finest("Could not bind port[ " + port + "]: " + e.getMessage());
                        continue;
                    }
                }
                throw ex;
            }
            InetSocketAddress socketAddress = new InetSocketAddress(inetAddress, 0);
            socket.bind(socketAddress);
        }

        private InetAddress getInetAddress() throws UnknownHostException {
            return TcpIpConnector.this.ioService.isSocketBindAny() ? null : TcpIpConnector.this.ioService.getThisAddress().getInetAddress();
        }

        private void closeSocket(SocketChannel socketChannel) {
            if (socketChannel != null) {
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    TcpIpConnector.this.logger.finest("Closing socket channel failed", e);
                }
            }
        }
    }
}

