/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.nio.SelectorMode;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class TcpIpAcceptor
implements MetricsProvider {
    private static final long SHUTDOWN_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final long SELECT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final int SELECT_IDLE_COUNT_THRESHOLD = 10;
    private final ServerSocketChannel serverSocketChannel;
    private final TcpIpConnectionManager connectionManager;
    private final ILogger logger;
    private final IOService ioService;
    @Probe
    private final SwCounter eventCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter exceptionCount = SwCounter.newSwCounter();
    @Probe
    private final SwCounter selectorRecreateCount = SwCounter.newSwCounter();
    private final AcceptorIOThread acceptorThread;
    private volatile long lastSelectTimeMs;
    private final boolean selectorWorkaround = SelectorMode.getConfiguredValue() == SelectorMode.SELECT_WITH_FIX;
    private volatile boolean stop;
    private volatile Selector selector;
    private SelectionKey selectionKey;

    public TcpIpAcceptor(ServerSocketChannel serverSocketChannel, TcpIpConnectionManager connectionManager) {
        this.serverSocketChannel = serverSocketChannel;
        this.connectionManager = connectionManager;
        this.ioService = connectionManager.getIoService();
        this.logger = this.ioService.getLoggingService().getLogger(this.getClass());
        this.acceptorThread = new AcceptorIOThread();
    }

    @Probe
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastSelectTimeMs, 0L);
    }

    @Override
    public void provideMetrics(MetricsRegistry registry) {
        registry.scanAndRegister(this, "tcp." + this.acceptorThread.getName());
    }

    public TcpIpAcceptor start() {
        this.acceptorThread.start();
        return this;
    }

    public synchronized void shutdown() {
        if (this.stop) {
            return;
        }
        this.logger.finest("Shutting down SocketAcceptor thread.");
        this.stop = true;
        Selector sel = this.selector;
        if (sel != null) {
            sel.wakeup();
        }
        try {
            this.acceptorThread.join(SHUTDOWN_TIMEOUT_MILLIS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.finest(e);
        }
    }

    private final class AcceptorIOThread
    extends Thread {
        private AcceptorIOThread() {
            super(ThreadUtil.createThreadPoolName(TcpIpAcceptor.this.ioService.getHazelcastName(), "IO") + "Acceptor");
        }

        @Override
        public void run() {
            if (TcpIpAcceptor.this.logger.isFinestEnabled()) {
                TcpIpAcceptor.this.logger.finest("Starting TcpIpAcceptor on " + TcpIpAcceptor.this.serverSocketChannel);
            }
            try {
                TcpIpAcceptor.this.selector = Selector.open();
                TcpIpAcceptor.this.serverSocketChannel.configureBlocking(false);
                TcpIpAcceptor.this.selectionKey = TcpIpAcceptor.this.serverSocketChannel.register(TcpIpAcceptor.this.selector, 16);
                if (TcpIpAcceptor.this.selectorWorkaround) {
                    this.acceptLoopWithSelectorFix();
                } else {
                    this.acceptLoop();
                }
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory(e);
            }
            catch (Throwable e) {
                TcpIpAcceptor.this.logger.severe(e.getClass().getName() + ": " + e.getMessage(), e);
            }
            finally {
                this.closeSelector();
            }
        }

        private void acceptLoop() throws IOException {
            while (!TcpIpAcceptor.this.stop) {
                int keyCount = TcpIpAcceptor.this.selector.select();
                if (this.isInterrupted()) break;
                if (keyCount == 0) continue;
                Iterator<SelectionKey> it = TcpIpAcceptor.this.selector.selectedKeys().iterator();
                this.handleSelectionKeys(it);
            }
        }

        private void acceptLoopWithSelectorFix() throws IOException {
            int idleCount = 0;
            while (!TcpIpAcceptor.this.stop) {
                long before = System.currentTimeMillis();
                int keyCount = TcpIpAcceptor.this.selector.select(SELECT_TIMEOUT_MILLIS);
                if (this.isInterrupted()) break;
                if (keyCount == 0) {
                    long selectTimeTaken = System.currentTimeMillis() - before;
                    idleCount = selectTimeTaken < SELECT_TIMEOUT_MILLIS ? idleCount + 1 : 0;
                    if (idleCount <= 10) continue;
                    this.rebuildSelector();
                    idleCount = 0;
                    continue;
                }
                idleCount = 0;
                Iterator<SelectionKey> it = TcpIpAcceptor.this.selector.selectedKeys().iterator();
                this.handleSelectionKeys(it);
            }
        }

        private void rebuildSelector() throws IOException {
            TcpIpAcceptor.this.selectorRecreateCount.inc();
            TcpIpAcceptor.this.selectionKey.cancel();
            this.closeSelector();
            Selector newSelector = Selector.open();
            TcpIpAcceptor.this.selector = newSelector;
            TcpIpAcceptor.this.selectionKey = TcpIpAcceptor.this.serverSocketChannel.register(newSelector, 16);
        }

        private void handleSelectionKeys(Iterator<SelectionKey> it) {
            TcpIpAcceptor.this.lastSelectTimeMs = System.currentTimeMillis();
            while (it.hasNext()) {
                SelectionKey sk = it.next();
                it.remove();
                if (!sk.isValid() || !sk.isAcceptable()) continue;
                TcpIpAcceptor.this.eventCount.inc();
                this.acceptSocket();
            }
        }

        private void closeSelector() {
            if (TcpIpAcceptor.this.selector == null) {
                return;
            }
            if (TcpIpAcceptor.this.logger.isFinestEnabled()) {
                TcpIpAcceptor.this.logger.finest("Closing selector " + Thread.currentThread().getName());
            }
            try {
                TcpIpAcceptor.this.selector.close();
            }
            catch (Exception e) {
                TcpIpAcceptor.this.logger.finest("Exception while closing selector", e);
            }
        }

        private void acceptSocket() {
            Channel channel = null;
            try {
                SocketChannel socketChannel = TcpIpAcceptor.this.serverSocketChannel.accept();
                if (socketChannel != null) {
                    channel = TcpIpAcceptor.this.connectionManager.createChannel(socketChannel, false);
                }
            }
            catch (Exception e) {
                TcpIpAcceptor.this.exceptionCount.inc();
                if (e instanceof ClosedChannelException && !TcpIpAcceptor.this.connectionManager.isLive()) {
                    TcpIpAcceptor.this.logger.finest("Terminating socket acceptor thread...", e);
                }
                TcpIpAcceptor.this.logger.severe("Unexpected error while accepting connection! " + e.getClass().getName() + ": " + e.getMessage());
                try {
                    TcpIpAcceptor.this.serverSocketChannel.close();
                }
                catch (Exception ex) {
                    TcpIpAcceptor.this.logger.finest("Closing server socket failed", ex);
                }
                TcpIpAcceptor.this.ioService.onFatalError(e);
            }
            if (channel != null) {
                final Channel theChannel = channel;
                TcpIpAcceptor.this.logger.info("Accepting socket connection from " + theChannel.socket().getRemoteSocketAddress());
                if (TcpIpAcceptor.this.ioService.isSocketInterceptorEnabled()) {
                    TcpIpAcceptor.this.ioService.executeAsync(new Runnable(){

                        @Override
                        public void run() {
                            AcceptorIOThread.this.configureAndAssignSocket(theChannel);
                        }
                    });
                } else {
                    this.configureAndAssignSocket(theChannel);
                }
            }
        }

        private void configureAndAssignSocket(Channel channel) {
            try {
                TcpIpAcceptor.this.ioService.interceptSocket(channel.socket(), true);
                TcpIpAcceptor.this.connectionManager.newConnection(channel, null);
            }
            catch (Exception e) {
                TcpIpAcceptor.this.exceptionCount.inc();
                TcpIpAcceptor.this.logger.warning(e.getClass().getName() + ": " + e.getMessage(), e);
                IOUtil.closeResource(channel);
            }
        }
    }
}

