/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.internal.eviction.ClearExpiredRecordsTask;
import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.ClearExpiredOperation;
import com.hazelcast.map.impl.recordstore.AbstractEvictableRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class MapClearExpiredRecordsTask
extends ClearExpiredRecordsTask<PartitionContainer>
implements OperationResponseHandler {
    public static final String PROP_PRIMARY_DRIVES_BACKUP = "hazelcast.internal.map.expiration.primary.drives_backup";
    public static final String PROP_CLEANUP_PERCENTAGE = "hazelcast.internal.map.expiration.cleanup.percentage";
    public static final String PROP_CLEANUP_OPERATION_COUNT = "hazelcast.internal.map.expiration.cleanup.operation.count";
    public static final String PROP_TASK_PERIOD_SECONDS = "hazelcast.internal.map.expiration.task.period.seconds";
    public static final int DEFAULT_TASK_PERIOD_SECONDS = 5;
    public static final HazelcastProperty TASK_PERIOD_SECONDS = new HazelcastProperty("hazelcast.internal.map.expiration.task.period.seconds", 5, TimeUnit.SECONDS);
    public static final boolean DEFAULT_PRIMARY_DRIVES_BACKUP = true;
    public static final int DEFAULT_CLEANUP_PERCENTAGE = 10;
    public static final int MAX_EXPIRED_KEY_COUNT_IN_BATCH = 100;
    public static final HazelcastProperty PRIMARY_DRIVES_BACKUP = new HazelcastProperty("hazelcast.internal.map.expiration.primary.drives_backup", true);
    public static final HazelcastProperty CLEANUP_PERCENTAGE = new HazelcastProperty("hazelcast.internal.map.expiration.cleanup.percentage", 10);
    public static final HazelcastProperty CLEANUP_OPERATION_COUNT = new HazelcastProperty("hazelcast.internal.map.expiration.cleanup.operation.count");
    protected final boolean primaryDrivesEviction;
    private final Comparator<PartitionContainer> partitionContainerComparator = new Comparator<PartitionContainer>(){

        @Override
        public int compare(PartitionContainer o1, PartitionContainer o2) {
            long s2;
            long s1 = o1.getLastCleanupTimeCopy();
            return s1 < (s2 = o2.getLastCleanupTimeCopy()) ? -1 : (s1 == s2 ? 0 : 1);
        }
    };

    public MapClearExpiredRecordsTask(NodeEngine nodeEngine, PartitionContainer[] containers) {
        super(nodeEngine, containers, CLEANUP_OPERATION_COUNT, CLEANUP_PERCENTAGE, TASK_PERIOD_SECONDS);
        this.primaryDrivesEviction = nodeEngine.getProperties().getBoolean(PRIMARY_DRIVES_BACKUP);
    }

    @Override
    protected void sortPartitionContainers(List<PartitionContainer> partitionContainers) {
        this.updateLastCleanupTimesBeforeSorting(partitionContainers);
        Collections.sort(partitionContainers, this.partitionContainerComparator);
    }

    public void sendResponse(Operation op, Object response) {
        if (this.canPrimaryDriveExpiration()) {
            PartitionContainer partitionContainer = ((PartitionContainer[])this.containers)[op.getPartitionId()];
            this.doBackupExpiration(partitionContainer);
        }
    }

    public boolean canPrimaryDriveExpiration() {
        return this.primaryDrivesEviction;
    }

    private void doBackupExpiration(PartitionContainer container) {
        ConcurrentMap<String, RecordStore> maps = container.getMaps();
        for (RecordStore recordStore : maps.values()) {
            ((AbstractEvictableRecordStore)recordStore).sendExpiredKeysToBackups(false);
        }
    }

    @Override
    protected Operation createExpirationOperation(int expirationPercentage, PartitionContainer container) {
        int partitionId = container.getPartitionId();
        return new ClearExpiredOperation(expirationPercentage).setNodeEngine(this.nodeEngine).setCallerUuid(this.nodeEngine.getLocalMember().getUuid()).setPartitionId(partitionId).setValidateTarget(false).setServiceName("hz:impl:mapService").setOperationResponseHandler(this);
    }

    @Override
    protected boolean hasExpiredKeyToSendBackup(PartitionContainer container) {
        long size = 0L;
        ConcurrentMap<String, RecordStore> maps = container.getMaps();
        for (RecordStore store : maps.values()) {
            if ((size += (long)store.getExpiredKeys().size()) <= 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasRunningCleanup(PartitionContainer container) {
        return container.hasRunningCleanup();
    }

    @Override
    protected void setHasRunningCleanup(PartitionContainer container, boolean status) {
        container.setHasRunningCleanup(status);
    }

    @Override
    protected void clearLeftoverExpiredKeyQueues(PartitionContainer container) {
        ConcurrentMap<String, RecordStore> maps = container.getMaps();
        for (RecordStore store : maps.values()) {
            InvalidationQueue<ExpiredKey> expiredKeys = store.getExpiredKeys();
            while (expiredKeys.poll() != null) {
            }
        }
    }

    @Override
    protected boolean notHaveAnyExpirableRecord(PartitionContainer partitionContainer) {
        boolean notExist = true;
        ConcurrentMap<String, RecordStore> maps = partitionContainer.getMaps();
        for (RecordStore store : maps.values()) {
            if (!store.isExpirable()) continue;
            notExist = false;
            break;
        }
        return notExist;
    }

    @Override
    protected boolean isContainerEmpty(PartitionContainer container) {
        long size = 0L;
        ConcurrentMap<String, RecordStore> maps = container.getMaps();
        for (RecordStore store : maps.values()) {
            if ((size += (long)store.size()) <= 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    protected long getLastCleanupTime(PartitionContainer container) {
        return container.getLastCleanupTime();
    }

    private void updateLastCleanupTimesBeforeSorting(List<PartitionContainer> partitionContainers) {
        for (PartitionContainer partitionContainer : partitionContainers) {
            partitionContainer.setLastCleanupTimeCopy(partitionContainer.getLastCleanupTime());
        }
    }

    public String toString() {
        return MapClearExpiredRecordsTask.class.getName();
    }
}

