/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.networking.AbstractChannel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.OutboundFrame;
import com.hazelcast.internal.networking.nio.NioChannelOptions;
import com.hazelcast.internal.networking.nio.NioInboundPipeline;
import com.hazelcast.internal.networking.nio.NioOutboundPipeline;
import com.hazelcast.internal.networking.nio.NioThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Date;

public final class NioChannel
extends AbstractChannel {
    private static final int DELAY_MS = Integer.getInteger("hazelcast.channel.close.delayMs", 200);
    NioInboundPipeline inboundPipeline;
    NioOutboundPipeline outboundPipeline;
    private final ChannelInitializer channelInitializer;
    private final NioChannelOptions config;

    public NioChannel(SocketChannel socketChannel, boolean clientMode, ChannelInitializer channelInitializer) {
        super(socketChannel, clientMode);
        this.channelInitializer = channelInitializer;
        this.config = new NioChannelOptions(socketChannel.socket());
    }

    @Override
    public NioChannelOptions options() {
        return this.config;
    }

    public void init(NioInboundPipeline inboundPipeline, NioOutboundPipeline outboundPipeline) {
        this.inboundPipeline = inboundPipeline;
        this.outboundPipeline = outboundPipeline;
    }

    @Override
    public NioOutboundPipeline outboundPipeline() {
        return this.outboundPipeline;
    }

    @Override
    public NioInboundPipeline inboundPipeline() {
        return this.inboundPipeline;
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (this.isClosed()) {
            return false;
        }
        this.outboundPipeline.write(frame);
        return true;
    }

    @Override
    public long lastReadTimeMillis() {
        return this.inboundPipeline.lastReadTimeMillis();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.outboundPipeline.lastWriteTimeMillis();
    }

    @Override
    public void start() {
        try {
            this.socketChannel.configureBlocking(false);
            this.channelInitializer.initChannel(this);
        }
        catch (Exception e) {
            throw new HazelcastException("Failed to start " + this, e);
        }
        this.inboundPipeline.start();
        this.outboundPipeline.start();
    }

    @Override
    protected void close0() {
        if (Thread.currentThread() instanceof NioThread) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        NioChannel.this.doClose();
                    }
                    catch (Exception e) {
                        NioChannel.this.logger.warning(e.getMessage(), e);
                    }
                }
            }.start();
        } else {
            this.doClose();
        }
    }

    private void doClose() {
        try {
            this.inboundPipeline.requestClose();
            this.outboundPipeline.requestClose();
            try {
                Thread.sleep(DELAY_MS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                this.socketChannel.close();
            }
            catch (IOException e) {
                this.logger.warning(e);
            }
        }
        finally {
            this.notifyCloseListeners();
        }
    }

    public String toString() {
        try {
            String s;
            InetSocketAddress local = (InetSocketAddress)this.localSocketAddress();
            InetSocketAddress remote = (InetSocketAddress)this.remoteSocketAddress();
            String string = s = this.isClientMode() ? local.getPort() + "=>" + remote.getPort() : local.getPort() + "->" + remote.getPort();
            if (!this.isClientMode()) {
                s = "                                                                                " + s;
            }
            Date date = new Date();
            return date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + " " + s;
        }
        catch (NullPointerException e) {
            return "Better protection needed";
        }
    }
}

