/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction;

import com.hazelcast.nio.Address;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.partition.IPartition;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.Clock;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
public abstract class ClearExpiredRecordsTask<T>
implements Runnable {
    public static final int DIFFERENCE_BETWEEN_TWO_SUBSEQUENT_PARTITION_CLEANUP_MILLIS = 1000;
    protected final int cleanupOperationCount;
    protected final int cleanupPercentage;
    protected final int taskPeriodSeconds;
    protected final T[] containers;
    protected NodeEngine nodeEngine;
    protected InternalOperationService operationService;
    volatile long lastStartMillis;
    volatile long lastEndMillis;
    private AtomicBoolean singleRunPermit = new AtomicBoolean(false);
    private Address thisAddress;
    private int partitionCount;
    private IPartitionService partitionService;
    private HazelcastProperties properties;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ClearExpiredRecordsTask(NodeEngine nodeEngine, T[] containers, HazelcastProperty cleanupOpProperty, HazelcastProperty cleanupPercentageProperty, HazelcastProperty taskPeriodProperty) {
        this.properties = nodeEngine.getProperties();
        this.containers = containers;
        this.nodeEngine = nodeEngine;
        this.operationService = (InternalOperationService)nodeEngine.getOperationService();
        this.partitionService = nodeEngine.getPartitionService();
        this.partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.thisAddress = nodeEngine.getThisAddress();
        this.cleanupOperationCount = ClearExpiredRecordsTask.calculateCleanupOperationCount(this.properties, cleanupOpProperty, this.partitionCount, this.operationService.getPartitionThreadCount());
        Preconditions.checkPositive(this.cleanupOperationCount, "cleanupOperationCount should be a positive number");
        this.cleanupPercentage = this.properties.getInteger(cleanupPercentageProperty);
        Preconditions.checkTrue(this.cleanupPercentage > 0 && this.cleanupPercentage <= 100, "cleanupPercentage should be in range (0,100]");
        this.taskPeriodSeconds = nodeEngine.getProperties().getSeconds(taskPeriodProperty);
    }

    @Override
    public void run() {
        try {
            if (!this.singleRunPermit.compareAndSet(false, true)) {
                return;
            }
            this.lastStartMillis = System.currentTimeMillis();
            this.runInternal();
            this.lastEndMillis = System.currentTimeMillis();
        }
        finally {
            this.singleRunPermit.set(false);
        }
    }

    private void runInternal() {
        long now = Clock.currentTimeMillis();
        int inFlightCleanupOperationsCount = 0;
        List<T> containersToProcess = null;
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            IPartition partition = this.partitionService.getPartition(partitionId, false);
            T container = this.containers[partitionId];
            if (!partition.isOwnerOrBackup(this.thisAddress) || this.isContainerEmpty(container) && !this.hasExpiredKeyToSendBackup(container)) continue;
            if (this.hasRunningCleanup(container)) {
                ++inFlightCleanupOperationsCount;
                continue;
            }
            if (inFlightCleanupOperationsCount > this.cleanupOperationCount || this.notInProcessableTimeWindow(container, now) || this.notHaveAnyExpirableRecord(container)) continue;
            containersToProcess = this.addContainerTo(container, containersToProcess);
            if (partition.isLocal()) continue;
            this.clearLeftoverExpiredKeyQueues(container);
        }
        if (CollectionUtil.isEmpty(containersToProcess)) {
            return;
        }
        this.sortPartitionContainers(containersToProcess);
        this.sendCleanupOperations(containersToProcess);
    }

    private static int calculateCleanupOperationCount(HazelcastProperties properties, HazelcastProperty cleanupOpCountProperty, int partitionCount, int partitionThreadCount) {
        String stringValue = properties.getString(cleanupOpCountProperty);
        if (stringValue != null) {
            return Integer.parseInt(stringValue);
        }
        double scanPercentage = 0.1;
        int opCountFromPartitionCount = (int)((double)partitionCount * 0.1);
        int inflationFactor = 3;
        int opCountFromThreadCount = partitionThreadCount * 3;
        if (opCountFromPartitionCount == 0) {
            return opCountFromThreadCount;
        }
        return Math.min(opCountFromPartitionCount, opCountFromThreadCount);
    }

    private boolean notInProcessableTimeWindow(T container, long now) {
        return now - this.getLastCleanupTime(container) < 1000L;
    }

    private List<T> addContainerTo(T container, List<T> containersToProcess) {
        if (containersToProcess == null) {
            containersToProcess = new ArrayList<T>();
        }
        containersToProcess.add(container);
        return containersToProcess;
    }

    protected void sendCleanupOperations(List<T> partitionContainers) {
        boolean start = false;
        int end = this.cleanupOperationCount;
        if (end > partitionContainers.size()) {
            end = partitionContainers.size();
        }
        List<T> partitionIds = partitionContainers.subList(0, end);
        for (T container : partitionIds) {
            this.setHasRunningCleanup(container, true);
            Operation operation = this.createExpirationOperation(this.cleanupPercentage, container);
            this.operationService.execute(operation);
        }
    }

    int getCleanupPercentage() {
        return this.cleanupPercentage;
    }

    int getTaskPeriodSeconds() {
        return this.taskPeriodSeconds;
    }

    public int getCleanupOperationCount() {
        return this.cleanupOperationCount;
    }

    protected abstract boolean hasExpiredKeyToSendBackup(T var1);

    protected abstract boolean isContainerEmpty(T var1);

    protected abstract boolean hasRunningCleanup(T var1);

    protected abstract void setHasRunningCleanup(T var1, boolean var2);

    protected abstract boolean notHaveAnyExpirableRecord(T var1);

    protected abstract long getLastCleanupTime(T var1);

    protected abstract void clearLeftoverExpiredKeyQueues(T var1);

    protected abstract void sortPartitionContainers(List<T> var1);

    protected abstract Operation createExpirationOperation(int var1, T var2);
}

