/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.Joiner;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.DefaultAddressPicker;
import com.hazelcast.instance.DelegatingAddressPicker;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.instance.NodeExtensionFactory;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.Networking;
import com.hazelcast.internal.networking.nio.NioNetworking;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.NodeIOService;
import com.hazelcast.nio.tcp.TcpIpConnectionChannelErrorHandler;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.spi.MemberAddressProvider;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.ServerSocketChannel;
import java.util.Properties;

@PrivateApi
public class DefaultNodeContext
implements NodeContext {
    @Override
    public NodeExtension createNodeExtension(Node node) {
        return NodeExtensionFactory.create(node);
    }

    @Override
    public AddressPicker createAddressPicker(Node node) {
        Config config = node.getConfig();
        MemberAddressProviderConfig memberAddressProviderConfig = config.getNetworkConfig().getMemberAddressProviderConfig();
        ILogger addressPickerLogger = node.getLogger(AddressPicker.class);
        if (!memberAddressProviderConfig.isEnabled()) {
            return new DefaultAddressPicker(config, node.getProperties(), addressPickerLogger);
        }
        MemberAddressProvider implementation = memberAddressProviderConfig.getImplementation();
        if (implementation != null) {
            return new DelegatingAddressPicker(implementation, config.getNetworkConfig(), addressPickerLogger);
        }
        ClassLoader classLoader = config.getClassLoader();
        String classname = memberAddressProviderConfig.getClassName();
        Class<?> clazz = this.loadMemberAddressProviderClass(classLoader, classname);
        Constructor<?> constructor = this.findMemberAddressProviderConstructor(clazz);
        Properties properties = memberAddressProviderConfig.getProperties();
        MemberAddressProvider memberAddressProvider = this.newMemberAddressProviderInstance(constructor, properties);
        return new DelegatingAddressPicker(memberAddressProvider, config.getNetworkConfig(), addressPickerLogger);
    }

    private MemberAddressProvider newMemberAddressProviderInstance(Constructor<?> constructor, Properties properties) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        Class<?> clazz = constructor.getDeclaringClass();
        String classname = clazz.getName();
        try {
            if (parameterTypes.length == 0) {
                if (properties != null && !properties.isEmpty()) {
                    throw new ConfigurationException("Cannot find a matching constructor for MemberAddressProvider.  The member address provider has properties configured, but the class '" + classname + "' does not have a public constructor accepting properties.");
                }
                return (MemberAddressProvider)constructor.newInstance(new Object[0]);
            }
            if (properties == null) {
                properties = new Properties();
            }
            return (MemberAddressProvider)constructor.newInstance(properties);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Cannot create a new instance of MemberAddressProvider '" + clazz + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Cannot create a new instance of MemberAddressProvider '" + clazz + "'", e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Cannot create a new instance of MemberAddressProvider '" + clazz + "'", e);
        }
    }

    private Constructor<?> findMemberAddressProviderConstructor(Class<?> clazz) {
        Constructor<?> constructor;
        try {
            constructor = clazz.getConstructor(Properties.class);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new ConfigurationException("Cannot create a new instance of MemberAddressProvider '" + clazz + "'", e);
            }
        }
        return constructor;
    }

    private Class<?> loadMemberAddressProviderClass(ClassLoader classLoader, String classname) {
        try {
            return ClassLoaderUtil.loadClass(classLoader, classname);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Cannot create a new instance of MemberAddressProvider '" + classname + "'", e);
        }
    }

    @Override
    public Joiner createJoiner(Node node) {
        return node.createJoiner();
    }

    @Override
    public ConnectionManager createConnectionManager(Node node, ServerSocketChannel serverSocketChannel) {
        NodeIOService ioService = new NodeIOService(node, node.nodeEngine);
        Networking networking = this.createNetworking(node, ioService);
        return new TcpIpConnectionManager(ioService, serverSocketChannel, node.loggingService, node.nodeEngine.getMetricsRegistry(), networking, node.getProperties());
    }

    private Networking createNetworking(Node node, NodeIOService ioService) {
        ChannelInitializer initializer = node.getNodeExtension().createChannelInitializer(ioService);
        LoggingServiceImpl loggingService = node.loggingService;
        TcpIpConnectionChannelErrorHandler errorHandler = new TcpIpConnectionChannelErrorHandler(loggingService.getLogger(TcpIpConnectionChannelErrorHandler.class));
        HazelcastProperties props = node.getProperties();
        return new NioNetworking(new NioNetworking.Context().loggingService(loggingService).metricsRegistry(node.nodeEngine.getMetricsRegistry()).threadNamePrefix(node.hazelcastInstance.getName()).errorHandler(errorHandler).inputThreadCount(props.getInteger(GroupProperty.IO_INPUT_THREAD_COUNT)).outputThreadCount(props.getInteger(GroupProperty.IO_OUTPUT_THREAD_COUNT)).balancerIntervalSeconds(props.getInteger(GroupProperty.IO_BALANCER_INTERVAL_SECONDS)).channelInitializer(initializer));
    }
}

