/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractConfigBuilder;
import com.hazelcast.config.AtomicLongConfig;
import com.hazelcast.config.AtomicReferenceConfig;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigBuilder;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.ConsistencyCheckStrategy;
import com.hazelcast.config.CountDownLatchConfig;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.IcmpFailureDetectorConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JobTrackerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.MCMutualAuthConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PermissionPolicyConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.ProbabilisticQuorumConfigBuilder;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.QuorumConfig;
import com.hazelcast.config.QuorumConfigBuilder;
import com.hazelcast.config.QuorumListenerConfig;
import com.hazelcast.config.RecentlyActiveQuorumConfigBuilder;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.config.WANQueueFullBehavior;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.config.WanPublisherState;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.config.XmlConfigLocator;
import com.hazelcast.config.XmlElements;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.eviction.MapEvictionPolicy;
import com.hazelcast.mapreduce.TopologyChangedStrategy;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.spi.ServiceConfigurationParser;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlConfigBuilder
extends AbstractConfigBuilder
implements ConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(XmlConfigBuilder.class);
    private final Set<String> occurrenceSet = new HashSet<String>();
    private final InputStream in;
    private Properties properties = System.getProperties();
    private File configurationFile;
    private URL configurationUrl;
    private Config config;

    public XmlConfigBuilder(String xmlFileName) throws FileNotFoundException {
        this(new FileInputStream(xmlFileName));
        this.configurationFile = new File(xmlFileName);
    }

    public XmlConfigBuilder(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream can't be null");
        }
        this.in = inputStream;
    }

    public XmlConfigBuilder(URL url) throws IOException {
        Preconditions.checkNotNull(url, "URL is null!");
        this.in = url.openStream();
        this.configurationUrl = url;
    }

    public XmlConfigBuilder() {
        XmlConfigLocator locator = new XmlConfigLocator();
        this.in = locator.getIn();
        this.configurationFile = locator.getConfigurationFile();
        this.configurationUrl = locator.getConfigurationUrl();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public XmlConfigBuilder setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    protected AbstractConfigBuilder.ConfigType getXmlType() {
        return AbstractConfigBuilder.ConfigType.SERVER;
    }

    @Override
    public Config build() {
        return this.build(new Config());
    }

    Config build(Config config) {
        config.setConfigurationFile(this.configurationFile);
        config.setConfigurationUrl(this.configurationUrl);
        try {
            this.parseAndBuildConfig(config);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return config;
    }

    private void parseAndBuildConfig(Config config) throws Exception {
        this.config = config;
        Document doc = this.parse(this.in);
        Element root = doc.getDocumentElement();
        this.checkRootElement(root);
        try {
            root.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.process(root);
        if (this.shouldValidateTheSchema()) {
            this.schemaValidation(root.getOwnerDocument());
        }
        this.handleConfig(root);
    }

    private void checkRootElement(Element root) {
        String rootNodeName = root.getNodeName();
        if (!XmlElements.HAZELCAST.isEqual(rootNodeName)) {
            throw new InvalidConfigurationException("Invalid root element in xml configuration! Expected: <" + XmlElements.HAZELCAST.name + ">, Actual: <" + rootNodeName + ">.");
        }
    }

    private boolean shouldValidateTheSchema() {
        return System.getProperty("hazelcast.internal.override.version") == null;
    }

    @Override
    protected Document parse(InputStream is) throws Exception {
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        try {
            doc = builder.parse(is);
        }
        catch (Exception e) {
            if (this.configurationFile != null) {
                String msg = "Failed to parse " + this.configurationFile + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "Hazelcast startup interrupted.";
                LOGGER.severe(msg);
            } else if (this.configurationUrl != null) {
                String msg = "Failed to parse " + this.configurationUrl + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "Hazelcast startup interrupted.";
                LOGGER.severe(msg);
            } else {
                String msg = "Failed to parse the inputstream" + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "Hazelcast startup interrupted.";
                LOGGER.severe(msg);
            }
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        finally {
            IOUtil.closeResource(is);
        }
        return doc;
    }

    private void handleConfig(Element docElement) throws Exception {
        for (Node node : XmlConfigBuilder.childElements(docElement)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in XML configuration.");
            }
            if (this.handleXmlNode(node, nodeName) || XmlElements.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private boolean handleXmlNode(Node node, String nodeName) throws Exception {
        if (XmlElements.INSTANCE_NAME.isEqual(nodeName)) {
            this.handleInstanceName(node);
        } else if (XmlElements.NETWORK.isEqual(nodeName)) {
            this.handleNetwork(node);
        } else {
            if (XmlElements.IMPORT.isEqual(nodeName)) {
                throw new HazelcastException("Non-expanded <import> element found");
            }
            if (XmlElements.GROUP.isEqual(nodeName)) {
                this.handleGroup(node);
            } else if (XmlElements.PROPERTIES.isEqual(nodeName)) {
                this.fillProperties(node, this.config.getProperties());
            } else if (XmlElements.WAN_REPLICATION.isEqual(nodeName)) {
                this.handleWanReplication(node);
            } else if (XmlElements.EXECUTOR_SERVICE.isEqual(nodeName)) {
                this.handleExecutor(node);
            } else if (XmlElements.DURABLE_EXECUTOR_SERVICE.isEqual(nodeName)) {
                this.handleDurableExecutor(node);
            } else if (XmlElements.SCHEDULED_EXECUTOR_SERVICE.isEqual(nodeName)) {
                this.handleScheduledExecutor(node);
            } else if (XmlElements.EVENT_JOURNAL.isEqual(nodeName)) {
                this.handleEventJournal(node);
            } else if (XmlElements.MERKLE_TREE.isEqual(nodeName)) {
                this.handleMerkleTree(node);
            } else if (XmlElements.SERVICES.isEqual(nodeName)) {
                this.handleServices(node);
            } else if (XmlElements.QUEUE.isEqual(nodeName)) {
                this.handleQueue(node);
            } else if (XmlElements.MAP.isEqual(nodeName)) {
                this.handleMap(node);
            } else if (XmlElements.MULTIMAP.isEqual(nodeName)) {
                this.handleMultiMap(node);
            } else if (XmlElements.REPLICATED_MAP.isEqual(nodeName)) {
                this.handleReplicatedMap(node);
            } else if (XmlElements.LIST.isEqual(nodeName)) {
                this.handleList(node);
            } else if (XmlElements.SET.isEqual(nodeName)) {
                this.handleSet(node);
            } else if (XmlElements.TOPIC.isEqual(nodeName)) {
                this.handleTopic(node);
            } else if (XmlElements.RELIABLE_TOPIC.isEqual(nodeName)) {
                this.handleReliableTopic(node);
            } else if (XmlElements.CACHE.isEqual(nodeName)) {
                this.handleCache(node);
            } else if (XmlElements.NATIVE_MEMORY.isEqual(nodeName)) {
                this.fillNativeMemoryConfig(node, this.config.getNativeMemoryConfig());
            } else if (XmlElements.JOB_TRACKER.isEqual(nodeName)) {
                this.handleJobTracker(node);
            } else if (XmlElements.SEMAPHORE.isEqual(nodeName)) {
                this.handleSemaphore(node);
            } else if (XmlElements.LOCK.isEqual(nodeName)) {
                this.handleLock(node);
            } else if (XmlElements.RINGBUFFER.isEqual(nodeName)) {
                this.handleRingbuffer(node);
            } else if (XmlElements.ATOMIC_LONG.isEqual(nodeName)) {
                this.handleAtomicLong(node);
            } else if (XmlElements.ATOMIC_REFERENCE.isEqual(nodeName)) {
                this.handleAtomicReference(node);
            } else if (XmlElements.COUNT_DOWN_LATCH.isEqual(nodeName)) {
                this.handleCountDownLatchConfig(node);
            } else if (XmlElements.LISTENERS.isEqual(nodeName)) {
                this.handleListeners(node);
            } else if (XmlElements.PARTITION_GROUP.isEqual(nodeName)) {
                this.handlePartitionGroup(node);
            } else if (XmlElements.SERIALIZATION.isEqual(nodeName)) {
                this.handleSerialization(node);
            } else if (XmlElements.SECURITY.isEqual(nodeName)) {
                this.handleSecurity(node);
            } else if (XmlElements.MEMBER_ATTRIBUTES.isEqual(nodeName)) {
                this.handleMemberAttributes(node);
            } else if (XmlElements.LICENSE_KEY.isEqual(nodeName)) {
                this.config.setLicenseKey(this.getTextContent(node));
            } else if (XmlElements.MANAGEMENT_CENTER.isEqual(nodeName)) {
                this.handleManagementCenterConfig(node);
            } else if (XmlElements.QUORUM.isEqual(nodeName)) {
                this.handleQuorum(node);
            } else if (XmlElements.LITE_MEMBER.isEqual(nodeName)) {
                this.handleLiteMember(node);
            } else if (XmlElements.HOT_RESTART_PERSISTENCE.isEqual(nodeName)) {
                this.handleHotRestartPersistence(node);
            } else if (XmlElements.USER_CODE_DEPLOYMENT.isEqual(nodeName)) {
                this.handleUserCodeDeployment(node);
            } else if (XmlElements.CARDINALITY_ESTIMATOR.isEqual(nodeName)) {
                this.handleCardinalityEstimator(node);
            } else if (XmlElements.FLAKE_ID_GENERATOR.isEqual(nodeName)) {
                this.handleFlakeIdGenerator(node);
            } else if (XmlElements.CRDT_REPLICATION.isEqual(nodeName)) {
                this.handleCRDTReplication(node);
            } else if (XmlElements.PN_COUNTER.isEqual(nodeName)) {
                this.handlePNCounter(node);
            } else {
                return true;
            }
        }
        return false;
    }

    private void handleInstanceName(Node node) {
        String instanceName = this.getTextContent(node);
        if (instanceName.isEmpty()) {
            throw new InvalidConfigurationException("Instance name in XML configuration is empty");
        }
        this.config.setInstanceName(instanceName);
    }

    private void handleUserCodeDeployment(Node dcRoot) {
        UserCodeDeploymentConfig dcConfig = new UserCodeDeploymentConfig();
        Node attrEnabled = dcRoot.getAttributes().getNamedItem("enabled");
        boolean enabled = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrEnabled));
        dcConfig.setEnabled(enabled);
        String classCacheModeName = "class-cache-mode";
        String providerModeName = "provider-mode";
        String blacklistPrefixesName = "blacklist-prefixes";
        String whitelistPrefixesName = "whitelist-prefixes";
        String providerFilterName = "provider-filter";
        for (Node n : XmlConfigBuilder.childElements(dcRoot)) {
            String value;
            String name = XmlConfigBuilder.cleanNodeName(n);
            if (classCacheModeName.equals(name)) {
                value = this.getTextContent(n);
                UserCodeDeploymentConfig.ClassCacheMode classCacheMode = UserCodeDeploymentConfig.ClassCacheMode.valueOf(value);
                dcConfig.setClassCacheMode(classCacheMode);
                continue;
            }
            if (providerModeName.equals(name)) {
                value = this.getTextContent(n);
                UserCodeDeploymentConfig.ProviderMode providerMode = UserCodeDeploymentConfig.ProviderMode.valueOf(value);
                dcConfig.setProviderMode(providerMode);
                continue;
            }
            if (blacklistPrefixesName.equals(name)) {
                value = this.getTextContent(n);
                dcConfig.setBlacklistedPrefixes(value);
                continue;
            }
            if (whitelistPrefixesName.equals(name)) {
                value = this.getTextContent(n);
                dcConfig.setWhitelistedPrefixes(value);
                continue;
            }
            if (!providerFilterName.equals(name)) continue;
            value = this.getTextContent(n);
            dcConfig.setProviderFilter(value);
        }
        this.config.setUserCodeDeploymentConfig(dcConfig);
    }

    private void handleHotRestartPersistence(Node hrRoot) {
        HotRestartPersistenceConfig hrConfig = new HotRestartPersistenceConfig().setEnabled(XmlConfigBuilder.getBooleanValue(this.getAttribute(hrRoot, "enabled")));
        String parallelismName = "parallelism";
        String validationTimeoutName = "validation-timeout-seconds";
        String dataLoadTimeoutName = "data-load-timeout-seconds";
        String clusterDataRecoveryPolicyName = "cluster-data-recovery-policy";
        for (Node n : XmlConfigBuilder.childElements(hrRoot)) {
            String name = XmlConfigBuilder.cleanNodeName(n);
            if ("base-dir".equals(name)) {
                hrConfig.setBaseDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if ("backup-dir".equals(name)) {
                hrConfig.setBackupDir(new File(this.getTextContent(n)).getAbsoluteFile());
                continue;
            }
            if (parallelismName.equals(name)) {
                hrConfig.setParallelism(XmlConfigBuilder.getIntegerValue(parallelismName, this.getTextContent(n)));
                continue;
            }
            if (validationTimeoutName.equals(name)) {
                hrConfig.setValidationTimeoutSeconds(XmlConfigBuilder.getIntegerValue(validationTimeoutName, this.getTextContent(n)));
                continue;
            }
            if (dataLoadTimeoutName.equals(name)) {
                hrConfig.setDataLoadTimeoutSeconds(XmlConfigBuilder.getIntegerValue(dataLoadTimeoutName, this.getTextContent(n)));
                continue;
            }
            if (!clusterDataRecoveryPolicyName.equals(name)) continue;
            hrConfig.setClusterDataRecoveryPolicy(HotRestartClusterDataRecoveryPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n))));
        }
        this.config.setHotRestartPersistenceConfig(hrConfig);
    }

    private void handleCRDTReplication(Node root) {
        CRDTReplicationConfig replicationConfig = new CRDTReplicationConfig();
        String replicationPeriodMillisName = "replication-period-millis";
        String maxConcurrentReplicationTargetsName = "max-concurrent-replication-targets";
        for (Node n : XmlConfigBuilder.childElements(root)) {
            String name = XmlConfigBuilder.cleanNodeName(n);
            if ("replication-period-millis".equals(name)) {
                replicationConfig.setReplicationPeriodMillis(XmlConfigBuilder.getIntegerValue("replication-period-millis", this.getTextContent(n)));
                continue;
            }
            if (!"max-concurrent-replication-targets".equals(name)) continue;
            replicationConfig.setMaxConcurrentReplicationTargets(XmlConfigBuilder.getIntegerValue("max-concurrent-replication-targets", this.getTextContent(n)));
        }
        this.config.setCRDTReplicationConfig(replicationConfig);
    }

    private void handleLiteMember(Node node) {
        Node attrEnabled = node.getAttributes().getNamedItem("enabled");
        boolean liteMember = attrEnabled != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(attrEnabled));
        this.config.setLiteMember(liteMember);
    }

    private void handleQuorum(Node node) {
        QuorumConfig quorumConfig = new QuorumConfig();
        String name = this.getAttribute(node, "name");
        quorumConfig.setName(name);
        Node attrEnabled = node.getAttributes().getNamedItem("enabled");
        boolean enabled = attrEnabled != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(attrEnabled));
        QuorumConfigBuilder quorumConfigBuilder = null;
        quorumConfig.setEnabled(enabled);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String value = this.getTextContent(n).trim();
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("quorum-size".equals(nodeName)) {
                quorumConfig.setSize(XmlConfigBuilder.getIntegerValue("quorum-size", value));
                continue;
            }
            if ("quorum-listeners".equals(nodeName)) {
                for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                    if (!"quorum-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                    String listenerClass = this.getTextContent(listenerNode);
                    quorumConfig.addListenerConfig(new QuorumListenerConfig(listenerClass));
                }
                continue;
            }
            if ("quorum-type".equals(nodeName)) {
                quorumConfig.setType(QuorumType.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("quorum-function-class-name".equals(nodeName)) {
                quorumConfig.setQuorumFunctionClassName(value);
                continue;
            }
            if ("recently-active-quorum".equals(nodeName)) {
                quorumConfigBuilder = this.handleRecentlyActiveQuorum(name, n, quorumConfig.getSize());
                continue;
            }
            if (!"probabilistic-quorum".equals(nodeName)) continue;
            quorumConfigBuilder = this.handleProbabilisticQuorum(name, n, quorumConfig.getSize());
        }
        if (quorumConfigBuilder != null) {
            boolean quorumFunctionDefinedByClassName;
            boolean bl = quorumFunctionDefinedByClassName = !StringUtil.isNullOrEmpty(quorumConfig.getQuorumFunctionClassName());
            if (quorumFunctionDefinedByClassName) {
                throw new ConfigurationException("A quorum cannot simultaneously define probabilistic-quorum or recently-active-quorum and a quorum function class name.");
            }
            QuorumConfig constructedConfig = quorumConfigBuilder.build();
            constructedConfig.setSize(quorumConfig.getSize());
            constructedConfig.setType(quorumConfig.getType());
            constructedConfig.setListenerConfigs(quorumConfig.getListenerConfigs());
            quorumConfig = constructedConfig;
        }
        this.config.addQuorumConfig(quorumConfig);
    }

    private QuorumConfigBuilder handleRecentlyActiveQuorum(String name, Node node, int quorumSize) {
        int heartbeatToleranceMillis = XmlConfigBuilder.getIntegerValue("heartbeat-tolerance-millis", this.getAttribute(node, "heartbeat-tolerance-millis"), RecentlyActiveQuorumConfigBuilder.DEFAULT_HEARTBEAT_TOLERANCE_MILLIS);
        RecentlyActiveQuorumConfigBuilder quorumConfigBuilder = QuorumConfig.newRecentlyActiveQuorumConfigBuilder(name, quorumSize, heartbeatToleranceMillis);
        return quorumConfigBuilder;
    }

    private QuorumConfigBuilder handleProbabilisticQuorum(String name, Node node, int quorumSize) {
        long acceptableHeartPause = XmlConfigBuilder.getLongValue("acceptable-heartbeat-pause-millis", this.getAttribute(node, "acceptable-heartbeat-pause-millis"), ProbabilisticQuorumConfigBuilder.DEFAULT_HEARTBEAT_PAUSE_MILLIS);
        double threshold = XmlConfigBuilder.getDoubleValue("suspicion-threshold", this.getAttribute(node, "suspicion-threshold"), ProbabilisticQuorumConfigBuilder.DEFAULT_PHI_THRESHOLD);
        int maxSampleSize = XmlConfigBuilder.getIntegerValue("max-sample-size", this.getAttribute(node, "max-sample-size"), ProbabilisticQuorumConfigBuilder.DEFAULT_SAMPLE_SIZE);
        long minStdDeviation = XmlConfigBuilder.getLongValue("min-std-deviation-millis", this.getAttribute(node, "min-std-deviation-millis"), ProbabilisticQuorumConfigBuilder.DEFAULT_MIN_STD_DEVIATION);
        long heartbeatIntervalMillis = XmlConfigBuilder.getLongValue("heartbeat-interval-millis", this.getAttribute(node, "heartbeat-interval-millis"), ProbabilisticQuorumConfigBuilder.DEFAULT_HEARTBEAT_INTERVAL_MILLIS);
        ProbabilisticQuorumConfigBuilder quorumConfigBuilder = QuorumConfig.newProbabilisticQuorumConfigBuilder(name, quorumSize).withAcceptableHeartbeatPauseMillis(acceptableHeartPause).withSuspicionThreshold(threshold).withHeartbeatIntervalMillis(heartbeatIntervalMillis).withMinStdDeviationMillis(minStdDeviation).withMaxSampleSize(maxSampleSize);
        return quorumConfigBuilder;
    }

    private void handleServices(Node node) {
        Node attDefaults = node.getAttributes().getNamedItem("enable-defaults");
        boolean enableDefaults = attDefaults == null || XmlConfigBuilder.getBooleanValue(this.getTextContent(attDefaults));
        ServicesConfig servicesConfig = this.config.getServicesConfig();
        servicesConfig.setEnableDefaults(enableDefaults);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"service".equals(nodeName)) continue;
            ServiceConfig serviceConfig = new ServiceConfig();
            String enabledValue = this.getAttribute(child, "enabled");
            boolean enabled = XmlConfigBuilder.getBooleanValue(enabledValue);
            serviceConfig.setEnabled(enabled);
            for (Node n : XmlConfigBuilder.childElements(child)) {
                String value = XmlConfigBuilder.cleanNodeName(n);
                if ("name".equals(value)) {
                    String name = this.getTextContent(n);
                    serviceConfig.setName(name);
                    continue;
                }
                if ("class-name".equals(value)) {
                    String className = this.getTextContent(n);
                    serviceConfig.setClassName(className);
                    continue;
                }
                if ("properties".equals(value)) {
                    this.fillProperties(n, serviceConfig.getProperties());
                    continue;
                }
                if (!"configuration".equals(value)) continue;
                Node parserNode = n.getAttributes().getNamedItem("parser");
                String parserClass = this.getTextContent(parserNode);
                if (parserNode == null || parserClass == null) {
                    throw new InvalidConfigurationException("Parser is required!");
                }
                try {
                    ServiceConfigurationParser parser = (ServiceConfigurationParser)ClassLoaderUtil.newInstance(this.config.getClassLoader(), parserClass);
                    Object obj = parser.parse((Element)n);
                    serviceConfig.setConfigObject(obj);
                }
                catch (Exception e) {
                    ExceptionUtil.sneakyThrow(e);
                }
            }
            servicesConfig.addServiceConfig(serviceConfig);
        }
    }

    private void handleWanReplication(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        WanReplicationConfig wanReplicationConfig = new WanReplicationConfig();
        wanReplicationConfig.setName(name);
        for (Node nodeTarget : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(nodeTarget);
            if ("wan-publisher".equals(nodeName)) {
                WanPublisherConfig publisherConfig = new WanPublisherConfig();
                publisherConfig.setGroupName(this.getAttribute(nodeTarget, "group-name"));
                for (Node targetChild : XmlConfigBuilder.childElements(nodeTarget)) {
                    this.handleWanPublisherConfig(publisherConfig, targetChild);
                }
                wanReplicationConfig.addWanPublisherConfig(publisherConfig);
                continue;
            }
            if (!"wan-consumer".equals(nodeName)) continue;
            WanConsumerConfig consumerConfig = new WanConsumerConfig();
            for (Node targetChild : XmlConfigBuilder.childElements(nodeTarget)) {
                this.handleWanConsumerConfig(consumerConfig, targetChild);
            }
            wanReplicationConfig.setWanConsumerConfig(consumerConfig);
        }
        this.config.addWanReplicationConfig(wanReplicationConfig);
    }

    private void handleWanPublisherConfig(WanPublisherConfig publisherConfig, Node targetChild) {
        String targetChildName = XmlConfigBuilder.cleanNodeName(targetChild);
        if ("class-name".equals(targetChildName)) {
            publisherConfig.setClassName(this.getTextContent(targetChild));
        } else if ("queue-full-behavior".equals(targetChildName)) {
            String queueFullBehavior = this.getTextContent(targetChild);
            publisherConfig.setQueueFullBehavior(WANQueueFullBehavior.valueOf(StringUtil.upperCaseInternal(queueFullBehavior)));
        } else if ("initial-publisher-state".equals(targetChildName)) {
            String initialPublisherState = this.getTextContent(targetChild);
            publisherConfig.setInitialPublisherState(WanPublisherState.valueOf(StringUtil.upperCaseInternal(initialPublisherState)));
        } else if ("queue-capacity".equals(targetChildName)) {
            int queueCapacity = XmlConfigBuilder.getIntegerValue("queue-capacity", this.getTextContent(targetChild));
            publisherConfig.setQueueCapacity(queueCapacity);
        } else if ("properties".equals(targetChildName)) {
            this.fillProperties(targetChild, publisherConfig.getProperties());
        } else if ("aws".equals(targetChildName)) {
            this.handleAWS(publisherConfig.getAwsConfig(), targetChild);
        } else if ("discovery-strategies".equals(targetChildName)) {
            this.handleDiscoveryStrategies(publisherConfig.getDiscoveryConfig(), targetChild);
        } else if ("wan-sync".equals(targetChildName)) {
            this.handleWanSync(publisherConfig.getWanSyncConfig(), targetChild);
        }
    }

    private void handleWanSync(WanSyncConfig wanSyncConfig, Node node) {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"consistency-check-strategy".equals(nodeName)) continue;
            String strategy = this.getTextContent(child);
            wanSyncConfig.setConsistencyCheckStrategy(ConsistencyCheckStrategy.valueOf(StringUtil.upperCaseInternal(strategy)));
        }
    }

    private void handleWanConsumerConfig(WanConsumerConfig consumerConfig, Node targetChild) {
        String targetChildName = XmlConfigBuilder.cleanNodeName(targetChild);
        if ("class-name".equals(targetChildName)) {
            consumerConfig.setClassName(this.getTextContent(targetChild));
        } else if ("properties".equals(targetChildName)) {
            this.fillProperties(targetChild, consumerConfig.getProperties());
        } else if ("persist-wan-replicated-data".equals(targetChildName)) {
            consumerConfig.setPersistWanReplicatedData(XmlConfigBuilder.getBooleanValue(this.getTextContent(targetChild)));
        }
    }

    private void handleNetwork(Node node) throws Exception {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if ("reuse-address".equals(nodeName)) {
                String value = this.getTextContent(child).trim();
                this.config.getNetworkConfig().setReuseAddress(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("port".equals(nodeName)) {
                this.handlePort(child);
                continue;
            }
            if ("outbound-ports".equals(nodeName)) {
                this.handleOutboundPorts(child);
                continue;
            }
            if ("public-address".equals(nodeName)) {
                String address = this.getTextContent(child);
                this.config.getNetworkConfig().setPublicAddress(address);
                continue;
            }
            if ("join".equals(nodeName)) {
                this.handleJoin(child);
                continue;
            }
            if ("interfaces".equals(nodeName)) {
                this.handleInterfaces(child);
                continue;
            }
            if ("symmetric-encryption".equals(nodeName)) {
                this.handleViaReflection(child, this.config.getNetworkConfig(), new SymmetricEncryptionConfig());
                continue;
            }
            if ("ssl".equals(nodeName)) {
                this.handleSSLConfig(child);
                continue;
            }
            if ("socket-interceptor".equals(nodeName)) {
                this.handleSocketInterceptorConfig(child);
                continue;
            }
            if ("member-address-provider".equals(nodeName)) {
                this.handleMemberAddressProvider(child);
                continue;
            }
            if (!"failure-detector".equals(nodeName)) continue;
            this.handleFailureDetector(child);
        }
    }

    private void handleExecutor(Node node) throws Exception {
        ExecutorConfig executorConfig = new ExecutorConfig();
        this.handleViaReflection(node, this.config, executorConfig);
    }

    private void handleDurableExecutor(Node node) throws Exception {
        DurableExecutorConfig durableExecutorConfig = new DurableExecutorConfig();
        this.handleViaReflection(node, this.config, durableExecutorConfig);
    }

    private void handleScheduledExecutor(Node node) {
        ScheduledExecutorConfig scheduledExecutorConfig = new ScheduledExecutorConfig();
        scheduledExecutorConfig.setName(this.getTextContent(node.getAttributes().getNamedItem("name")));
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if ("merge-policy".equals(nodeName)) {
                scheduledExecutorConfig.setMergePolicyConfig(this.createMergePolicyConfig(child));
                continue;
            }
            if ("capacity".equals(nodeName)) {
                scheduledExecutorConfig.setCapacity(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("durability".equals(nodeName)) {
                scheduledExecutorConfig.setDurability(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("pool-size".equals(nodeName)) {
                scheduledExecutorConfig.setPoolSize(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"quorum-ref".equals(nodeName)) continue;
            scheduledExecutorConfig.setQuorumName(this.getTextContent(child));
        }
        this.config.addScheduledExecutorConfig(scheduledExecutorConfig);
    }

    private void handleCardinalityEstimator(Node node) {
        CardinalityEstimatorConfig cardinalityEstimatorConfig = new CardinalityEstimatorConfig();
        cardinalityEstimatorConfig.setName(this.getTextContent(node.getAttributes().getNamedItem("name")));
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if ("merge-policy".equals(nodeName)) {
                MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(child);
                cardinalityEstimatorConfig.setMergePolicyConfig(mergePolicyConfig);
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                cardinalityEstimatorConfig.setBackupCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                cardinalityEstimatorConfig.setAsyncBackupCount(Integer.parseInt(this.getTextContent(child)));
                continue;
            }
            if (!"quorum-ref".equals(nodeName)) continue;
            cardinalityEstimatorConfig.setQuorumName(this.getTextContent(child));
        }
        this.config.addCardinalityEstimatorConfig(cardinalityEstimatorConfig);
    }

    private void handlePNCounter(Node node) throws Exception {
        PNCounterConfig pnCounterConfig = new PNCounterConfig();
        this.handleViaReflection(node, this.config, pnCounterConfig);
    }

    private void handleFlakeIdGenerator(Node node) {
        String name = this.getAttribute(node, "name");
        FlakeIdGeneratorConfig generatorConfig = new FlakeIdGeneratorConfig(name);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if ("prefetch-count".equals(nodeName)) {
                generatorConfig.setPrefetchCount(Integer.parseInt(value));
                continue;
            }
            if ("prefetch-validity-millis".equalsIgnoreCase(nodeName)) {
                generatorConfig.setPrefetchValidityMillis(Long.parseLong(value));
                continue;
            }
            if ("id-offset".equalsIgnoreCase(nodeName)) {
                generatorConfig.setIdOffset(Long.parseLong(value));
                continue;
            }
            if ("node-id-offset".equalsIgnoreCase(nodeName)) {
                generatorConfig.setNodeIdOffset(Long.parseLong(value));
                continue;
            }
            if (!"statistics-enabled".equals(nodeName)) continue;
            generatorConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
        }
        this.config.addFlakeIdGeneratorConfig(generatorConfig);
    }

    private void handleGroup(Node node) {
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String value = this.getTextContent(n).trim();
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("name".equals(nodeName)) {
                this.config.getGroupConfig().setName(value);
                continue;
            }
            if (!"password".equals(nodeName)) continue;
            this.config.getGroupConfig().setPassword(value);
        }
    }

    private void handleInterfaces(Node node) {
        String value;
        NamedNodeMap attributes = node.getAttributes();
        InterfacesConfig interfaces = this.config.getNetworkConfig().getInterfaces();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            if (!"enabled".equals(att.getNodeName())) continue;
            value = att.getNodeValue();
            interfaces.setEnabled(XmlConfigBuilder.getBooleanValue(value));
        }
        for (Node n : XmlConfigBuilder.childElements(node)) {
            if (!"interface".equals(StringUtil.lowerCaseInternal(XmlConfigBuilder.cleanNodeName(n)))) continue;
            value = this.getTextContent(n).trim();
            interfaces.addInterface(value);
        }
    }

    private void handleViaReflection(Node node, Object parent, Object child) throws Exception {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int a = 0; a < attributes.getLength(); ++a) {
                Node att = attributes.item(a);
                XmlConfigBuilder.invokeSetter(child, att, att.getNodeValue());
            }
        }
        for (Node n : XmlConfigBuilder.childElements(node)) {
            if (!(n instanceof Element)) continue;
            XmlConfigBuilder.invokeSetter(child, n, this.getTextContent(n).trim());
        }
        XmlConfigBuilder.attachChildConfig(parent, child);
    }

    private static void invokeSetter(Object target, Node node, String argument) {
        String coercedArg;
        Method method = XmlConfigBuilder.getMethod(target, "set" + XmlConfigBuilder.toPropertyName(XmlConfigBuilder.cleanNodeName(node)), true);
        if (method == null) {
            throw new InvalidConfigurationException("Invalid element/attribute name in XML configuration: " + node);
        }
        Class<?> arg = method.getParameterTypes()[0];
        Object object = arg == String.class ? argument : (arg == Integer.TYPE ? Integer.valueOf(argument) : (arg == Long.TYPE ? Long.valueOf(argument) : (coercedArg = arg == Boolean.TYPE ? Boolean.valueOf(XmlConfigBuilder.getBooleanValue(argument)) : null)));
        if (coercedArg == null) {
            throw new HazelcastException(String.format("Method %s has unsupported argument type %s", method.getName(), arg.getSimpleName()));
        }
        try {
            method.invoke(target, coercedArg);
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    private static void attachChildConfig(Object parent, Object child) throws Exception {
        String targetName = child.getClass().getSimpleName();
        Method attacher = XmlConfigBuilder.getMethod(parent, "set" + targetName, false);
        if (attacher == null) {
            attacher = XmlConfigBuilder.getMethod(parent, "add" + targetName, false);
        }
        if (attacher == null) {
            throw new HazelcastException(String.format("%s doesn't accept %s as child", parent.getClass().getSimpleName(), targetName));
        }
        attacher.invoke(parent, child);
    }

    private static Method getMethod(Object target, String methodName, boolean requiresArg) {
        Method[] methods;
        for (Method method : methods = target.getClass().getMethods()) {
            Class<?> arg;
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            if (!requiresArg) {
                return method;
            }
            Class<?>[] args = method.getParameterTypes();
            if (args.length != 1 || (arg = method.getParameterTypes()[0]) != String.class && arg != Integer.TYPE && arg != Long.TYPE && arg != Boolean.TYPE) continue;
            return method;
        }
        return null;
    }

    private static String toPropertyName(String element) {
        String refPropertyName = XmlConfigBuilder.handleRefProperty(element);
        if (refPropertyName != null) {
            return refPropertyName;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = element.toCharArray();
        boolean upper = true;
        for (char c : chars) {
            if (c == '_' || c == '-' || c == '.') {
                upper = true;
                continue;
            }
            if (upper) {
                sb.append(Character.toUpperCase(c));
                upper = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String handleRefProperty(String element) {
        if (element.equals("quorum-ref")) {
            return "QuorumName";
        }
        return null;
    }

    private void handleJoin(Node node) {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String name = XmlConfigBuilder.cleanNodeName(child);
            if ("multicast".equals(name)) {
                this.handleMulticast(child);
                continue;
            }
            if ("tcp-ip".equals(name)) {
                this.handleTcpIp(child);
                continue;
            }
            if ("aws".equals(name)) {
                this.handleAWS(this.config.getNetworkConfig().getJoin().getAwsConfig(), child);
                continue;
            }
            if (!"discovery-strategies".equals(name)) continue;
            this.handleDiscoveryStrategies(this.config.getNetworkConfig().getJoin().getDiscoveryConfig(), child);
        }
        JoinConfig joinConfig = this.config.getNetworkConfig().getJoin();
        joinConfig.verify();
    }

    private void handleDiscoveryStrategies(DiscoveryConfig discoveryConfig, Node node) {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String name = XmlConfigBuilder.cleanNodeName(child);
            if ("discovery-strategy".equals(name)) {
                this.handleDiscoveryStrategy(child, discoveryConfig);
                continue;
            }
            if (!"node-filter".equals(name)) continue;
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    private void handleDiscoveryNodeFilter(Node node, DiscoveryConfig discoveryConfig) {
        NamedNodeMap attributes = node.getAttributes();
        Node att = attributes.getNamedItem("class");
        if (att != null) {
            discoveryConfig.setNodeFilterClass(this.getTextContent(att).trim());
        }
    }

    private void handleDiscoveryStrategy(Node node, DiscoveryConfig discoveryConfig) {
        boolean enabled = false;
        String clazz = null;
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            String value = this.getTextContent(att).trim();
            if ("enabled".equals(StringUtil.lowerCaseInternal(att.getNodeName()))) {
                enabled = XmlConfigBuilder.getBooleanValue(value);
                continue;
            }
            if (!"class".equals(att.getNodeName())) continue;
            clazz = value;
        }
        if (!enabled || clazz == null) {
            return;
        }
        HashMap<String, Comparable> properties = new HashMap<String, Comparable>();
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String name = XmlConfigBuilder.cleanNodeName(child);
            if (!"properties".equals(name)) continue;
            this.fillProperties(child, properties);
        }
        discoveryConfig.addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(clazz, properties));
    }

    private void handleAWS(AwsConfig awsConfig, Node node) {
        String value;
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            value = this.getTextContent(att).trim();
            if ("enabled".equals(StringUtil.lowerCaseInternal(att.getNodeName()))) {
                awsConfig.setEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if (!att.getNodeName().equals("connection-timeout-seconds")) continue;
            awsConfig.setConnectionTimeoutSeconds(XmlConfigBuilder.getIntegerValue("connection-timeout-seconds", value));
        }
        for (Node n : XmlConfigBuilder.childElements(node)) {
            value = this.getTextContent(n).trim();
            if ("secret-key".equals(XmlConfigBuilder.cleanNodeName(n))) {
                awsConfig.setSecretKey(value);
                continue;
            }
            if ("access-key".equals(XmlConfigBuilder.cleanNodeName(n))) {
                awsConfig.setAccessKey(value);
                continue;
            }
            if ("region".equals(XmlConfigBuilder.cleanNodeName(n))) {
                awsConfig.setRegion(value);
                continue;
            }
            if ("host-header".equals(XmlConfigBuilder.cleanNodeName(n))) {
                awsConfig.setHostHeader(value);
                continue;
            }
            if ("security-group-name".equals(XmlConfigBuilder.cleanNodeName(n))) {
                awsConfig.setSecurityGroupName(value);
                continue;
            }
            if ("tag-key".equals(XmlConfigBuilder.cleanNodeName(n))) {
                awsConfig.setTagKey(value);
                continue;
            }
            if ("tag-value".equals(XmlConfigBuilder.cleanNodeName(n))) {
                awsConfig.setTagValue(value);
                continue;
            }
            if (!"iam-role".equals(XmlConfigBuilder.cleanNodeName(n))) continue;
            awsConfig.setIamRole(value);
        }
    }

    private void handleMulticast(Node node) {
        String value;
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        MulticastConfig multicastConfig = join.getMulticastConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            value = this.getTextContent(att).trim();
            if ("enabled".equals(StringUtil.lowerCaseInternal(att.getNodeName()))) {
                multicastConfig.setEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if (!"loopbackmodeenabled".equals(StringUtil.lowerCaseInternal(att.getNodeName()))) continue;
            multicastConfig.setLoopbackModeEnabled(XmlConfigBuilder.getBooleanValue(value));
        }
        for (Node n : XmlConfigBuilder.childElements(node)) {
            value = this.getTextContent(n).trim();
            if ("multicast-group".equals(XmlConfigBuilder.cleanNodeName(n))) {
                multicastConfig.setMulticastGroup(value);
                continue;
            }
            if ("multicast-port".equals(XmlConfigBuilder.cleanNodeName(n))) {
                multicastConfig.setMulticastPort(Integer.parseInt(value));
                continue;
            }
            if ("multicast-timeout-seconds".equals(XmlConfigBuilder.cleanNodeName(n))) {
                multicastConfig.setMulticastTimeoutSeconds(Integer.parseInt(value));
                continue;
            }
            if ("multicast-time-to-live-seconds".equals(XmlConfigBuilder.cleanNodeName(n))) {
                multicastConfig.setMulticastTimeToLive(Integer.parseInt(value));
                continue;
            }
            if ("multicast-time-to-live".equals(XmlConfigBuilder.cleanNodeName(n))) {
                multicastConfig.setMulticastTimeToLive(Integer.parseInt(value));
                continue;
            }
            if (!"trusted-interfaces".equals(XmlConfigBuilder.cleanNodeName(n))) continue;
            for (Node child : XmlConfigBuilder.childElements(n)) {
                if (!"interface".equals(StringUtil.lowerCaseInternal(XmlConfigBuilder.cleanNodeName(child)))) continue;
                multicastConfig.addTrustedInterface(this.getTextContent(child).trim());
            }
        }
    }

    private void handleTcpIp(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        TcpIpConfig tcpIpConfig = join.getTcpIpConfig();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            String value = this.getTextContent(att).trim();
            if (att.getNodeName().equals("enabled")) {
                tcpIpConfig.setEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if (!att.getNodeName().equals("connection-timeout-seconds")) continue;
            tcpIpConfig.setConnectionTimeoutSeconds(XmlConfigBuilder.getIntegerValue("connection-timeout-seconds", value));
        }
        HashSet<String> memberTags = new HashSet<String>(Arrays.asList("interface", "member", "members"));
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String value = this.getTextContent(n).trim();
            if (XmlConfigBuilder.cleanNodeName(n).equals("member-list")) {
                this.handleMemberList(n);
                continue;
            }
            if (XmlConfigBuilder.cleanNodeName(n).equals("required-member")) {
                if (tcpIpConfig.getRequiredMember() != null) {
                    throw new InvalidConfigurationException("Duplicate required-member definition found in XML configuration. ");
                }
                tcpIpConfig.setRequiredMember(value);
                continue;
            }
            if (!memberTags.contains(XmlConfigBuilder.cleanNodeName(n))) continue;
            tcpIpConfig.addMember(value);
        }
    }

    private void handleMemberList(Node node) {
        JoinConfig join = this.config.getNetworkConfig().getJoin();
        TcpIpConfig tcpIpConfig = join.getTcpIpConfig();
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if (!"member".equals(nodeName)) continue;
            String value = this.getTextContent(n).trim();
            tcpIpConfig.addMember(value);
        }
    }

    private void handlePort(Node node) {
        String portStr = this.getTextContent(node).trim();
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        if (portStr.length() > 0) {
            networkConfig.setPort(Integer.parseInt(portStr));
        }
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            String value = this.getTextContent(att).trim();
            if ("auto-increment".equals(att.getNodeName())) {
                networkConfig.setPortAutoIncrement(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if (!"port-count".equals(att.getNodeName())) continue;
            int portCount = Integer.parseInt(value);
            networkConfig.setPortCount(portCount);
        }
    }

    private void handleOutboundPorts(Node child) {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        for (Node n : XmlConfigBuilder.childElements(child)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if (!"ports".equals(nodeName)) continue;
            String value = this.getTextContent(n);
            networkConfig.addOutboundPortDefinition(value);
        }
    }

    private void handleLock(Node node) {
        String name = this.getAttribute(node, "name");
        LockConfig lockConfig = new LockConfig();
        lockConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if (!"quorum-ref".equals(nodeName)) continue;
            lockConfig.setQuorumName(value);
        }
        this.config.addLockConfig(lockConfig);
    }

    private void handleQueue(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        QueueConfig qConfig = new QueueConfig();
        qConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("max-size".equals(nodeName)) {
                qConfig.setMaxSize(XmlConfigBuilder.getIntegerValue("max-size", value));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                qConfig.setBackupCount(XmlConfigBuilder.getIntegerValue("backup-count", value));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                qConfig.setAsyncBackupCount(XmlConfigBuilder.getIntegerValue("async-backup-count", value));
                continue;
            }
            if ("item-listeners".equals(nodeName)) {
                for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                    if (!"item-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("include-value")));
                    String listenerClass = this.getTextContent(listenerNode);
                    qConfig.addItemListenerConfig(new ItemListenerConfig(listenerClass, incValue));
                }
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                qConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("queue-store".equals(nodeName)) {
                QueueStoreConfig queueStoreConfig = this.createQueueStoreConfig(n);
                qConfig.setQueueStoreConfig(queueStoreConfig);
                continue;
            }
            if ("quorum-ref".equals(nodeName)) {
                qConfig.setQuorumName(value);
                continue;
            }
            if ("empty-queue-ttl".equals(nodeName)) {
                qConfig.setEmptyQueueTtl(XmlConfigBuilder.getIntegerValue("empty-queue-ttl", value));
                continue;
            }
            if (!"merge-policy".equals(nodeName)) continue;
            MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
            qConfig.setMergePolicyConfig(mergePolicyConfig);
        }
        this.config.addQueueConfig(qConfig);
    }

    private void handleList(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        ListConfig lConfig = new ListConfig();
        lConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("max-size".equals(nodeName)) {
                lConfig.setMaxSize(XmlConfigBuilder.getIntegerValue("max-size", value));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                lConfig.setBackupCount(XmlConfigBuilder.getIntegerValue("backup-count", value));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                lConfig.setAsyncBackupCount(XmlConfigBuilder.getIntegerValue("async-backup-count", value));
                continue;
            }
            if ("item-listeners".equals(nodeName)) {
                for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                    if (!"item-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("include-value")));
                    String listenerClass = this.getTextContent(listenerNode);
                    lConfig.addItemListenerConfig(new ItemListenerConfig(listenerClass, incValue));
                }
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                lConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("quorum-ref".equals(nodeName)) {
                lConfig.setQuorumName(value);
                continue;
            }
            if (!"merge-policy".equals(nodeName)) continue;
            MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
            lConfig.setMergePolicyConfig(mergePolicyConfig);
        }
        this.config.addListConfig(lConfig);
    }

    private void handleSet(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        SetConfig sConfig = new SetConfig();
        sConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("max-size".equals(nodeName)) {
                sConfig.setMaxSize(XmlConfigBuilder.getIntegerValue("max-size", value));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                sConfig.setBackupCount(XmlConfigBuilder.getIntegerValue("backup-count", value));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                sConfig.setAsyncBackupCount(XmlConfigBuilder.getIntegerValue("async-backup-count", value));
                continue;
            }
            if ("item-listeners".equals(nodeName)) {
                for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                    if (!"item-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("include-value")));
                    String listenerClass = this.getTextContent(listenerNode);
                    sConfig.addItemListenerConfig(new ItemListenerConfig(listenerClass, incValue));
                }
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                sConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("quorum-ref".equals(nodeName)) {
                sConfig.setQuorumName(value);
                continue;
            }
            if (!"merge-policy".equals(nodeName)) continue;
            MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
            sConfig.setMergePolicyConfig(mergePolicyConfig);
        }
        this.config.addSetConfig(sConfig);
    }

    private void handleMultiMap(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        MultiMapConfig multiMapConfig = new MultiMapConfig();
        multiMapConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("value-collection-type".equals(nodeName)) {
                multiMapConfig.setValueCollectionType(value);
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                multiMapConfig.setBackupCount(XmlConfigBuilder.getIntegerValue("backup-count", value));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                multiMapConfig.setAsyncBackupCount(XmlConfigBuilder.getIntegerValue("async-backup-count", value));
                continue;
            }
            if ("entry-listeners".equals(nodeName)) {
                for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                    if (!"entry-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("include-value")));
                    boolean local = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("local")));
                    String listenerClass = this.getTextContent(listenerNode);
                    multiMapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
                }
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                multiMapConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("binary".equals(nodeName)) {
                multiMapConfig.setBinary(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("quorum-ref".equals(nodeName)) {
                multiMapConfig.setQuorumName(value);
                continue;
            }
            if (!"merge-policy".equals(nodeName)) continue;
            MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
            multiMapConfig.setMergePolicyConfig(mergePolicyConfig);
        }
        this.config.addMultiMapConfig(multiMapConfig);
    }

    private void handleReplicatedMap(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        ReplicatedMapConfig replicatedMapConfig = new ReplicatedMapConfig();
        replicatedMapConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("concurrency-level".equals(nodeName)) {
                replicatedMapConfig.setConcurrencyLevel(XmlConfigBuilder.getIntegerValue("concurrency-level", value));
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                replicatedMapConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("replication-delay-millis".equals(nodeName)) {
                replicatedMapConfig.setReplicationDelayMillis(XmlConfigBuilder.getIntegerValue("replication-delay-millis", value));
                continue;
            }
            if ("async-fillup".equals(nodeName)) {
                replicatedMapConfig.setAsyncFillup(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                replicatedMapConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("entry-listeners".equals(nodeName)) {
                for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                    if (!"entry-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                    NamedNodeMap attrs = listenerNode.getAttributes();
                    boolean incValue = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("include-value")));
                    boolean local = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("local")));
                    String listenerClass = this.getTextContent(listenerNode);
                    replicatedMapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
                }
                continue;
            }
            if ("merge-policy".equals(nodeName)) {
                MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
                replicatedMapConfig.setMergePolicyConfig(mergePolicyConfig);
                continue;
            }
            if (!"quorum-ref".equals(nodeName)) continue;
            replicatedMapConfig.setQuorumName(value);
        }
        this.config.addReplicatedMapConfig(replicatedMapConfig);
    }

    private void handleMap(Node parentNode) {
        String name = this.getAttribute(parentNode, "name");
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName(name);
        for (Node node : XmlConfigBuilder.childElements(parentNode)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(node);
            String value = this.getTextContent(node).trim();
            if ("backup-count".equals(nodeName)) {
                mapConfig.setBackupCount(XmlConfigBuilder.getIntegerValue("backup-count", value));
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                mapConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                mapConfig.setAsyncBackupCount(XmlConfigBuilder.getIntegerValue("async-backup-count", value));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                if (mapConfig.getMapEvictionPolicy() != null) continue;
                mapConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("max-size".equals(nodeName)) {
                MaxSizeConfig msc = mapConfig.getMaxSizeConfig();
                Node maxSizePolicy = node.getAttributes().getNamedItem("policy");
                if (maxSizePolicy != null) {
                    msc.setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
                }
                msc.setSize(XmlConfigBuilder.getIntegerValue("max-size", value));
                continue;
            }
            if ("eviction-percentage".equals(nodeName)) {
                mapConfig.setEvictionPercentage(XmlConfigBuilder.getIntegerValue("eviction-percentage", value));
                continue;
            }
            if ("min-eviction-check-millis".equals(nodeName)) {
                mapConfig.setMinEvictionCheckMillis(XmlConfigBuilder.getLongValue("min-eviction-check-millis", value));
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                mapConfig.setTimeToLiveSeconds(XmlConfigBuilder.getIntegerValue("time-to-live-seconds", value));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                mapConfig.setMaxIdleSeconds(XmlConfigBuilder.getIntegerValue("max-idle-seconds", value));
                continue;
            }
            if ("map-store".equals(nodeName)) {
                MapStoreConfig mapStoreConfig = this.createMapStoreConfig(node);
                mapConfig.setMapStoreConfig(mapStoreConfig);
                continue;
            }
            if ("near-cache".equals(nodeName)) {
                mapConfig.setNearCacheConfig(this.handleNearCacheConfig(node));
                continue;
            }
            if ("merge-policy".equals(nodeName)) {
                MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(node);
                mapConfig.setMergePolicyConfig(mergePolicyConfig);
                continue;
            }
            if ("hot-restart".equals(nodeName)) {
                mapConfig.setHotRestartConfig(this.createHotRestartConfig(node));
                continue;
            }
            if ("read-backup-data".equals(nodeName)) {
                mapConfig.setReadBackupData(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                mapConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("optimize-queries".equals(nodeName)) {
                mapConfig.setOptimizeQueries(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("cache-deserialized-values".equals(nodeName)) {
                CacheDeserializedValues cacheDeserializedValues = CacheDeserializedValues.parseString(value);
                mapConfig.setCacheDeserializedValues(cacheDeserializedValues);
                continue;
            }
            if ("wan-replication-ref".equals(nodeName)) {
                this.mapWanReplicationRefHandle(node, mapConfig);
                continue;
            }
            if ("indexes".equals(nodeName)) {
                this.mapIndexesHandle(node, mapConfig);
                continue;
            }
            if ("attributes".equals(nodeName)) {
                this.mapAttributesHandle(node, mapConfig);
                continue;
            }
            if ("entry-listeners".equals(nodeName)) {
                this.mapEntryListenerHandle(node, mapConfig);
                continue;
            }
            if ("partition-lost-listeners".equals(nodeName)) {
                this.mapPartitionLostListenerHandle(node, mapConfig);
                continue;
            }
            if ("partition-strategy".equals(nodeName)) {
                mapConfig.setPartitioningStrategyConfig(new PartitioningStrategyConfig(value));
                continue;
            }
            if ("quorum-ref".equals(nodeName)) {
                mapConfig.setQuorumName(value);
                continue;
            }
            if ("query-caches".equals(nodeName)) {
                this.mapQueryCacheHandler(node, mapConfig);
                continue;
            }
            if (!"map-eviction-policy-class-name".equals(nodeName)) continue;
            String className = Preconditions.checkHasText(this.getTextContent(node), "map-eviction-policy-class-name cannot be null or empty");
            try {
                MapEvictionPolicy mapEvictionPolicy = (MapEvictionPolicy)ClassLoaderUtil.newInstance(this.config.getClassLoader(), className);
                mapConfig.setMapEvictionPolicy(mapEvictionPolicy);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        this.config.addMapConfig(mapConfig);
    }

    private NearCacheConfig handleNearCacheConfig(Node node) {
        String name = this.getAttribute(node, "name");
        NearCacheConfig nearCacheConfig = new NearCacheConfig(name);
        Boolean serializeKeys = null;
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            String value = this.getTextContent(child).trim();
            if ("max-size".equals(nodeName)) {
                nearCacheConfig.setMaxSize(Integer.parseInt(value));
                LOGGER.warning("The element <max-size/> for <near-cache/> is deprecated, please use <eviction/> instead!");
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                nearCacheConfig.setTimeToLiveSeconds(Integer.parseInt(value));
                continue;
            }
            if ("max-idle-seconds".equals(nodeName)) {
                nearCacheConfig.setMaxIdleSeconds(Integer.parseInt(value));
                continue;
            }
            if ("eviction-policy".equals(nodeName)) {
                nearCacheConfig.setEvictionPolicy(value);
                LOGGER.warning("The element <eviction-policy/> for <near-cache/> is deprecated, please use <eviction/> instead!");
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                nearCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("serialize-keys".equals(nodeName)) {
                serializeKeys = Boolean.parseBoolean(value);
                nearCacheConfig.setSerializeKeys(serializeKeys);
                continue;
            }
            if ("invalidate-on-change".equals(nodeName)) {
                nearCacheConfig.setInvalidateOnChange(Boolean.parseBoolean(value));
                continue;
            }
            if ("cache-local-entries".equals(nodeName)) {
                nearCacheConfig.setCacheLocalEntries(Boolean.parseBoolean(value));
                continue;
            }
            if ("local-update-policy".equals(nodeName)) {
                NearCacheConfig.LocalUpdatePolicy policy = NearCacheConfig.LocalUpdatePolicy.valueOf(value);
                nearCacheConfig.setLocalUpdatePolicy(policy);
                continue;
            }
            if (!"eviction".equals(nodeName)) continue;
            nearCacheConfig.setEvictionConfig(this.getEvictionConfig(child, true));
        }
        if (serializeKeys != null && !serializeKeys.booleanValue() && nearCacheConfig.getInMemoryFormat() == InMemoryFormat.NATIVE) {
            LOGGER.warning("The Near Cache doesn't support keys by-reference with NATIVE in-memory-format. This setting will have no effect!");
        }
        return nearCacheConfig;
    }

    private HotRestartConfig createHotRestartConfig(Node node) {
        HotRestartConfig hotRestartConfig = new HotRestartConfig();
        Node attrEnabled = node.getAttributes().getNamedItem("enabled");
        boolean enabled = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrEnabled));
        hotRestartConfig.setEnabled(enabled);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String name = XmlConfigBuilder.cleanNodeName(n);
            if (!"fsync".equals(name)) continue;
            hotRestartConfig.setFsync(XmlConfigBuilder.getBooleanValue(this.getTextContent(n)));
        }
        return hotRestartConfig;
    }

    private void handleCache(Node node) {
        String name = this.getAttribute(node, "name");
        CacheSimpleConfig cacheConfig = new CacheSimpleConfig();
        cacheConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("key-type".equals(nodeName)) {
                cacheConfig.setKeyType(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("value-type".equals(nodeName)) {
                cacheConfig.setValueType(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                cacheConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("management-enabled".equals(nodeName)) {
                cacheConfig.setManagementEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("read-through".equals(nodeName)) {
                cacheConfig.setReadThrough(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("write-through".equals(nodeName)) {
                cacheConfig.setWriteThrough(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if ("cache-loader-factory".equals(nodeName)) {
                cacheConfig.setCacheLoaderFactory(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("cache-loader".equals(nodeName)) {
                cacheConfig.setCacheLoader(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("cache-writer-factory".equals(nodeName)) {
                cacheConfig.setCacheWriterFactory(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("cache-writer".equals(nodeName)) {
                cacheConfig.setCacheWriter(this.getAttribute(n, "class-name"));
                continue;
            }
            if ("expiry-policy-factory".equals(nodeName)) {
                cacheConfig.setExpiryPolicyFactoryConfig(this.getExpiryPolicyFactoryConfig(n));
                continue;
            }
            if ("cache-entry-listeners".equals(nodeName)) {
                this.cacheListenerHandle(n, cacheConfig);
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                cacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                cacheConfig.setBackupCount(XmlConfigBuilder.getIntegerValue("backup-count", value));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                cacheConfig.setAsyncBackupCount(XmlConfigBuilder.getIntegerValue("async-backup-count", value));
                continue;
            }
            if ("wan-replication-ref".equals(nodeName)) {
                this.cacheWanReplicationRefHandle(n, cacheConfig);
                continue;
            }
            if ("eviction".equals(nodeName)) {
                cacheConfig.setEvictionConfig(this.getEvictionConfig(n, false));
                continue;
            }
            if ("quorum-ref".equals(nodeName)) {
                cacheConfig.setQuorumName(value);
                continue;
            }
            if ("partition-lost-listeners".equals(nodeName)) {
                this.cachePartitionLostListenerHandle(n, cacheConfig);
                continue;
            }
            if ("merge-policy".equals(nodeName)) {
                cacheConfig.setMergePolicy(value);
                continue;
            }
            if ("hot-restart".equals(nodeName)) {
                cacheConfig.setHotRestartConfig(this.createHotRestartConfig(n));
                continue;
            }
            if (!"disable-per-entry-invalidation-events".equals(nodeName)) continue;
            cacheConfig.setDisablePerEntryInvalidationEvents(XmlConfigBuilder.getBooleanValue(value));
        }
        try {
            ConfigValidator.checkCacheConfig(cacheConfig, null);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        this.config.addCacheConfig(cacheConfig);
    }

    private CacheSimpleConfig.ExpiryPolicyFactoryConfig getExpiryPolicyFactoryConfig(Node node) {
        String className = this.getAttribute(node, "class-name");
        if (!StringUtil.isNullOrEmpty(className)) {
            return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(className);
        }
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedExpiryPolicyFactoryConfig = null;
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if (!"timed-expiry-policy-factory".equals(nodeName)) continue;
            timedExpiryPolicyFactoryConfig = this.getTimedExpiryPolicyFactoryConfig(n);
        }
        if (timedExpiryPolicyFactoryConfig == null) {
            throw new InvalidConfigurationException("One of the \"class-name\" or \"timed-expire-policy-factory\" configuration is needed for expiry policy factory configuration");
        }
        return new CacheSimpleConfig.ExpiryPolicyFactoryConfig(timedExpiryPolicyFactoryConfig);
    }

    private CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig getTimedExpiryPolicyFactoryConfig(Node node) {
        String expiryPolicyTypeStr = this.getAttribute(node, "expiry-policy-type");
        String durationAmountStr = this.getAttribute(node, "duration-amount");
        String timeUnitStr = this.getAttribute(node, "time-unit");
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType expiryPolicyType = CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.valueOf(StringUtil.upperCaseInternal(expiryPolicyTypeStr));
        if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL && (StringUtil.isNullOrEmpty(durationAmountStr) || StringUtil.isNullOrEmpty(timeUnitStr))) {
            throw new InvalidConfigurationException("Both of the \"duration-amount\" or \"time-unit\" attributes are required for expiry policy factory configuration (except \"ETERNAL\" expiry policy type)");
        }
        CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig durationConfig = null;
        if (expiryPolicyType != CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig.ExpiryPolicyType.ETERNAL) {
            TimeUnit timeUnit;
            long durationAmount;
            try {
                durationAmount = Long.parseLong(durationAmountStr);
            }
            catch (NumberFormatException e) {
                throw new InvalidConfigurationException("Invalid value for duration amount: " + durationAmountStr, e);
            }
            if (durationAmount <= 0L) {
                throw new InvalidConfigurationException("Duration amount must be positive: " + durationAmount);
            }
            try {
                timeUnit = TimeUnit.valueOf(StringUtil.upperCaseInternal(timeUnitStr));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidConfigurationException("Invalid value for time unit: " + timeUnitStr, e);
            }
            durationConfig = new CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig(durationAmount, timeUnit);
        }
        return new CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig(expiryPolicyType, durationConfig);
    }

    private EvictionConfig getEvictionConfig(Node node, boolean isNearCache) {
        EvictionConfig evictionConfig = new EvictionConfig();
        Node size = node.getAttributes().getNamedItem("size");
        Node maxSizePolicy = node.getAttributes().getNamedItem("max-size-policy");
        Node evictionPolicy = node.getAttributes().getNamedItem("eviction-policy");
        Node comparatorClassName = node.getAttributes().getNamedItem("comparator-class-name");
        if (size != null) {
            evictionConfig.setSize(Integer.parseInt(this.getTextContent(size)));
        }
        if (maxSizePolicy != null) {
            evictionConfig.setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(maxSizePolicy))));
        }
        if (evictionPolicy != null) {
            evictionConfig.setEvictionPolicy(EvictionPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(evictionPolicy))));
        }
        if (comparatorClassName != null) {
            evictionConfig.setComparatorClassName(this.getTextContent(comparatorClassName));
        }
        try {
            ConfigValidator.checkEvictionConfig(evictionConfig, isNearCache);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException(e.getMessage());
        }
        return evictionConfig;
    }

    private void cacheWanReplicationRefHandle(Node n, CacheSimpleConfig cacheConfig) {
        WanReplicationRef wanReplicationRef = new WanReplicationRef();
        String wanName = this.getAttribute(n, "name");
        wanReplicationRef.setName(wanName);
        for (Node wanChild : XmlConfigBuilder.childElements(n)) {
            String wanChildName = XmlConfigBuilder.cleanNodeName(wanChild);
            String wanChildValue = this.getTextContent(wanChild);
            if ("merge-policy".equals(wanChildName)) {
                wanReplicationRef.setMergePolicy(wanChildValue);
                continue;
            }
            if ("filters".equals(wanChildName)) {
                this.handleWanFilters(wanChild, wanReplicationRef);
                continue;
            }
            if (!"republishing-enabled".equals(wanChildName)) continue;
            wanReplicationRef.setRepublishingEnabled(XmlConfigBuilder.getBooleanValue(wanChildValue));
        }
        cacheConfig.setWanReplicationRef(wanReplicationRef);
    }

    private void handleWanFilters(Node wanChild, WanReplicationRef wanReplicationRef) {
        for (Node filter : XmlConfigBuilder.childElements(wanChild)) {
            if (!"filter-impl".equals(XmlConfigBuilder.cleanNodeName(filter))) continue;
            wanReplicationRef.addFilter(this.getTextContent(filter));
        }
    }

    private void cachePartitionLostListenerHandle(Node n, CacheSimpleConfig cacheConfig) {
        for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
            if (!"partition-lost-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
            String listenerClass = this.getTextContent(listenerNode);
            cacheConfig.addCachePartitionLostListenerConfig(new CachePartitionLostListenerConfig(listenerClass));
        }
    }

    private void cacheListenerHandle(Node n, CacheSimpleConfig cacheSimpleConfig) {
        for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
            if (!"cache-entry-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
            CacheSimpleEntryListenerConfig listenerConfig = new CacheSimpleEntryListenerConfig();
            for (Node listenerChildNode : XmlConfigBuilder.childElements(listenerNode)) {
                if ("cache-entry-listener-factory".equals(XmlConfigBuilder.cleanNodeName(listenerChildNode))) {
                    listenerConfig.setCacheEntryListenerFactory(this.getAttribute(listenerChildNode, "class-name"));
                }
                if (!"cache-entry-event-filter-factory".equals(XmlConfigBuilder.cleanNodeName(listenerChildNode))) continue;
                listenerConfig.setCacheEntryEventFilterFactory(this.getAttribute(listenerChildNode, "class-name"));
            }
            NamedNodeMap attrs = listenerNode.getAttributes();
            listenerConfig.setOldValueRequired(XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("old-value-required"))));
            listenerConfig.setSynchronous(XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("synchronous"))));
            cacheSimpleConfig.addEntryListenerConfig(listenerConfig);
        }
    }

    private void mapWanReplicationRefHandle(Node n, MapConfig mapConfig) {
        WanReplicationRef wanReplicationRef = new WanReplicationRef();
        String wanName = this.getAttribute(n, "name");
        wanReplicationRef.setName(wanName);
        for (Node wanChild : XmlConfigBuilder.childElements(n)) {
            String wanChildName = XmlConfigBuilder.cleanNodeName(wanChild);
            String wanChildValue = this.getTextContent(wanChild);
            if ("merge-policy".equals(wanChildName)) {
                wanReplicationRef.setMergePolicy(wanChildValue);
                continue;
            }
            if ("republishing-enabled".equals(wanChildName)) {
                wanReplicationRef.setRepublishingEnabled(XmlConfigBuilder.getBooleanValue(wanChildValue));
                continue;
            }
            if (!"filters".equals(wanChildName)) continue;
            this.handleWanFilters(wanChild, wanReplicationRef);
        }
        mapConfig.setWanReplicationRef(wanReplicationRef);
    }

    private void mapIndexesHandle(Node n, MapConfig mapConfig) {
        for (Node indexNode : XmlConfigBuilder.childElements(n)) {
            if (!"index".equals(XmlConfigBuilder.cleanNodeName(indexNode))) continue;
            NamedNodeMap attrs = indexNode.getAttributes();
            boolean ordered = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("ordered")));
            String attribute = this.getTextContent(indexNode);
            mapConfig.addMapIndexConfig(new MapIndexConfig(attribute, ordered));
        }
    }

    private void queryCacheIndexesHandle(Node n, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : XmlConfigBuilder.childElements(n)) {
            if (!"index".equals(XmlConfigBuilder.cleanNodeName(indexNode))) continue;
            NamedNodeMap attrs = indexNode.getAttributes();
            boolean ordered = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("ordered")));
            String attribute = this.getTextContent(indexNode);
            queryCacheConfig.addIndexConfig(new MapIndexConfig(attribute, ordered));
        }
    }

    private void mapAttributesHandle(Node n, MapConfig mapConfig) {
        for (Node extractorNode : XmlConfigBuilder.childElements(n)) {
            if (!"attribute".equals(XmlConfigBuilder.cleanNodeName(extractorNode))) continue;
            NamedNodeMap attrs = extractorNode.getAttributes();
            String extractor = this.getTextContent(attrs.getNamedItem("extractor"));
            String name = this.getTextContent(extractorNode);
            mapConfig.addMapAttributeConfig(new MapAttributeConfig(name, extractor));
        }
    }

    private void mapEntryListenerHandle(Node n, MapConfig mapConfig) {
        for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
            if (!"entry-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
            NamedNodeMap attrs = listenerNode.getAttributes();
            boolean incValue = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("include-value")));
            boolean local = XmlConfigBuilder.getBooleanValue(this.getTextContent(attrs.getNamedItem("local")));
            String listenerClass = this.getTextContent(listenerNode);
            mapConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    private void mapPartitionLostListenerHandle(Node n, MapConfig mapConfig) {
        for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
            if (!"partition-lost-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
            String listenerClass = this.getTextContent(listenerNode);
            mapConfig.addMapPartitionLostListenerConfig(new MapPartitionLostListenerConfig(listenerClass));
        }
    }

    private void mapQueryCacheHandler(Node n, MapConfig mapConfig) {
        for (Node queryCacheNode : XmlConfigBuilder.childElements(n)) {
            if (!"query-cache".equals(XmlConfigBuilder.cleanNodeName(queryCacheNode))) continue;
            NamedNodeMap attrs = queryCacheNode.getAttributes();
            String cacheName = this.getTextContent(attrs.getNamedItem("name"));
            QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
            for (Node childNode : XmlConfigBuilder.childElements(queryCacheNode)) {
                String nodeName = XmlConfigBuilder.cleanNodeName(childNode);
                if ("entry-listeners".equals(nodeName)) {
                    for (Node listenerNode : XmlConfigBuilder.childElements(childNode)) {
                        if (!"entry-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                        NamedNodeMap listenerNodeAttributes = listenerNode.getAttributes();
                        boolean incValue = XmlConfigBuilder.getBooleanValue(this.getTextContent(listenerNodeAttributes.getNamedItem("include-value")));
                        boolean local = XmlConfigBuilder.getBooleanValue(this.getTextContent(listenerNodeAttributes.getNamedItem("local")));
                        String listenerClass = this.getTextContent(listenerNode);
                        queryCacheConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
                    }
                    continue;
                }
                String textContent = this.getTextContent(childNode);
                if ("include-value".equals(nodeName)) {
                    boolean includeValue = XmlConfigBuilder.getBooleanValue(textContent);
                    queryCacheConfig.setIncludeValue(includeValue);
                    continue;
                }
                if ("batch-size".equals(nodeName)) {
                    int batchSize = XmlConfigBuilder.getIntegerValue("batch-size", textContent.trim());
                    queryCacheConfig.setBatchSize(batchSize);
                    continue;
                }
                if ("buffer-size".equals(nodeName)) {
                    int bufferSize = XmlConfigBuilder.getIntegerValue("buffer-size", textContent.trim());
                    queryCacheConfig.setBufferSize(bufferSize);
                    continue;
                }
                if ("delay-seconds".equals(nodeName)) {
                    int delaySeconds = XmlConfigBuilder.getIntegerValue("delay-seconds", textContent.trim());
                    queryCacheConfig.setDelaySeconds(delaySeconds);
                    continue;
                }
                if ("in-memory-format".equals(nodeName)) {
                    String value = textContent.trim();
                    queryCacheConfig.setInMemoryFormat(InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
                    continue;
                }
                if ("coalesce".equals(nodeName)) {
                    boolean coalesce = XmlConfigBuilder.getBooleanValue(textContent);
                    queryCacheConfig.setCoalesce(coalesce);
                    continue;
                }
                if ("populate".equals(nodeName)) {
                    boolean populate = XmlConfigBuilder.getBooleanValue(textContent);
                    queryCacheConfig.setPopulate(populate);
                    continue;
                }
                if ("indexes".equals(nodeName)) {
                    this.queryCacheIndexesHandle(childNode, queryCacheConfig);
                    continue;
                }
                if ("predicate".equals(nodeName)) {
                    this.queryCachePredicateHandler(childNode, queryCacheConfig);
                    continue;
                }
                if (!"eviction".equals(nodeName)) continue;
                queryCacheConfig.setEvictionConfig(this.getEvictionConfig(childNode, false));
            }
            mapConfig.addQueryCacheConfig(queryCacheConfig);
        }
    }

    private void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        NamedNodeMap predicateAttributes = childNode.getAttributes();
        String predicateType = this.getTextContent(predicateAttributes.getNamedItem("type"));
        String textContent = this.getTextContent(childNode);
        PredicateConfig predicateConfig = new PredicateConfig();
        if ("class-name".equals(predicateType)) {
            predicateConfig.setClassName(textContent);
        } else if ("sql".equals(predicateType)) {
            predicateConfig.setSql(textContent);
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    private MapStoreConfig createMapStoreConfig(Node node) {
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            String value = this.getTextContent(att).trim();
            if ("enabled".equals(att.getNodeName())) {
                mapStoreConfig.setEnabled(XmlConfigBuilder.getBooleanValue(value));
                continue;
            }
            if (!"initial-mode".equals(att.getNodeName())) continue;
            MapStoreConfig.InitialLoadMode mode = MapStoreConfig.InitialLoadMode.valueOf(StringUtil.upperCaseInternal(this.getTextContent(att)));
            mapStoreConfig.setInitialLoadMode(mode);
        }
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("class-name".equals(nodeName)) {
                mapStoreConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("factory-class-name".equals(nodeName)) {
                mapStoreConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("write-delay-seconds".equals(nodeName)) {
                mapStoreConfig.setWriteDelaySeconds(XmlConfigBuilder.getIntegerValue("write-delay-seconds", this.getTextContent(n).trim()));
                continue;
            }
            if ("write-batch-size".equals(nodeName)) {
                mapStoreConfig.setWriteBatchSize(XmlConfigBuilder.getIntegerValue("write-batch-size", this.getTextContent(n).trim()));
                continue;
            }
            if ("write-coalescing".equals(nodeName)) {
                String writeCoalescing = this.getTextContent(n).trim();
                if (StringUtil.isNullOrEmpty(writeCoalescing)) {
                    mapStoreConfig.setWriteCoalescing(true);
                    continue;
                }
                mapStoreConfig.setWriteCoalescing(XmlConfigBuilder.getBooleanValue(writeCoalescing));
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, mapStoreConfig.getProperties());
        }
        return mapStoreConfig;
    }

    private RingbufferStoreConfig createRingbufferStoreConfig(Node node) {
        RingbufferStoreConfig config = new RingbufferStoreConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            String value = this.getTextContent(att).trim();
            if (!att.getNodeName().equals("enabled")) continue;
            config.setEnabled(XmlConfigBuilder.getBooleanValue(value));
        }
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("class-name".equals(nodeName)) {
                config.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("factory-class-name".equals(nodeName)) {
                config.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, config.getProperties());
        }
        return config;
    }

    private MergePolicyConfig createMergePolicyConfig(Node node) {
        MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();
        String policyString = this.getTextContent(node).trim();
        mergePolicyConfig.setPolicy(policyString);
        String att = this.getAttribute(node, "batch-size");
        if (att != null) {
            mergePolicyConfig.setBatchSize(XmlConfigBuilder.getIntegerValue("batch-size", att));
        }
        return mergePolicyConfig;
    }

    private QueueStoreConfig createQueueStoreConfig(Node node) {
        QueueStoreConfig queueStoreConfig = new QueueStoreConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            Node att = attributes.item(a);
            String value = this.getTextContent(att).trim();
            if (!att.getNodeName().equals("enabled")) continue;
            queueStoreConfig.setEnabled(XmlConfigBuilder.getBooleanValue(value));
        }
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("class-name".equals(nodeName)) {
                queueStoreConfig.setClassName(this.getTextContent(n).trim());
                continue;
            }
            if ("factory-class-name".equals(nodeName)) {
                queueStoreConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, queueStoreConfig.getProperties());
        }
        return queueStoreConfig;
    }

    private void handleSSLConfig(Node node) {
        SSLConfig sslConfig = new SSLConfig();
        NamedNodeMap attributes = node.getAttributes();
        Node enabledNode = attributes.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode).trim());
        sslConfig.setEnabled(enabled);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("factory-class-name".equals(nodeName)) {
                sslConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, sslConfig.getProperties());
        }
        this.config.getNetworkConfig().setSSLConfig(sslConfig);
    }

    private void handleMcMutualAuthConfig(Node node) {
        MCMutualAuthConfig mcMutualAuthConfig = new MCMutualAuthConfig();
        NamedNodeMap attributes = node.getAttributes();
        Node enabledNode = attributes.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode).trim());
        mcMutualAuthConfig.setEnabled(enabled);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("factory-class-name".equals(nodeName)) {
                mcMutualAuthConfig.setFactoryClassName(this.getTextContent(n).trim());
                continue;
            }
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(n, mcMutualAuthConfig.getProperties());
        }
        this.config.getManagementCenterConfig().setMutualAuthConfig(mcMutualAuthConfig);
    }

    private void handleMemberAddressProvider(Node node) {
        Node enabledNode = node.getAttributes().getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode));
        MemberAddressProviderConfig memberAddressProviderConfig = this.config.getNetworkConfig().getMemberAddressProviderConfig();
        memberAddressProviderConfig.setEnabled(enabled);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if (nodeName.equals("class-name")) {
                String className = this.getTextContent(n);
                memberAddressProviderConfig.setClassName(className);
                continue;
            }
            if (!nodeName.equals("properties")) continue;
            this.fillProperties(n, memberAddressProviderConfig.getProperties());
        }
    }

    private void handleFailureDetector(Node node) {
        if (!node.hasChildNodes()) {
            return;
        }
        for (Node child : XmlConfigBuilder.childElements(node)) {
            if (!XmlConfigBuilder.cleanNodeName(child).equals("icmp")) {
                throw new IllegalStateException("Unsupported child under failure-detector");
            }
            Node enabledNode = child.getAttributes().getNamedItem("enabled");
            boolean enabled = enabledNode != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode));
            IcmpFailureDetectorConfig icmpFailureDetectorConfig = new IcmpFailureDetectorConfig();
            icmpFailureDetectorConfig.setEnabled(enabled);
            for (Node n : XmlConfigBuilder.childElements(child)) {
                String nodeName = XmlConfigBuilder.cleanNodeName(n);
                if (nodeName.equals("ttl")) {
                    int ttl = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfig.setTtl(ttl);
                    continue;
                }
                if (nodeName.equals("timeout-milliseconds")) {
                    int timeout = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfig.setTimeoutMilliseconds(timeout);
                    continue;
                }
                if (nodeName.equals("parallel-mode")) {
                    boolean mode = Boolean.parseBoolean(this.getTextContent(n));
                    icmpFailureDetectorConfig.setParallelMode(mode);
                    continue;
                }
                if (nodeName.equals("fail-fast-on-startup")) {
                    boolean failOnStartup = Boolean.parseBoolean(this.getTextContent(n));
                    icmpFailureDetectorConfig.setFailFastOnStartup(failOnStartup);
                    continue;
                }
                if (nodeName.equals("max-attempts")) {
                    int attempts = Integer.parseInt(this.getTextContent(n));
                    icmpFailureDetectorConfig.setMaxAttempts(attempts);
                    continue;
                }
                if (!nodeName.equals("interval-milliseconds")) continue;
                int interval = Integer.parseInt(this.getTextContent(n));
                icmpFailureDetectorConfig.setIntervalMilliseconds(interval);
            }
            this.config.getNetworkConfig().setIcmpFailureDetectorConfig(icmpFailureDetectorConfig);
        }
    }

    private void handleSocketInterceptorConfig(Node node) {
        SocketInterceptorConfig socketInterceptorConfig = this.parseSocketInterceptorConfig(node);
        this.config.getNetworkConfig().setSocketInterceptorConfig(socketInterceptorConfig);
    }

    private void handleTopic(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        TopicConfig tConfig = new TopicConfig();
        tConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if (nodeName.equals("global-ordering-enabled")) {
                tConfig.setGlobalOrderingEnabled(XmlConfigBuilder.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if ("message-listeners".equals(nodeName)) {
                for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                    if (!"message-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                    tConfig.addMessageListenerConfig(new ListenerConfig(this.getTextContent(listenerNode)));
                }
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                tConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if (!"multi-threading-enabled".equals(nodeName)) continue;
            tConfig.setMultiThreadingEnabled(XmlConfigBuilder.getBooleanValue(this.getTextContent(n)));
        }
        this.config.addTopicConfig(tConfig);
    }

    private void handleReliableTopic(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        ReliableTopicConfig topicConfig = new ReliableTopicConfig(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            if ("read-batch-size".equals(nodeName)) {
                String batchSize = this.getTextContent(n);
                topicConfig.setReadBatchSize(XmlConfigBuilder.getIntegerValue("read-batch-size", batchSize));
                continue;
            }
            if ("statistics-enabled".equals(nodeName)) {
                topicConfig.setStatisticsEnabled(XmlConfigBuilder.getBooleanValue(this.getTextContent(n)));
                continue;
            }
            if ("topic-overload-policy".equals(nodeName)) {
                TopicOverloadPolicy topicOverloadPolicy = TopicOverloadPolicy.valueOf(StringUtil.upperCaseInternal(this.getTextContent(n)));
                topicConfig.setTopicOverloadPolicy(topicOverloadPolicy);
                continue;
            }
            if (!"message-listeners".equals(nodeName)) continue;
            for (Node listenerNode : XmlConfigBuilder.childElements(n)) {
                if (!"message-listener".equals(XmlConfigBuilder.cleanNodeName(listenerNode))) continue;
                topicConfig.addMessageListenerConfig(new ListenerConfig(this.getTextContent(listenerNode)));
            }
        }
        this.config.addReliableTopicConfig(topicConfig);
    }

    private void handleJobTracker(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        JobTrackerConfig jConfig = new JobTrackerConfig();
        jConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("max-thread-size".equals(nodeName)) {
                jConfig.setMaxThreadSize(XmlConfigBuilder.getIntegerValue("max-thread-size", value));
                continue;
            }
            if ("queue-size".equals(nodeName)) {
                jConfig.setQueueSize(XmlConfigBuilder.getIntegerValue("queue-size", value));
                continue;
            }
            if ("retry-count".equals(nodeName)) {
                jConfig.setRetryCount(XmlConfigBuilder.getIntegerValue("retry-count", value));
                continue;
            }
            if ("chunk-size".equals(nodeName)) {
                jConfig.setChunkSize(XmlConfigBuilder.getIntegerValue("chunk-size", value));
                continue;
            }
            if ("communicate-stats".equals(nodeName)) {
                jConfig.setCommunicateStats(value.length() == 0 ? true : Boolean.parseBoolean(value));
                continue;
            }
            if (!"topology-changed-stategy".equals(nodeName)) continue;
            TopologyChangedStrategy topologyChangedStrategy = JobTrackerConfig.DEFAULT_TOPOLOGY_CHANGED_STRATEGY;
            for (TopologyChangedStrategy temp : TopologyChangedStrategy.values()) {
                if (!temp.name().equals(value)) continue;
                topologyChangedStrategy = temp;
            }
            jConfig.setTopologyChangedStrategy(topologyChangedStrategy);
        }
        this.config.addJobTrackerConfig(jConfig);
    }

    private void handleSemaphore(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        SemaphoreConfig sConfig = new SemaphoreConfig();
        sConfig.setName(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("initial-permits".equals(nodeName)) {
                sConfig.setInitialPermits(XmlConfigBuilder.getIntegerValue("initial-permits", value));
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                sConfig.setBackupCount(XmlConfigBuilder.getIntegerValue("backup-count", value));
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                sConfig.setAsyncBackupCount(XmlConfigBuilder.getIntegerValue("async-backup-count", value));
                continue;
            }
            if (!"quorum-ref".equals(nodeName)) continue;
            sConfig.setQuorumName(value);
        }
        this.config.addSemaphoreConfig(sConfig);
    }

    private void handleEventJournal(Node node) throws Exception {
        EventJournalConfig journalConfig = new EventJournalConfig();
        this.handleViaReflection(node, this.config, journalConfig);
        this.config.addEventJournalConfig(journalConfig);
    }

    private void handleMerkleTree(Node node) throws Exception {
        MerkleTreeConfig merkleTreeConfig = new MerkleTreeConfig();
        this.handleViaReflection(node, this.config, merkleTreeConfig);
        this.config.addMerkleTreeConfig(merkleTreeConfig);
    }

    private void handleRingbuffer(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        RingbufferConfig rbConfig = new RingbufferConfig(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("capacity".equals(nodeName)) {
                int capacity = XmlConfigBuilder.getIntegerValue("capacity", value);
                rbConfig.setCapacity(capacity);
                continue;
            }
            if ("backup-count".equals(nodeName)) {
                int backupCount = XmlConfigBuilder.getIntegerValue("backup-count", value);
                rbConfig.setBackupCount(backupCount);
                continue;
            }
            if ("async-backup-count".equals(nodeName)) {
                int asyncBackupCount = XmlConfigBuilder.getIntegerValue("async-backup-count", value);
                rbConfig.setAsyncBackupCount(asyncBackupCount);
                continue;
            }
            if ("time-to-live-seconds".equals(nodeName)) {
                int timeToLiveSeconds = XmlConfigBuilder.getIntegerValue("time-to-live-seconds", value);
                rbConfig.setTimeToLiveSeconds(timeToLiveSeconds);
                continue;
            }
            if ("in-memory-format".equals(nodeName)) {
                InMemoryFormat inMemoryFormat = InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value));
                rbConfig.setInMemoryFormat(inMemoryFormat);
                continue;
            }
            if ("ringbuffer-store".equals(nodeName)) {
                RingbufferStoreConfig ringbufferStoreConfig = this.createRingbufferStoreConfig(n);
                rbConfig.setRingbufferStoreConfig(ringbufferStoreConfig);
                continue;
            }
            if ("quorum-ref".equals(nodeName)) {
                rbConfig.setQuorumName(value);
                continue;
            }
            if (!"merge-policy".equals(nodeName)) continue;
            MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
            rbConfig.setMergePolicyConfig(mergePolicyConfig);
        }
        this.config.addRingBufferConfig(rbConfig);
    }

    private void handleAtomicLong(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        AtomicLongConfig atomicLongConfig = new AtomicLongConfig(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("merge-policy".equals(nodeName)) {
                MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
                atomicLongConfig.setMergePolicyConfig(mergePolicyConfig);
                continue;
            }
            if (!"quorum-ref".equals(nodeName)) continue;
            atomicLongConfig.setQuorumName(value);
        }
        this.config.addAtomicLongConfig(atomicLongConfig);
    }

    private void handleAtomicReference(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        AtomicReferenceConfig atomicReferenceConfig = new AtomicReferenceConfig(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if ("merge-policy".equals(nodeName)) {
                MergePolicyConfig mergePolicyConfig = this.createMergePolicyConfig(n);
                atomicReferenceConfig.setMergePolicyConfig(mergePolicyConfig);
                continue;
            }
            if (!"quorum-ref".equals(nodeName)) continue;
            atomicReferenceConfig.setQuorumName(value);
        }
        this.config.addAtomicReferenceConfig(atomicReferenceConfig);
    }

    private void handleCountDownLatchConfig(Node node) {
        Node attName = node.getAttributes().getNamedItem("name");
        String name = this.getTextContent(attName);
        CountDownLatchConfig countDownLatchConfig = new CountDownLatchConfig(name);
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(n);
            String value = this.getTextContent(n).trim();
            if (!"quorum-ref".equals(nodeName)) continue;
            countDownLatchConfig.setQuorumName(value);
        }
        this.config.addCountDownLatchConfig(countDownLatchConfig);
    }

    private void handleListeners(Node node) {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            if (!"listener".equals(XmlConfigBuilder.cleanNodeName(child))) continue;
            String listenerClass = this.getTextContent(child);
            this.config.addListenerConfig(new ListenerConfig(listenerClass));
        }
    }

    private void handlePartitionGroup(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node enabledNode = attributes.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode));
        this.config.getPartitionGroupConfig().setEnabled(enabled);
        Node groupTypeNode = attributes.getNamedItem("group-type");
        PartitionGroupConfig.MemberGroupType groupType = groupTypeNode != null ? PartitionGroupConfig.MemberGroupType.valueOf(StringUtil.upperCaseInternal(this.getTextContent(groupTypeNode))) : PartitionGroupConfig.MemberGroupType.PER_MEMBER;
        this.config.getPartitionGroupConfig().setGroupType(groupType);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            if (!"member-group".equals(XmlConfigBuilder.cleanNodeName(child))) continue;
            this.handleMemberGroup(child);
        }
    }

    private void handleMemberGroup(Node node) {
        MemberGroupConfig memberGroupConfig = new MemberGroupConfig();
        for (Node child : XmlConfigBuilder.childElements(node)) {
            if (!"interface".equals(XmlConfigBuilder.cleanNodeName(child))) continue;
            String value = this.getTextContent(child);
            memberGroupConfig.addInterface(value);
        }
        this.config.getPartitionGroupConfig().addMemberGroupConfig(memberGroupConfig);
    }

    private void handleSerialization(Node node) {
        SerializationConfig serializationConfig = this.parseSerialization(node);
        this.config.setSerializationConfig(serializationConfig);
    }

    private void handleManagementCenterConfig(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        Node enabledNode = attrs.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode));
        Node intervalNode = attrs.getNamedItem("update-interval");
        int interval = intervalNode != null ? XmlConfigBuilder.getIntegerValue("update-interval", this.getTextContent(intervalNode)) : 3;
        ManagementCenterConfig managementCenterConfig = this.config.getManagementCenterConfig();
        managementCenterConfig.setEnabled(enabled);
        managementCenterConfig.setUpdateInterval(interval);
        boolean isComplexType = false;
        List<String> complexTypeElements = Arrays.asList("url", "mutual-auth");
        for (Node c : XmlConfigBuilder.childElements(node)) {
            if (!complexTypeElements.contains(c.getNodeName())) continue;
            isComplexType = true;
            break;
        }
        if (!isComplexType) {
            String url = this.getTextContent(node);
            managementCenterConfig.setUrl("".equals(url) ? null : url);
        } else {
            for (Node child : XmlConfigBuilder.childElements(node)) {
                if ("url".equals(XmlConfigBuilder.cleanNodeName(child))) {
                    String url = this.getTextContent(child);
                    managementCenterConfig.setUrl(url);
                    continue;
                }
                if (!"mutual-auth".equals(XmlConfigBuilder.cleanNodeName(child))) continue;
                this.handleMcMutualAuthConfig(child);
            }
        }
    }

    private void handleSecurity(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node enabledNode = attributes.getNamedItem("enabled");
        boolean enabled = enabledNode != null && XmlConfigBuilder.getBooleanValue(this.getTextContent(enabledNode));
        this.config.getSecurityConfig().setEnabled(enabled);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if ("member-credentials-factory".equals(nodeName)) {
                this.handleCredentialsFactory(child);
                continue;
            }
            if ("member-login-modules".equals(nodeName)) {
                this.handleLoginModules(child, true);
                continue;
            }
            if ("client-login-modules".equals(nodeName)) {
                this.handleLoginModules(child, false);
                continue;
            }
            if ("client-permission-policy".equals(nodeName)) {
                this.handlePermissionPolicy(child);
                continue;
            }
            if ("client-permissions".equals(nodeName)) {
                this.handleSecurityPermissions(child);
                continue;
            }
            if ("security-interceptors".equals(nodeName)) {
                this.handleSecurityInterceptors(child);
                continue;
            }
            if (!"client-block-unmapped-actions".equals(nodeName)) continue;
            this.config.getSecurityConfig().setClientBlockUnmappedActions(XmlConfigBuilder.getBooleanValue(this.getTextContent(child)));
        }
    }

    private void handleSecurityInterceptors(Node node) {
        SecurityConfig cfg = this.config.getSecurityConfig();
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"interceptor".equals(nodeName)) continue;
            NamedNodeMap attrs = child.getAttributes();
            Node classNameNode = attrs.getNamedItem("class-name");
            String className = this.getTextContent(classNameNode);
            cfg.addSecurityInterceptorConfig(new SecurityInterceptorConfig(className));
        }
    }

    private void handleMemberAttributes(Node node) {
        for (Node n : XmlConfigBuilder.childElements(node)) {
            String name = XmlConfigBuilder.cleanNodeName(n);
            if (!"attribute".equals(name)) continue;
            String attributeName = this.getTextContent(n.getAttributes().getNamedItem("name"));
            String attributeType = this.getTextContent(n.getAttributes().getNamedItem("type"));
            String value = this.getTextContent(n);
            if ("string".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setStringAttribute(attributeName, value);
                continue;
            }
            if ("boolean".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setBooleanAttribute(attributeName, Boolean.parseBoolean(value));
                continue;
            }
            if ("byte".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setByteAttribute(attributeName, Byte.parseByte(value));
                continue;
            }
            if ("double".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setDoubleAttribute(attributeName, Double.parseDouble(value));
                continue;
            }
            if ("float".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setFloatAttribute(attributeName, Float.parseFloat(value));
                continue;
            }
            if ("int".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setIntAttribute(attributeName, Integer.parseInt(value));
                continue;
            }
            if ("long".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setLongAttribute(attributeName, Long.parseLong(value));
                continue;
            }
            if ("short".equals(attributeType)) {
                this.config.getMemberAttributeConfig().setShortAttribute(attributeName, Short.parseShort(value));
                continue;
            }
            this.config.getMemberAttributeConfig().setStringAttribute(attributeName, value);
        }
    }

    private void handleCredentialsFactory(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        SecurityConfig cfg = this.config.getSecurityConfig();
        CredentialsFactoryConfig credentialsFactoryConfig = new CredentialsFactoryConfig(className);
        cfg.setMemberCredentialsConfig(credentialsFactoryConfig);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(child, credentialsFactoryConfig.getProperties());
            break;
        }
    }

    private void handleLoginModules(Node node, boolean member) {
        SecurityConfig cfg = this.config.getSecurityConfig();
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"login-module".equals(nodeName)) continue;
            LoginModuleConfig lm = this.handleLoginModule(child);
            if (member) {
                cfg.addMemberLoginModuleConfig(lm);
                continue;
            }
            cfg.addClientLoginModuleConfig(lm);
        }
    }

    private LoginModuleConfig handleLoginModule(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        Node usageNode = attrs.getNamedItem("usage");
        LoginModuleConfig.LoginModuleUsage usage = usageNode != null ? LoginModuleConfig.LoginModuleUsage.get(this.getTextContent(usageNode)) : LoginModuleConfig.LoginModuleUsage.REQUIRED;
        LoginModuleConfig moduleConfig = new LoginModuleConfig(className, usage);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(child, moduleConfig.getProperties());
            break;
        }
        return moduleConfig;
    }

    private void handlePermissionPolicy(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        Node classNameNode = attrs.getNamedItem("class-name");
        String className = this.getTextContent(classNameNode);
        SecurityConfig cfg = this.config.getSecurityConfig();
        PermissionPolicyConfig policyConfig = new PermissionPolicyConfig(className);
        cfg.setClientPolicyConfig(policyConfig);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"properties".equals(nodeName)) continue;
            this.fillProperties(child, policyConfig.getProperties());
            break;
        }
    }

    private void handleSecurityPermissions(Node node) {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            PermissionConfig.PermissionType type;
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if ("map-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.MAP;
            } else if ("queue-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.QUEUE;
            } else if ("multimap-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.MULTIMAP;
            } else if ("topic-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.TOPIC;
            } else if ("list-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.LIST;
            } else if ("set-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.SET;
            } else if ("lock-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.LOCK;
            } else if ("atomic-long-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.ATOMIC_LONG;
            } else if ("countdown-latch-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.COUNTDOWN_LATCH;
            } else if ("semaphore-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.SEMAPHORE;
            } else if ("id-generator-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.ID_GENERATOR;
            } else if ("flake-id-generator-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.FLAKE_ID_GENERATOR;
            } else if ("executor-service-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.EXECUTOR_SERVICE;
            } else if ("transaction-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.TRANSACTION;
            } else if ("all-permissions".equals(nodeName)) {
                type = PermissionConfig.PermissionType.ALL;
            } else if ("durable-executor-service-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.DURABLE_EXECUTOR_SERVICE;
            } else if ("cardinality-estimator-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.CARDINALITY_ESTIMATOR;
            } else if ("scheduled-executor-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.SCHEDULED_EXECUTOR;
            } else if ("pn-counter-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.PN_COUNTER;
            } else if ("cache-permission".equals(nodeName)) {
                type = PermissionConfig.PermissionType.CACHE;
            } else if ("user-code-deployment".equals(nodeName)) {
                type = PermissionConfig.PermissionType.USER_CODE_DEPLOYMENT;
            } else {
                if (!PermissionConfig.PermissionType.CONFIG.getNodeName().equals(nodeName)) continue;
                type = PermissionConfig.PermissionType.CONFIG;
            }
            this.handleSecurityPermission(child, type);
        }
    }

    private void handleSecurityPermission(Node node, PermissionConfig.PermissionType type) {
        SecurityConfig cfg = this.config.getSecurityConfig();
        NamedNodeMap attrs = node.getAttributes();
        Node nameNode = attrs.getNamedItem("name");
        String name = nameNode != null ? this.getTextContent(nameNode) : "*";
        Node principalNode = attrs.getNamedItem("principal");
        String principal = principalNode != null ? this.getTextContent(principalNode) : "*";
        PermissionConfig permConfig = new PermissionConfig(type, name, principal);
        cfg.addClientPermissionConfig(permConfig);
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if ("endpoints".equals(nodeName)) {
                this.handleSecurityPermissionEndpoints(child, permConfig);
                continue;
            }
            if (!"actions".equals(nodeName)) continue;
            this.handleSecurityPermissionActions(child, permConfig);
        }
    }

    private void handleSecurityPermissionEndpoints(Node node, PermissionConfig permConfig) {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"endpoint".equals(nodeName)) continue;
            permConfig.addEndpoint(this.getTextContent(child).trim());
        }
    }

    private void handleSecurityPermissionActions(Node node, PermissionConfig permConfig) {
        for (Node child : XmlConfigBuilder.childElements(node)) {
            String nodeName = XmlConfigBuilder.cleanNodeName(child);
            if (!"action".equals(nodeName)) continue;
            permConfig.addAction(this.getTextContent(child).trim());
        }
    }
}

