/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.ConfigDataSerializerHook;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.WANQueueFullBehavior;
import com.hazelcast.config.WanPublisherState;
import com.hazelcast.config.WanSyncConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class WanPublisherConfig
implements IdentifiedDataSerializable,
Versioned {
    private static final int DEFAULT_QUEUE_CAPACITY = 10000;
    private static final WANQueueFullBehavior DEFAULT_QUEUE_FULL_BEHAVIOR = WANQueueFullBehavior.DISCARD_AFTER_MUTATION;
    private String groupName = "dev";
    private int queueCapacity = 10000;
    private WANQueueFullBehavior queueFullBehavior = DEFAULT_QUEUE_FULL_BEHAVIOR;
    private WanPublisherState initialPublisherState = WanPublisherState.REPLICATING;
    private Map<String, Comparable> properties = new HashMap<String, Comparable>();
    private String className;
    private Object implementation;
    private AwsConfig awsConfig = new AwsConfig();
    private DiscoveryConfig discoveryConfig = new DiscoveryConfig();
    private WanSyncConfig wanSyncConfig = new WanSyncConfig();

    public WanSyncConfig getWanSyncConfig() {
        return this.wanSyncConfig;
    }

    public WanPublisherConfig setWanSyncConfig(WanSyncConfig wanSyncConfig) {
        this.wanSyncConfig = wanSyncConfig;
        return this;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public WanPublisherConfig setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public WanPublisherConfig setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    public WANQueueFullBehavior getQueueFullBehavior() {
        return this.queueFullBehavior;
    }

    public WanPublisherConfig setQueueFullBehavior(WANQueueFullBehavior queueFullBehavior) {
        this.queueFullBehavior = queueFullBehavior;
        return this;
    }

    public WanPublisherState getInitialPublisherState() {
        return this.initialPublisherState;
    }

    public WanPublisherConfig setInitialPublisherState(WanPublisherState initialPublisherState) {
        Preconditions.checkNotNull(initialPublisherState, "Initial WAN publisher state must not be null");
        this.initialPublisherState = initialPublisherState;
        return this;
    }

    public Map<String, Comparable> getProperties() {
        return this.properties;
    }

    public WanPublisherConfig setProperties(Map<String, Comparable> properties) {
        this.properties = properties;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public WanPublisherConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public WanPublisherConfig setImplementation(Object implementation) {
        this.implementation = implementation;
        return this;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public WanPublisherConfig setAwsConfig(AwsConfig awsConfig) {
        this.awsConfig = Preconditions.isNotNull(awsConfig, "awsConfig");
        return this;
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public WanPublisherConfig setDiscoveryConfig(DiscoveryConfig discoveryConfig) {
        this.discoveryConfig = Preconditions.isNotNull(discoveryConfig, "discoveryProvidersConfig");
        return this;
    }

    public String toString() {
        return "WanPublisherConfig{groupName='" + this.groupName + '\'' + ", queueCapacity=" + this.queueCapacity + ", queueFullBehavior=" + (Object)((Object)this.queueFullBehavior) + ", initialPublisherState=" + (Object)((Object)this.initialPublisherState) + ", wanSyncConfig=" + this.wanSyncConfig + ", properties=" + this.properties + ", className='" + this.className + '\'' + ", implementation=" + this.implementation + ", awsConfig=" + this.awsConfig + ", discoveryConfig=" + this.discoveryConfig + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.groupName);
        out.writeInt(this.queueCapacity);
        out.writeInt(this.queueFullBehavior.getId());
        int size = this.properties.size();
        out.writeInt(size);
        for (Map.Entry<String, Comparable> entry : this.properties.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeUTF(this.className);
        out.writeObject(this.implementation);
        if (out.getVersion().isGreaterOrEqual(Versions.V3_11)) {
            out.writeByte(this.initialPublisherState.getId());
            out.writeObject(this.wanSyncConfig);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.groupName = in.readUTF();
        this.queueCapacity = in.readInt();
        this.queueFullBehavior = WANQueueFullBehavior.getByType(in.readInt());
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.properties.put(in.readUTF(), (Comparable)in.readObject());
        }
        this.className = in.readUTF();
        this.implementation = in.readObject();
        if (in.getVersion().isGreaterOrEqual(Versions.V3_11)) {
            this.initialPublisherState = WanPublisherState.getByType(in.readByte());
            this.wanSyncConfig = (WanSyncConfig)in.readObject();
        }
    }
}

