/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.clientside.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.LockForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.LockGetLockCountCodec;
import com.hazelcast.client.impl.protocol.codec.LockGetRemainingLeaseTimeCodec;
import com.hazelcast.client.impl.protocol.codec.LockIsLockedByCurrentThreadCodec;
import com.hazelcast.client.impl.protocol.codec.LockIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.LockLockCodec;
import com.hazelcast.client.impl.protocol.codec.LockTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.LockUnlockCodec;
import com.hazelcast.client.proxy.ClientConditionProxy;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.ICondition;
import com.hazelcast.core.ILock;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class ClientLockProxy
extends PartitionSpecificClientProxy
implements ILock {
    private ClientLockReferenceIdGenerator referenceIdGenerator;

    public ClientLockProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    @Override
    @Deprecated
    public Object getKey() {
        return this.name;
    }

    @Override
    public boolean isLocked() {
        ClientMessage request = LockIsLockedCodec.encodeRequest(this.name);
        LockIsLockedCodec.ResponseParameters resultParameters = LockIsLockedCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public boolean isLockedByCurrentThread() {
        ClientMessage request = LockIsLockedByCurrentThreadCodec.encodeRequest(this.name, ThreadUtil.getThreadId());
        LockIsLockedByCurrentThreadCodec.ResponseParameters resultParameters = LockIsLockedByCurrentThreadCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public int getLockCount() {
        ClientMessage request = LockGetLockCountCodec.encodeRequest(this.name);
        LockGetLockCountCodec.ResponseParameters resultParameters = LockGetLockCountCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public long getRemainingLeaseTime() {
        ClientMessage request = LockGetRemainingLeaseTimeCodec.encodeRequest(this.name);
        LockGetRemainingLeaseTimeCodec.ResponseParameters resultParameters = LockGetRemainingLeaseTimeCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public void lock(long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkPositive(leaseTime, "leaseTime should be positive");
        ClientMessage request = LockLockCodec.encodeRequest(this.name, this.getTimeInMillis(leaseTime, timeUnit), ThreadUtil.getThreadId(), this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    @Override
    public void forceUnlock() {
        ClientMessage request = LockForceUnlockCodec.encodeRequest(this.name, this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    @Override
    public ICondition newCondition(String name) {
        Preconditions.checkNotNull(name, "Condition name can't be null");
        ClientConditionProxy clientConditionProxy = new ClientConditionProxy(this, name, this.getContext());
        clientConditionProxy.onInitialize();
        return clientConditionProxy;
    }

    @Override
    public void lock() {
        ClientMessage request = LockLockCodec.encodeRequest(this.name, -1L, ThreadUtil.getThreadId(), this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        ClientMessage request = LockLockCodec.encodeRequest(this.name, -1L, ThreadUtil.getThreadId(), this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartitionInterruptibly(request);
    }

    @Override
    public boolean tryLock() {
        try {
            return this.tryLock(0L, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryLock(timeout, unit, Long.MAX_VALUE, null);
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        long timeoutInMillis = this.getTimeInMillis(timeout, unit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        long threadId = ThreadUtil.getThreadId();
        ClientMessage request = LockTryLockCodec.encodeRequest(this.name, threadId, leaseTimeInMillis, timeoutInMillis, this.referenceIdGenerator.getNextReferenceId());
        LockTryLockCodec.ResponseParameters resultParameters = LockTryLockCodec.decodeResponse(this.invokeOnPartition(request));
        return resultParameters.response;
    }

    @Override
    public void unlock() {
        ClientMessage request = LockUnlockCodec.encodeRequest(this.name, ThreadUtil.getThreadId(), this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    public String toString() {
        return "ILock{name='" + this.name + '\'' + '}';
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.referenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
    }
}

