/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapSetTTLCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapPartitionMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.nio.Connection;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.Operation;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class MapSetTTLMessageTask
extends AbstractMapPartitionMessageTask<MapSetTTLCodec.RequestParameters> {
    public MapSetTTLMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected void beforeProcess() {
        super.beforeProcess();
        if (this.nodeEngine.getClusterService().getClusterVersion().isLessThan(Versions.V3_11)) {
            throw new UnsupportedOperationException("Modifying TTL is available when cluster version is 3.11 or higher");
        }
    }

    @Override
    protected Operation prepareOperation() {
        MapOperationProvider operationProvider = this.getMapOperationProvider(((MapSetTTLCodec.RequestParameters)this.parameters).name);
        return operationProvider.createSetTTLOperation(((MapSetTTLCodec.RequestParameters)this.parameters).name, ((MapSetTTLCodec.RequestParameters)this.parameters).key, ((MapSetTTLCodec.RequestParameters)this.parameters).ttl);
    }

    @Override
    protected MapSetTTLCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapSetTTLCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapSetTTLCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapSetTTLCodec.RequestParameters)this.parameters).name, "remove");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapSetTTLCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "setTTL";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapSetTTLCodec.RequestParameters)this.parameters).key, ((MapSetTTLCodec.RequestParameters)this.parameters).ttl, TimeUnit.MILLISECONDS};
    }
}

