/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.eviction;

import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.operation.CacheClearExpiredOperation;
import com.hazelcast.internal.eviction.ClearExpiredRecordsTask;
import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationQueue;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CacheClearExpiredRecordsTask
extends ClearExpiredRecordsTask<CachePartitionSegment>
implements OperationResponseHandler {
    public static final String PROP_CLEANUP_PERCENTAGE = "hazelcast.internal.cache.expiration.cleanup.percentage";
    public static final String PROP_CLEANUP_OPERATION_COUNT = "hazelcast.internal.cache.expiration.cleanup.operation.count";
    public static final String PROP_TASK_PERIOD_SECONDS = "hazelcast.internal.cache.expiration.task.period.seconds";
    public static final int DEFAULT_TASK_PERIOD_SECONDS = 5;
    public static final HazelcastProperty TASK_PERIOD_SECONDS = new HazelcastProperty("hazelcast.internal.cache.expiration.task.period.seconds", 5, TimeUnit.SECONDS);
    public static final int DEFAULT_CLEANUP_PERCENTAGE = 10;
    public static final int MAX_EXPIRED_KEY_COUNT_IN_BATCH = 100;
    public static final HazelcastProperty CLEANUP_PERCENTAGE = new HazelcastProperty("hazelcast.internal.cache.expiration.cleanup.percentage", 10);
    public static final HazelcastProperty CLEANUP_OPERATION_COUNT = new HazelcastProperty("hazelcast.internal.cache.expiration.cleanup.operation.count");
    private final Comparator<CachePartitionSegment> partitionSegmentComparator = new Comparator<CachePartitionSegment>(){

        @Override
        public int compare(CachePartitionSegment o1, CachePartitionSegment o2) {
            long s2;
            long s1 = o1.getLastCleanupTimeBeforeSorting();
            return s1 < (s2 = o2.getLastCleanupTimeBeforeSorting()) ? -1 : (s1 == s2 ? 0 : 1);
        }
    };

    public CacheClearExpiredRecordsTask(NodeEngine nodeEngine, CachePartitionSegment[] containers) {
        super(nodeEngine, containers, CLEANUP_OPERATION_COUNT, CLEANUP_PERCENTAGE, TASK_PERIOD_SECONDS);
    }

    @Override
    protected boolean hasExpiredKeyToSendBackup(CachePartitionSegment container) {
        Iterator<ICacheRecordStore> iterator = container.recordStoreIterator();
        while (iterator.hasNext()) {
            ICacheRecordStore store = iterator.next();
            if (store.getExpiredKeys().size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasRunningCleanup(CachePartitionSegment container) {
        return container.hasRunningCleanupOperation();
    }

    @Override
    protected void setHasRunningCleanup(CachePartitionSegment container, boolean status) {
        container.setRunningCleanupOperation(status);
    }

    @Override
    protected boolean isContainerEmpty(CachePartitionSegment container) {
        Iterator<ICacheRecordStore> iterator = container.recordStoreIterator();
        while (iterator.hasNext()) {
            ICacheRecordStore store = iterator.next();
            if (store.size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean notHaveAnyExpirableRecord(CachePartitionSegment container) {
        Iterator<ICacheRecordStore> iterator = container.recordStoreIterator();
        while (iterator.hasNext()) {
            ICacheRecordStore store = iterator.next();
            if (!store.isExpirable()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected long getLastCleanupTime(CachePartitionSegment container) {
        return container.getLastCleanupTime();
    }

    @Override
    protected void clearLeftoverExpiredKeyQueues(CachePartitionSegment container) {
        Iterator<ICacheRecordStore> iterator = container.recordStoreIterator();
        while (iterator.hasNext()) {
            ICacheRecordStore store = iterator.next();
            InvalidationQueue<ExpiredKey> expiredKeys = store.getExpiredKeys();
            expiredKeys.clear();
        }
    }

    @Override
    protected void sortPartitionContainers(List<CachePartitionSegment> containers) {
        for (CachePartitionSegment segment : containers) {
            segment.storeLastCleanupTime();
        }
        Collections.sort(containers, this.partitionSegmentComparator);
    }

    public void sendResponse(Operation op, Object response) {
        CachePartitionSegment container = ((CachePartitionSegment[])this.containers)[op.getPartitionId()];
        this.doBackupExpiration(container);
    }

    private void doBackupExpiration(CachePartitionSegment container) {
        Iterator<ICacheRecordStore> iterator = container.recordStoreIterator();
        while (iterator.hasNext()) {
            AbstractCacheRecordStore store = (AbstractCacheRecordStore)iterator.next();
            store.sendBackupExpirations(false);
        }
    }

    @Override
    protected Operation createExpirationOperation(int expirationPercentage, CachePartitionSegment container) {
        int partitionId = container.getPartitionId();
        return new CacheClearExpiredOperation(expirationPercentage).setNodeEngine(this.nodeEngine).setCallerUuid(this.nodeEngine.getLocalMember().getUuid()).setPartitionId(partitionId).setValidateTarget(false).setServiceName("hz:impl:cacheService").setOperationResponseHandler(this);
    }
}

