/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.subscriber.AbstractQueryCacheConfigurator;
import java.util.Map;

public class ClientQueryCacheConfigurator
extends AbstractQueryCacheConfigurator {
    private final ClientConfig clientConfig;

    public ClientQueryCacheConfigurator(ClientConfig clientConfig, QueryCacheEventService eventService) {
        super(clientConfig.getClassLoader(), eventService);
        this.clientConfig = clientConfig;
    }

    @Override
    public QueryCacheConfig getOrCreateConfiguration(String mapName, String cacheName, String cacheId) {
        QueryCacheConfig config = this.clientConfig.getOrCreateQueryCacheConfig(mapName, cacheName);
        this.setPredicateImpl(config);
        this.setEntryListener(mapName, cacheId, config);
        return config;
    }

    @Override
    public QueryCacheConfig getOrNull(String mapName, String cacheName) {
        return this.clientConfig.getOrNullQueryCacheConfig(mapName, cacheName);
    }

    @Override
    public void removeConfiguration(String mapName, String cacheName) {
        Map<String, Map<String, QueryCacheConfig>> allQueryCacheConfig = this.clientConfig.getQueryCacheConfigs();
        Map<String, QueryCacheConfig> mapQueryCacheConfig = allQueryCacheConfig.get(mapName);
        if (mapQueryCacheConfig == null || mapQueryCacheConfig.isEmpty()) {
            return;
        }
        mapQueryCacheConfig.remove(cacheName);
    }
}

