/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.operations;

import com.hazelcast.core.IFunction;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.client.PortableReadResultSet;
import com.hazelcast.ringbuffer.impl.operations.AbstractRingBufferOperation;
import com.hazelcast.spi.BlockingOperation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;
import java.util.ArrayList;

public class ReadManyOperation<O>
extends AbstractRingBufferOperation
implements BlockingOperation,
ReadonlyOperation {
    transient long sequence;
    private int minSize;
    private int maxSize;
    private long startSequence;
    private IFunction<O, Boolean> filter;
    private boolean returnPortable;
    private transient ReadResultSetImpl<O, O> resultSet;

    public ReadManyOperation() {
    }

    public ReadManyOperation(String name, long startSequence, int minSize, int maxSize, IFunction<O, Boolean> filter) {
        this(name, startSequence, minSize, maxSize, filter, false);
    }

    public ReadManyOperation(String name, long startSequence, int minSize, int maxSize, IFunction<O, Boolean> filter, boolean returnPortable) {
        super(name);
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.startSequence = startSequence;
        this.filter = filter;
        this.returnPortable = returnPortable;
    }

    @Override
    public void beforeRun() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        ringbuffer.checkBlockableReadSequence(this.startSequence);
    }

    @Override
    public boolean shouldWait() {
        if (this.resultSet == null) {
            this.resultSet = new ReadResultSetImpl(this.minSize, this.maxSize, this.getNodeEngine().getSerializationService(), this.filter);
            this.sequence = this.startSequence;
        }
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        if (this.minSize == 0) {
            if (!ringbuffer.shouldWait(this.sequence)) {
                this.sequence = ringbuffer.readMany(this.sequence, this.resultSet);
            }
            return false;
        }
        if (this.resultSet.isMinSizeReached()) {
            return false;
        }
        if (ringbuffer.shouldWait(this.sequence)) {
            return true;
        }
        this.sequence = ringbuffer.readMany(this.sequence, this.resultSet);
        return !this.resultSet.isMinSizeReached();
    }

    @Override
    public void run() throws Exception {
    }

    @Override
    public Object getResponse() {
        if (this.returnPortable) {
            ArrayList<Data> items = new ArrayList<Data>(this.resultSet.size());
            long[] seqs = new long[this.resultSet.size()];
            Data[] dataItems = this.resultSet.getDataItems();
            for (int k = 0; k < this.resultSet.size(); ++k) {
                items.add(dataItems[k]);
                seqs[k] = this.resultSet.getSequence(k);
            }
            PortableReadResultSet portableReadResultSet = new PortableReadResultSet(this.resultSet.readCount(), items, seqs, this.resultSet.getNextSequenceToReadFrom());
            return this.getNodeEngine().toData(portableReadResultSet);
        }
        return this.resultSet;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        return ringbuffer.getRingEmptyWaitNotifyKey();
    }

    @Override
    public void onWaitExpire() {
    }

    @Override
    public int getId() {
        return 6;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.startSequence);
        out.writeInt(this.minSize);
        out.writeInt(this.maxSize);
        out.writeObject(this.filter);
        out.writeBoolean(this.returnPortable);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.startSequence = in.readLong();
        this.minSize = in.readInt();
        this.maxSize = in.readInt();
        this.filter = (IFunction)in.readObject();
        this.returnPortable = in.readBoolean();
    }
}

