/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.operations.AbstractRingBufferOperation;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.util.MapUtil;
import java.io.IOException;
import java.util.Map;

public class MergeBackupOperation
extends AbstractRingBufferOperation
implements BackupOperation {
    private Map<Long, Data> backupEntries;

    public MergeBackupOperation() {
    }

    MergeBackupOperation(String name, Map<Long, Data> backupEntries) {
        super(name);
        this.backupEntries = backupEntries;
    }

    @Override
    public void run() throws Exception {
        RingbufferContainer ringbuffer = this.getRingBufferContainer();
        for (Map.Entry<Long, Data> entry : this.backupEntries.entrySet()) {
            ringbuffer.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.backupEntries.size());
        for (Map.Entry<Long, Data> entry : this.backupEntries.entrySet()) {
            out.writeLong(entry.getKey());
            out.writeData(entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.backupEntries = MapUtil.createHashMap(size);
        for (int i = 0; i < size; ++i) {
            this.backupEntries.put(in.readLong(), in.readData());
        }
    }
}

