/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl;

import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.replicatedmap.impl.PartitionContainer;
import com.hazelcast.replicatedmap.impl.ReplicatedMapMergeRunnable;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.replicatedmap.merge.MergePolicyProvider;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.merge.AbstractSplitBrainHandlerService;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

class ReplicatedMapSplitBrainHandlerService
extends AbstractSplitBrainHandlerService<ReplicatedRecordStore> {
    private final ReplicatedMapService service;
    private final MergePolicyProvider mergePolicyProvider;

    ReplicatedMapSplitBrainHandlerService(ReplicatedMapService service, MergePolicyProvider mergePolicyProvider) {
        super(service.getNodeEngine());
        this.service = service;
        this.mergePolicyProvider = mergePolicyProvider;
    }

    @Override
    protected Runnable newMergeRunnable(Map<String, Collection<ReplicatedRecordStore>> collectedStores, Map<String, Collection<ReplicatedRecordStore>> collectedStoresWithLegacyPolicies, Collection<ReplicatedRecordStore> backupStores, NodeEngine nodeEngine) {
        return new ReplicatedMapMergeRunnable(collectedStores, collectedStoresWithLegacyPolicies, backupStores, this.service.getNodeEngine(), this);
    }

    @Override
    protected String getDataStructureName(ReplicatedRecordStore recordStore) {
        return recordStore.getName();
    }

    @Override
    protected Object getMergePolicy(String dataStructureName) {
        MergePolicyConfig mergePolicyConfig = this.getReplicatedMapConfig(dataStructureName).getMergePolicyConfig();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyConfig.getPolicy());
    }

    @Override
    protected Collection<Iterator<ReplicatedRecordStore>> iteratorsOf(int partitionId) {
        PartitionContainer partitionContainer = this.service.getPartitionContainer(partitionId);
        if (partitionContainer == null) {
            return Collections.emptyList();
        }
        ConcurrentMap<String, ReplicatedRecordStore> stores = partitionContainer.getStores();
        return Collections.singletonList(stores.values().iterator());
    }

    @Override
    protected void destroyStore(ReplicatedRecordStore store) {
        store.destroy();
    }

    public ReplicatedMapConfig getReplicatedMapConfig(String name) {
        return this.service.getReplicatedMapConfig(name);
    }
}

