/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.TargetNotMemberException;

public final class FetchPartitionStateOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation {
    private PartitionRuntimeState partitionState;

    @Override
    public void run() {
        NodeEngine nodeEngine;
        Address master;
        Address caller = this.getCallerAddress();
        if (!caller.equals(master = (nodeEngine = this.getNodeEngine()).getMasterAddress())) {
            String msg = caller + " requested our partition table but it's not our known master. " + "Master: " + master;
            this.getLogger().warning(msg);
            throw new IllegalStateException(msg);
        }
        InternalPartitionServiceImpl service = (InternalPartitionServiceImpl)this.getService();
        this.partitionState = service.createPartitionStateInternal();
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException || throwable instanceof CallerNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public Object getResponse() {
        return this.partitionState;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getId() {
        return 4;
    }
}

