/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomicreference.operations;

import com.hazelcast.concurrent.atomicreference.AtomicReferenceService;
import com.hazelcast.concurrent.atomicreference.operations.AtomicReferenceBackupAwareOperation;
import com.hazelcast.concurrent.atomicreference.operations.SetBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.MergingValue;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.serialization.SerializationService;
import java.io.IOException;

public class MergeOperation
extends AtomicReferenceBackupAwareOperation {
    private SplitBrainMergePolicy mergePolicy;
    private Data mergingValue;
    private transient Data backupValue;

    public MergeOperation() {
    }

    public MergeOperation(String name, SplitBrainMergePolicy mergePolicy, Data mergingValue) {
        super(name);
        this.mergePolicy = mergePolicy;
        this.mergingValue = mergingValue;
    }

    @Override
    public void run() throws Exception {
        AtomicReferenceService service = (AtomicReferenceService)this.getService();
        boolean isExistingContainer = service.containsReferenceContainer(this.name);
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        MergingValue<Data> mergeValue = MergingValueFactory.createMergingValue(serializationService, this.mergingValue);
        this.backupValue = this.getReferenceContainer().merge(mergeValue, this.mergePolicy, isExistingContainer, serializationService);
    }

    @Override
    public boolean shouldBackup() {
        return this.backupValue != null;
    }

    @Override
    public Operation getBackupOperation() {
        return new SetBackupOperation(this.name, this.backupValue);
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mergePolicy);
        out.writeData(this.mergingValue);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mergePolicy = (SplitBrainMergePolicy)in.readObject();
        this.mergingValue = in.readData();
    }
}

