/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.MergingValue;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.serialization.SerializationService;

public class AtomicLongContainer {
    private long value;

    public long get() {
        return this.value;
    }

    public long addAndGet(long delta) {
        this.value += delta;
        return this.value;
    }

    public void set(long value) {
        this.value = value;
    }

    public boolean compareAndSet(long expect, long value) {
        if (this.value != expect) {
            return false;
        }
        this.value = value;
        return true;
    }

    public long getAndAdd(long delta) {
        long tempValue = this.value;
        this.value += delta;
        return tempValue;
    }

    public long getAndSet(long value) {
        long tempValue = this.value;
        this.value = value;
        return tempValue;
    }

    public Long merge(MergingValue<Long> mergingValue, SplitBrainMergePolicy mergePolicy, boolean isExistingContainer, SerializationService serializationService) {
        serializationService.getManagedContext().initialize(mergingValue);
        serializationService.getManagedContext().initialize(mergePolicy);
        if (isExistingContainer) {
            MergingValue<Long> existingValue = MergingValueFactory.createMergingValue(serializationService, this.value);
            Long newValue = mergePolicy.merge(mergingValue, existingValue);
            if (newValue != null && !newValue.equals(this.value)) {
                this.value = newValue;
                return newValue;
            }
        } else {
            Long newValue = mergePolicy.merge(mergingValue, null);
            if (newValue != null) {
                this.value = newValue;
                return newValue;
            }
        }
        return null;
    }
}

